/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.cache.StatementCache;
import org.vibur.dbcp.cache.StatementHolder;
import org.vibur.dbcp.proxy.ChildObjectInvocationHandler;
import org.vibur.dbcp.proxy.ExceptionCollector;
import org.vibur.dbcp.proxy.Proxy;
import org.vibur.dbcp.util.QueryUtils;
import org.vibur.dbcp.util.ViburUtils;

class StatementInvocationHandler
extends ChildObjectInvocationHandler<Connection, Statement> {
    private static final Logger logger = LoggerFactory.getLogger(StatementInvocationHandler.class);
    private final StatementHolder statement;
    private final StatementCache statementCache;
    private final ViburConfig config;
    private final boolean logSlowQuery;
    private final boolean logQueryParams;
    private final List<Object[]> queryParams;

    StatementInvocationHandler(StatementHolder statement, StatementCache statementCache, Connection connProxy, ViburConfig config, ExceptionCollector exceptionCollector) {
        super(statement.value(), connProxy, "getConnection", config, exceptionCollector);
        this.config = config;
        this.statement = statement;
        this.statementCache = statementCache;
        this.logSlowQuery = config.getLogQueryExecutionLongerThanMs() >= 0L;
        boolean logLargeResult = config.getLogLargeResultSet() >= 0L;
        this.logQueryParams = config.isIncludeQueryParameters() && (this.logSlowQuery || logLargeResult);
        this.queryParams = this.logQueryParams ? new LinkedList() : null;
    }

    @Override
    Object unrestrictedInvoke(Statement proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName == "close") {
            return this.processClose(method, args);
        }
        if (methodName == "isClosed") {
            return this.isClosed();
        }
        return super.unrestrictedInvoke(proxy, method, args);
    }

    @Override
    Object restrictedInvoke(Statement proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("set")) {
            return this.processSet(method, args);
        }
        if (methodName.startsWith("execute")) {
            return this.processExecute(proxy, method, args);
        }
        if (methodName == "getResultSet" || methodName == "getGeneratedKeys") {
            return this.newProxiedResultSet(proxy, method, args);
        }
        if (methodName == "cancel") {
            return this.processCancel(method, args);
        }
        return super.restrictedInvoke(proxy, method, args);
    }

    @Override
    void logTargetInvokeFailure(Method method, Object[] args, Throwable t) {
        if (method.getName().startsWith("execute")) {
            if (logger.isDebugEnabled()) {
                logger.debug("SQL query execution from pool {}:\n{}\n-- threw:", new Object[]{ViburUtils.getPoolName(this.config), QueryUtils.formatSql(QueryUtils.getSqlQuery((Statement)this.getTarget(), args), this.queryParams), t});
            }
        } else {
            super.logTargetInvokeFailure(method, args, t);
        }
    }

    private Object processClose(Method method, Object[] args) throws Throwable {
        if (!this.close()) {
            return null;
        }
        if (this.statementCache == null) {
            return this.targetInvoke(method, args);
        }
        this.statementCache.restore(this.statement, this.config.isClearSQLWarnings());
        return null;
    }

    private Object processCancel(Method method, Object[] args) throws Throwable {
        if (this.statementCache != null) {
            this.statementCache.remove((Statement)this.getTarget());
        }
        return this.targetInvoke(method, args);
    }

    private Object processSet(Method method, Object[] args) throws Throwable {
        if (this.logQueryParams && args != null && args.length >= 2) {
            this.addQueryParams(method, args);
        }
        return this.targetInvoke(method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processExecute(Statement proxy, Method method, Object[] args) throws Throwable {
        long startTime = this.logSlowQuery ? System.currentTimeMillis() : 0L;
        try {
            if (method.getName() == "executeQuery") {
                ResultSet resultSet = this.newProxiedResultSet(proxy, method, args);
                return resultSet;
            }
            Object object = this.targetInvoke(method, args);
            return object;
        }
        finally {
            if (this.logSlowQuery) {
                this.logQuery(proxy, args, startTime);
            }
        }
    }

    private ResultSet newProxiedResultSet(Statement proxy, Method method, Object[] args) throws Throwable {
        ResultSet rawResultSet = (ResultSet)this.targetInvoke(method, args);
        return Proxy.newProxyResultSet(rawResultSet, proxy, args, this.queryParams, this.config, this.getExceptionCollector());
    }

    private void addQueryParams(Method method, Object[] args) {
        Object[] params = new Object[args.length + 1];
        params[0] = method.getName();
        System.arraycopy(args, 0, params, 1, args.length);
        this.queryParams.add(params);
    }

    private void logQuery(Statement proxy, Object[] args, long startTime) {
        long timeTaken = System.currentTimeMillis() - startTime;
        if (timeTaken >= this.config.getLogQueryExecutionLongerThanMs()) {
            this.config.getViburLogger().logQuery(ViburUtils.getPoolName(this.config), QueryUtils.getSqlQuery(proxy, args), this.queryParams, timeTaken, this.config.isLogStackTraceForLongQueryExecution() ? new Throwable().getStackTrace() : null);
        }
    }
}

