/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.ViburDBCPException;

public final class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);

    private JdbcUtils() {
    }

    public static void initLoginTimeout(ViburConfig config) throws ViburDBCPException {
        int loginTimeout = config.getLoginTimeoutInSeconds();
        if (config.getExternalDataSource() == null) {
            DriverManager.setLoginTimeout(loginTimeout);
        } else {
            try {
                config.getExternalDataSource().setLoginTimeout(loginTimeout);
            }
            catch (SQLException e) {
                throw new ViburDBCPException(e);
            }
        }
    }

    public static void setDefaultValues(Connection rawConnection, ViburConfig config) throws SQLException {
        if (config.getDefaultAutoCommit() != null) {
            rawConnection.setAutoCommit(config.getDefaultAutoCommit());
        }
        if (config.getDefaultReadOnly() != null) {
            rawConnection.setReadOnly(config.getDefaultReadOnly());
        }
        if (config.getDefaultTransactionIsolationValue() != null) {
            rawConnection.setTransactionIsolation(config.getDefaultTransactionIsolationValue());
        }
        if (config.getDefaultCatalog() != null) {
            rawConnection.setCatalog(config.getDefaultCatalog());
        }
    }

    public static boolean validateConnection(Connection rawConnection, String query, ViburConfig config) throws SQLException {
        if (query == null) {
            return true;
        }
        if (query.equals("isValid")) {
            return rawConnection.isValid(config.getValidateTimeoutInSeconds());
        }
        return JdbcUtils.executeValidationQuery(rawConnection, query, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeValidationQuery(Connection rawConnection, String query, ViburConfig config) throws SQLException {
        int oldTimeout = JdbcUtils.setNetworkTimeoutIfDifferent(rawConnection, config);
        Statement rawStatement = null;
        try {
            rawStatement = rawConnection.createStatement();
            rawStatement.setQueryTimeout(config.getValidateTimeoutInSeconds());
            rawStatement.execute(query);
        }
        finally {
            JdbcUtils.quietClose(rawStatement);
        }
        JdbcUtils.resetNetworkTimeout(rawConnection, config.getNetworkTimeoutExecutor(), oldTimeout);
        return true;
    }

    private static int setNetworkTimeoutIfDifferent(Connection rawConnection, ViburConfig config) throws SQLException {
        int oldTimeout;
        int newTimeout;
        if (config.isUseNetworkTimeout() && (newTimeout = (int)TimeUnit.SECONDS.toMillis(config.getValidateTimeoutInSeconds())) != (oldTimeout = rawConnection.getNetworkTimeout())) {
            rawConnection.setNetworkTimeout(config.getNetworkTimeoutExecutor(), newTimeout);
            return oldTimeout;
        }
        return -1;
    }

    private static void resetNetworkTimeout(Connection rawConnection, Executor executor, int oldTimeout) throws SQLException {
        if (oldTimeout >= 0) {
            rawConnection.setNetworkTimeout(executor, oldTimeout);
        }
    }

    public static void clearWarnings(Connection rawConnection) throws SQLException {
        rawConnection.clearWarnings();
    }

    public static void clearWarnings(Statement rawStatement) throws SQLException {
        rawStatement.clearWarnings();
    }

    public static void quietClose(Connection rawConnection) {
        try {
            if (rawConnection != null) {
                rawConnection.close();
            }
        }
        catch (SQLException e) {
            logger.debug("Couldn't close {}", (Object)rawConnection, (Object)e);
        }
        catch (RuntimeException e) {
            logger.warn("Unexpected exception thrown by the JDBC driver for {}", (Object)rawConnection, (Object)e);
        }
    }

    public static void quietClose(Statement rawStatement) {
        try {
            if (rawStatement != null) {
                rawStatement.close();
            }
        }
        catch (SQLException e) {
            logger.debug("Couldn't close {}", (Object)rawStatement, (Object)e);
        }
        catch (RuntimeException e) {
            logger.warn("Unexpected exception thrown by the JDBC driver for {}", (Object)rawStatement, (Object)e);
        }
    }

    public static class DataSourceCredentialsConnector
    implements Connector {
        private final DataSource externalDataSource;
        private final String username;
        private final String password;

        public DataSourceCredentialsConnector(ViburConfig config) {
            this.externalDataSource = config.getExternalDataSource();
            this.username = config.getUsername();
            this.password = config.getPassword();
        }

        @Override
        public Connection connect() throws SQLException {
            return this.externalDataSource.getConnection(this.username, this.password);
        }
    }

    public static class DataSourceDefaultConnector
    implements Connector {
        private final DataSource externalDataSource;

        public DataSourceDefaultConnector(ViburConfig config) {
            this.externalDataSource = config.getExternalDataSource();
        }

        @Override
        public Connection connect() throws SQLException {
            return this.externalDataSource.getConnection();
        }
    }

    public static class DriverConnector
    implements Connector {
        private final Driver driver;
        private final String jdbcUrl;
        private final Properties driverProperties;

        public DriverConnector(ViburConfig config) {
            this.driver = config.getDriver();
            this.jdbcUrl = config.getJdbcUrl();
            this.driverProperties = config.getDriverProperties();
        }

        @Override
        public Connection connect() throws SQLException {
            return this.driver.connect(this.jdbcUrl, this.driverProperties);
        }
    }

    public static interface Connector {
        public Connection connect() throws SQLException;
    }
}

