/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.ViburObjectFactory;
import org.vibur.dbcp.proxy.Proxy;
import org.vibur.dbcp.util.ViburUtils;
import org.vibur.objectpool.PoolService;

public class PoolOperations {
    private static final Logger logger = LoggerFactory.getLogger(PoolOperations.class);
    private final ViburConfig config;
    private final PoolService<ConnHolder> poolService;
    private final ViburObjectFactory connectionFactory;
    private final Set<String> criticalSQLStates;

    public PoolOperations(ViburObjectFactory connectionFactory, PoolService<ConnHolder> poolService, ViburConfig config) {
        this.config = config;
        this.poolService = poolService;
        this.connectionFactory = connectionFactory;
        this.criticalSQLStates = new HashSet<String>(Arrays.asList(config.getCriticalSQLStates().replaceAll("\\s", "").split(",")));
    }

    public Connection getProxyConnection(long timeout) throws SQLException {
        try {
            return this.doGetProxyConnection(timeout);
        }
        catch (ViburDBCPException e) {
            return ViburUtils.unwrapSQLException(e);
        }
    }

    private Connection doGetProxyConnection(long timeout) throws SQLException, ViburDBCPException {
        ConnHolder conn;
        ConnHolder connHolder = conn = timeout == 0L ? (ConnHolder)this.poolService.take() : (ConnHolder)this.poolService.tryTake(timeout, TimeUnit.MILLISECONDS);
        if (conn != null) {
            logger.trace("Getting {}", (Object)conn.value());
            return Proxy.newProxyConnection(conn, this, this.config);
        }
        if (this.poolService.isTerminated()) {
            throw new SQLException(String.format("Pool %s, the poolService is terminated.", this.config.getName()), "VI001");
        }
        if (this.config.isLogTakenConnectionsOnTimeout() && logger.isWarnEnabled()) {
            logger.warn("Pool {}, couldn't obtain SQL connection within {}ms, full list of taken connections begins:\n{}", new Object[]{ViburUtils.getPoolName(this.config), timeout, this.config.takenConnectionsToString()});
        }
        throw new SQLException(String.format("Pool %s, couldn't obtain SQL connection within %dms.", ViburUtils.getPoolName(this.config), timeout), "VI002", (int)timeout);
    }

    public void restore(ConnHolder conn, boolean valid, List<Throwable> errors) {
        boolean reusable = valid && errors.isEmpty() && conn.version() == this.connectionFactory.version();
        this.poolService.restore((Object)conn, reusable);
        this.processSQLExceptions(conn, errors);
    }

    private void processSQLExceptions(ConnHolder conn, List<Throwable> errors) {
        int connVersion = conn.version();
        SQLException criticalException = this.getCriticalSQLException(errors);
        if (criticalException != null && this.connectionFactory.compareAndSetVersion(connVersion, connVersion + 1)) {
            int destroyed = this.config.getPool().drainCreated();
            logger.error("Critical SQLState {} occurred, destroyed {} connections from pool {}, current connection version is {}.", new Object[]{criticalException.getSQLState(), destroyed, this.config.getName(), this.connectionFactory.version(), criticalException});
        }
    }

    private SQLException getCriticalSQLException(List<Throwable> errors) {
        for (Throwable error : errors) {
            SQLException sqlException;
            if (!(error instanceof SQLException) || !this.isCriticalSQLException(sqlException = (SQLException)error)) continue;
            return sqlException;
        }
        return null;
    }

    private boolean isCriticalSQLException(SQLException sqlException) {
        if (sqlException == null) {
            return false;
        }
        if (this.criticalSQLStates.contains(sqlException.getSQLState())) {
            return true;
        }
        return this.isCriticalSQLException(sqlException.getNextException());
    }
}

