/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.sql.Driver;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.Connector;
import org.vibur.dbcp.pool.HookHolder;
import org.vibur.dbcp.pool.PoolReducer;
import org.vibur.dbcp.pool.ViburObjectFactory;
import org.vibur.dbcp.stcache.StatementCache;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ConcurrentCollection;
import org.vibur.objectpool.util.ConcurrentLinkedDequeCollection;
import org.vibur.objectpool.util.ThreadedPoolReducer;

public abstract class ViburConfig {
    private static final Logger logger = LoggerFactory.getLogger(ViburConfig.class);
    public static final String DEFAULT_PROPERTIES_CONFIG_FILE_NAME = "vibur-dbcp-config.properties";
    public static final String DEFAULT_XML_CONFIG_FILE_NAME = "vibur-dbcp-config.xml";
    public static final String SQLSTATE_POOL_NOTSTARTED_ERROR = "VI000";
    public static final String SQLSTATE_POOL_CLOSED_ERROR = "VI001";
    public static final String SQLSTATE_TIMEOUT_ERROR = "VI002";
    public static final String SQLSTATE_CONN_INIT_ERROR = "VI003";
    public static final String SQLSTATE_INTERRUPTED_ERROR = "VI004";
    public static final String SQLSTATE_OBJECT_CLOSED_ERROR = "VI005";
    public static final String SQLSTATE_WRAPPER_ERROR = "VI006";
    static final int STATEMENT_CACHE_MAX_SIZE = 2000;
    private String username;
    private String password;
    private Driver driver = null;
    private Properties driverProperties = null;
    private String driverClassName = null;
    private String jdbcUrl;
    private DataSource externalDataSource = null;
    private Connector connector = null;
    private int connectionIdleLimitInSeconds = 5;
    private int validateTimeoutInSeconds = 3;
    public static final String IS_VALID_QUERY = "isValid";
    private String testConnectionQuery = "isValid";
    private String initSQL = null;
    private boolean useNetworkTimeout = false;
    private Executor networkTimeoutExecutor = null;
    private int poolInitialSize = 5;
    private int poolMaxSize = 50;
    private boolean poolFair = true;
    private boolean poolEnableConnectionTracking = false;
    private PoolService<ConnHolder> pool = null;
    private ConcurrentCollection<ConnHolder> concurrentCollection = new ConcurrentLinkedDequeCollection();
    private ViburObjectFactory connectionFactory = null;
    private ThreadedPoolReducer poolReducer = null;
    private String poolReducerClass = PoolReducer.class.getName();
    private int reducerTimeIntervalInSeconds = 30;
    private int reducerSamples = 15;
    private boolean allowConnectionAfterTermination = false;
    private boolean allowUnwrapping = true;
    private static final AtomicInteger idGenerator = new AtomicInteger(1);
    private final String defaultName;
    private String name = this.defaultName = "p" + idGenerator.getAndIncrement();
    private boolean enableJMX = true;
    private long connectionTimeoutInMs = 15000L;
    private int loginTimeoutInSeconds = 5;
    private long acquireRetryDelayInMs = 500L;
    private int acquireRetryAttempts = 3;
    private int statementCacheMaxSize = 0;
    private StatementCache statementCache = null;
    private String criticalSQLStates = "08001,08006,08007,08S01,57P01,57P02,57P03,JZ0C0,JZ0C1";
    private long logConnectionLongerThanMs = 3000L;
    private boolean logStackTraceForLongConnection = false;
    private long logQueryExecutionLongerThanMs = 3000L;
    private boolean logStackTraceForLongQueryExecution = false;
    private long logLargeResultSet = 500L;
    private boolean logStackTraceForLargeResultSet = false;
    private boolean includeQueryParameters = true;
    private boolean logTakenConnectionsOnTimeout = false;
    private boolean logAllStackTracesOnTimeout = false;
    private boolean resetDefaultsAfterUse = false;
    private Boolean defaultAutoCommit;
    private Boolean defaultReadOnly;
    private String defaultTransactionIsolation;
    private String defaultCatalog;
    private Integer defaultTransactionIsolationIntValue;
    private boolean clearSQLWarnings = false;
    private final HookHolder.ConnHooks connHooks = HookHolder.newConnHooks();
    private final HookHolder.InvocationHooks invocationHooks = HookHolder.newInvocationHooks();

    ViburConfig() {
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    public Properties getDriverProperties() {
        return this.driverProperties;
    }

    public void setDriverProperties(Properties driverProperties) {
        this.driverProperties = driverProperties;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public DataSource getExternalDataSource() {
        return this.externalDataSource;
    }

    public void setExternalDataSource(DataSource externalDataSource) {
        this.externalDataSource = externalDataSource;
    }

    public Connector getConnector() {
        return this.connector;
    }

    protected void setConnector(Connector connector) {
        this.connector = connector;
    }

    public int getConnectionIdleLimitInSeconds() {
        return this.connectionIdleLimitInSeconds;
    }

    public void setConnectionIdleLimitInSeconds(int connectionIdleLimitInSeconds) {
        this.connectionIdleLimitInSeconds = connectionIdleLimitInSeconds;
    }

    public int getValidateTimeoutInSeconds() {
        return this.validateTimeoutInSeconds;
    }

    public void setValidateTimeoutInSeconds(int validateTimeoutInSeconds) {
        this.validateTimeoutInSeconds = validateTimeoutInSeconds;
    }

    public String getTestConnectionQuery() {
        return this.testConnectionQuery;
    }

    public void setTestConnectionQuery(String testConnectionQuery) {
        this.testConnectionQuery = testConnectionQuery;
    }

    public String getInitSQL() {
        return this.initSQL;
    }

    public void setInitSQL(String initSQL) {
        this.initSQL = initSQL;
    }

    public boolean isUseNetworkTimeout() {
        return this.useNetworkTimeout;
    }

    public void setUseNetworkTimeout(boolean useNetworkTimeout) {
        this.useNetworkTimeout = useNetworkTimeout;
    }

    public Executor getNetworkTimeoutExecutor() {
        return this.networkTimeoutExecutor;
    }

    public void setNetworkTimeoutExecutor(Executor networkTimeoutExecutor) {
        this.networkTimeoutExecutor = networkTimeoutExecutor;
    }

    public int getPoolInitialSize() {
        return this.poolInitialSize;
    }

    public void setPoolInitialSize(int poolInitialSize) {
        this.poolInitialSize = poolInitialSize;
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }

    public boolean isPoolFair() {
        return this.poolFair;
    }

    public void setPoolFair(boolean poolFair) {
        this.poolFair = poolFair;
    }

    public boolean isPoolEnableConnectionTracking() {
        return this.poolEnableConnectionTracking;
    }

    public void setPoolEnableConnectionTracking(boolean poolEnableConnectionTracking) {
        this.poolEnableConnectionTracking = poolEnableConnectionTracking;
    }

    public PoolService<ConnHolder> getPool() {
        return this.pool;
    }

    protected void setPool(PoolService<ConnHolder> pool) {
        this.pool = pool;
    }

    protected ConcurrentCollection<ConnHolder> getConcurrentCollection() {
        return this.concurrentCollection;
    }

    protected void setConcurrentCollection(ConcurrentCollection<ConnHolder> concurrentCollection) {
        this.concurrentCollection = concurrentCollection;
    }

    protected ViburObjectFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected void setConnectionFactory(ViburObjectFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected ThreadedPoolReducer getPoolReducer() {
        return this.poolReducer;
    }

    protected void setPoolReducer(ThreadedPoolReducer poolReducer) {
        this.poolReducer = poolReducer;
    }

    protected String getPoolReducerClass() {
        return this.poolReducerClass;
    }

    protected void setPoolReducerClass(String poolReducerClass) {
        this.poolReducerClass = poolReducerClass;
    }

    public int getReducerTimeIntervalInSeconds() {
        return this.reducerTimeIntervalInSeconds;
    }

    public void setReducerTimeIntervalInSeconds(int reducerTimeIntervalInSeconds) {
        this.reducerTimeIntervalInSeconds = reducerTimeIntervalInSeconds;
    }

    public int getReducerSamples() {
        return this.reducerSamples;
    }

    public void setReducerSamples(int reducerSamples) {
        this.reducerSamples = reducerSamples;
    }

    public boolean isAllowConnectionAfterTermination() {
        return this.allowConnectionAfterTermination;
    }

    public void setAllowConnectionAfterTermination(boolean allowConnectionAfterTermination) {
        this.allowConnectionAfterTermination = allowConnectionAfterTermination;
    }

    public boolean isAllowUnwrapping() {
        return this.allowUnwrapping;
    }

    public void setAllowUnwrapping(boolean allowUnwrapping) {
        this.allowUnwrapping = allowUnwrapping;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || (name = name.trim()).length() == 0) {
            logger.error("Invalid pool name {}", (Object)name);
            return;
        }
        if (!this.defaultName.equals(this.name) || this.defaultName.equals(name)) {
            logger.error("Pool name is already set or duplicated, existing name = {}, incoming name = {}", (Object)this.name, (Object)name);
            return;
        }
        this.name = name;
    }

    public String getJmxName() {
        return "org.vibur.dbcp:type=ViburDBCP-" + this.name;
    }

    public boolean isEnableJMX() {
        return this.enableJMX;
    }

    public void setEnableJMX(boolean enableJMX) {
        this.enableJMX = enableJMX;
    }

    public long getConnectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    public void setConnectionTimeoutInMs(long connectionTimeoutInMs) {
        this.connectionTimeoutInMs = connectionTimeoutInMs;
    }

    public int getLoginTimeoutInSeconds() {
        return this.loginTimeoutInSeconds;
    }

    public void setLoginTimeoutInSeconds(int loginTimeoutInSeconds) {
        this.loginTimeoutInSeconds = loginTimeoutInSeconds;
    }

    public long getAcquireRetryDelayInMs() {
        return this.acquireRetryDelayInMs;
    }

    public void setAcquireRetryDelayInMs(long acquireRetryDelayInMs) {
        this.acquireRetryDelayInMs = acquireRetryDelayInMs;
    }

    public int getAcquireRetryAttempts() {
        return this.acquireRetryAttempts;
    }

    public void setAcquireRetryAttempts(int acquireRetryAttempts) {
        this.acquireRetryAttempts = acquireRetryAttempts;
    }

    public int getStatementCacheMaxSize() {
        return this.statementCacheMaxSize;
    }

    public void setStatementCacheMaxSize(int statementCacheMaxSize) {
        this.statementCacheMaxSize = statementCacheMaxSize;
    }

    public StatementCache getStatementCache() {
        return this.statementCache;
    }

    protected void setStatementCache(StatementCache statementCache) {
        this.statementCache = statementCache;
    }

    public String getCriticalSQLStates() {
        return this.criticalSQLStates;
    }

    public void setCriticalSQLStates(String criticalSQLStates) {
        this.criticalSQLStates = criticalSQLStates;
    }

    public long getLogConnectionLongerThanMs() {
        return this.logConnectionLongerThanMs;
    }

    public void setLogConnectionLongerThanMs(long logConnectionLongerThanMs) {
        this.logConnectionLongerThanMs = logConnectionLongerThanMs;
    }

    public boolean isLogStackTraceForLongConnection() {
        return this.logStackTraceForLongConnection;
    }

    public void setLogStackTraceForLongConnection(boolean logStackTraceForLongConnection) {
        this.logStackTraceForLongConnection = logStackTraceForLongConnection;
    }

    public long getLogQueryExecutionLongerThanMs() {
        return this.logQueryExecutionLongerThanMs;
    }

    public void setLogQueryExecutionLongerThanMs(long logQueryExecutionLongerThanMs) {
        this.logQueryExecutionLongerThanMs = logQueryExecutionLongerThanMs;
    }

    public boolean isLogStackTraceForLongQueryExecution() {
        return this.logStackTraceForLongQueryExecution;
    }

    public void setLogStackTraceForLongQueryExecution(boolean logStackTraceForLongQueryExecution) {
        this.logStackTraceForLongQueryExecution = logStackTraceForLongQueryExecution;
    }

    public long getLogLargeResultSet() {
        return this.logLargeResultSet;
    }

    public void setLogLargeResultSet(long logLargeResultSet) {
        this.logLargeResultSet = logLargeResultSet;
    }

    public boolean isLogStackTraceForLargeResultSet() {
        return this.logStackTraceForLargeResultSet;
    }

    public void setLogStackTraceForLargeResultSet(boolean logStackTraceForLargeResultSet) {
        this.logStackTraceForLargeResultSet = logStackTraceForLargeResultSet;
    }

    public boolean isIncludeQueryParameters() {
        return this.includeQueryParameters;
    }

    public void setIncludeQueryParameters(boolean includeQueryParameters) {
        this.includeQueryParameters = includeQueryParameters;
    }

    public boolean isLogTakenConnectionsOnTimeout() {
        return this.logTakenConnectionsOnTimeout;
    }

    public void setLogTakenConnectionsOnTimeout(boolean logTakenConnectionsOnTimeout) {
        this.logTakenConnectionsOnTimeout = logTakenConnectionsOnTimeout;
    }

    public boolean isLogAllStackTracesOnTimeout() {
        return this.logAllStackTracesOnTimeout;
    }

    public void setLogAllStackTracesOnTimeout(boolean logAllStackTracesOnTimeout) {
        this.logAllStackTracesOnTimeout = logAllStackTracesOnTimeout;
    }

    public boolean isResetDefaultsAfterUse() {
        return this.resetDefaultsAfterUse;
    }

    public void setResetDefaultsAfterUse(boolean resetDefaultsAfterUse) {
        this.resetDefaultsAfterUse = resetDefaultsAfterUse;
    }

    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public String getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(String defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public Integer getDefaultTransactionIsolationIntValue() {
        return this.defaultTransactionIsolationIntValue;
    }

    public void setDefaultTransactionIsolationIntValue(Integer defaultTransactionIsolationIntValue) {
        this.defaultTransactionIsolationIntValue = defaultTransactionIsolationIntValue;
    }

    public boolean isClearSQLWarnings() {
        return this.clearSQLWarnings;
    }

    public void setClearSQLWarnings(boolean clearSQLWarnings) {
        this.clearSQLWarnings = clearSQLWarnings;
    }

    public HookHolder.ConnHooks getConnHooks() {
        return this.connHooks;
    }

    public HookHolder.InvocationHooks getInvocationHooks() {
        return this.invocationHooks;
    }

    public String toString() {
        return super.toString() + "[driverClassName = " + this.driverClassName + ", jdbcUrl = " + this.jdbcUrl + ", username = " + this.username + ", externalDataSource = " + this.externalDataSource + ", poolInitialSize = " + this.poolInitialSize + ", poolMaxSize = " + this.poolMaxSize + ", poolFair = " + this.poolFair + ", pool = " + this.pool + ", name = " + this.name + ", connectionTimeoutInMs = " + this.connectionTimeoutInMs + ", loginTimeoutInSeconds = " + this.loginTimeoutInSeconds + ", acquireRetryDelayInMs = " + this.acquireRetryDelayInMs + ", acquireRetryAttempts = " + this.acquireRetryAttempts + ", statementCacheMaxSize = " + this.statementCacheMaxSize + ']';
    }
}

