/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.pool;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.pool.Hook;
import org.vibur.dbcp.util.JdbcUtils;
import org.vibur.dbcp.util.ViburUtils;

public abstract class DefaultHook {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHook.class);
    final ViburConfig config;

    private DefaultHook(ViburConfig config) {
        this.config = config;
    }

    abstract boolean isEnabled();

    static final class Util {
        private Util() {
        }

        static <T extends Hook> T[] addHook(T[] hooks, T hook) {
            Objects.requireNonNull(hook);
            if (hook instanceof DefaultHook && !((DefaultHook)((Object)hook)).isEnabled()) {
                return hooks;
            }
            for (T h : hooks) {
                if (!h.equals(hook)) continue;
                return hooks;
            }
            int length = hooks.length;
            hooks = (Hook[])Arrays.copyOf(hooks, length + 1);
            hooks[length] = hook;
            return hooks;
        }
    }

    public static class ResultSetSize
    extends DefaultHook
    implements Hook.ResultSetRetrieval {
        public ResultSetSize(ViburConfig config) {
            super(config);
        }

        @Override
        public void on(String sqlQuery, List<Object[]> sqlQueryParams, long resultSetSize) {
            if (this.config.getLogLargeResultSet() > resultSetSize) {
                return;
            }
            if (logger.isWarnEnabled()) {
                StringBuilder message = new StringBuilder(4096).append(String.format("SQL query execution from pool %s retrieved a ResultSet with size %d:\n%s", ViburUtils.getPoolName(this.config), resultSetSize, ViburUtils.formatSql(sqlQuery, sqlQueryParams)));
                if (this.config.isLogStackTraceForLargeResultSet()) {
                    message.append('\n').append(ViburUtils.getStackTraceAsString(new Throwable().getStackTrace()));
                }
                logger.warn(message.toString());
            }
        }

        @Override
        boolean isEnabled() {
            return this.config.getLogLargeResultSet() >= 0L;
        }
    }

    public static class QueryTiming
    extends DefaultHook
    implements Hook.StatementExecution {
        public QueryTiming(ViburConfig config) {
            super(config);
        }

        @Override
        public Object on(Statement proxy, Method method, Object[] args, String sqlQuery, List<Object[]> sqlQueryParams, Hook.StatementProceedingPoint proceed) throws SQLException {
            long startNanoTime = System.nanoTime();
            SQLException sqlException = null;
            try {
                Object object = proceed.on(proxy, method, args, sqlQuery, sqlQueryParams, proceed);
                return object;
            }
            catch (SQLException e) {
                sqlException = e;
                throw sqlException;
            }
            finally {
                long takenNanos = System.nanoTime() - startNanoTime;
                this.logQueryExecution(sqlQuery, sqlQueryParams, takenNanos, sqlException);
            }
        }

        private void logQueryExecution(String sqlQuery, List<Object[]> sqlQueryParams, long takenNanos, SQLException sqlException) {
            boolean logException;
            double takenMillis = (double)takenNanos * 1.0E-6;
            boolean logTime = takenMillis >= (double)this.config.getLogQueryExecutionLongerThanMs() && logger.isWarnEnabled();
            boolean bl = logException = sqlException != null && logger.isDebugEnabled();
            if (!logTime && !logException) {
                return;
            }
            String poolName = ViburUtils.getPoolName(this.config);
            String formattedSql = ViburUtils.formatSql(sqlQuery, sqlQueryParams);
            if (logException) {
                logger.debug("SQL query execution from pool {}:\n{}\n-- threw:", new Object[]{poolName, formattedSql, sqlException});
            }
            if (logTime) {
                StringBuilder message = new StringBuilder(4096).append(String.format("SQL query execution from pool %s took %f ms:\n%s", poolName, takenMillis, formattedSql));
                if (this.config.isLogStackTraceForLongQueryExecution()) {
                    message.append('\n').append(ViburUtils.getStackTraceAsString(new Throwable().getStackTrace()));
                }
                logger.warn(message.toString());
            }
        }

        @Override
        boolean isEnabled() {
            return this.config.getLogQueryExecutionLongerThanMs() >= 0L;
        }
    }

    public static class CloseConnection
    extends DefaultHook
    implements Hook.CloseConnection {
        public CloseConnection(ViburConfig config) {
            super(config);
        }

        @Override
        public void on(Connection rawConnection, long takenNanos) throws SQLException {
            if (this.config.isClearSQLWarnings()) {
                JdbcUtils.clearWarnings(rawConnection);
            }
            if (this.config.isResetDefaultsAfterUse()) {
                JdbcUtils.setDefaultValues(rawConnection, this.config);
            }
        }

        @Override
        boolean isEnabled() {
            return this.config.isClearSQLWarnings() || this.config.isResetDefaultsAfterUse();
        }
    }

    public static class GetConnectionTiming
    extends DefaultHook
    implements Hook.GetConnection {
        public GetConnectionTiming(ViburConfig config) {
            super(config);
        }

        @Override
        public void on(Connection rawConnection, long takenNanos) {
            double takenMillis = (double)takenNanos * 1.0E-6;
            if (takenMillis < (double)this.config.getLogConnectionLongerThanMs()) {
                return;
            }
            if (logger.isWarnEnabled()) {
                StringBuilder log = new StringBuilder(4096).append(String.format("Call to getConnection() from pool %s took %f ms, rawConnection = %s", ViburUtils.getPoolName(this.config), takenMillis, rawConnection));
                if (this.config.isLogStackTraceForLongConnection()) {
                    log.append('\n').append(ViburUtils.getStackTraceAsString(new Throwable().getStackTrace()));
                }
                logger.warn(log.toString());
            }
        }

        @Override
        boolean isEnabled() {
            return this.config.getLogConnectionLongerThanMs() >= 0L;
        }
    }

    public static class InitConnection
    extends DefaultHook
    implements Hook.InitConnection {
        public InitConnection(ViburConfig config) {
            super(config);
        }

        @Override
        public void on(Connection rawConnection, long takenNanos) throws SQLException {
            if (rawConnection == null) {
                return;
            }
            if (!JdbcUtils.validateOrInitialize(rawConnection, this.config.getInitSQL(), this.config)) {
                throw new SQLException("Couldn't initialize rawConnection " + rawConnection, "VI003");
            }
            JdbcUtils.setDefaultValues(rawConnection, this.config);
        }

        @Override
        boolean isEnabled() {
            return this.config.getInitSQL() != null || this.config.getDefaultAutoCommit() != null || this.config.getDefaultReadOnly() != null || this.config.getDefaultTransactionIsolationIntValue() != null || this.config.getDefaultCatalog() != null;
        }
    }
}

