/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburDBCPDataSource;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.Hook;
import org.vibur.dbcp.pool.HookHolder;
import org.vibur.dbcp.pool.ViburObjectFactory;
import org.vibur.dbcp.proxy.Proxy;
import org.vibur.dbcp.util.JdbcUtils;
import org.vibur.dbcp.util.ViburUtils;
import org.vibur.objectpool.PoolService;

public class PoolOperations {
    private static final Logger logger = LoggerFactory.getLogger(PoolOperations.class);
    private static final long[] NO_WAIT = new long[0];
    private static final Pattern whitespaces = Pattern.compile("\\s");
    private final ViburDBCPDataSource dataSource;
    private final long connectionTimeoutInNanos;
    private final ViburObjectFactory connectionFactory;
    private final PoolService<ConnHolder> poolService;
    private final Set<String> criticalSQLStates;

    public PoolOperations(ViburDBCPDataSource dataSource, ViburObjectFactory connectionFactory, PoolService<ConnHolder> poolService) {
        this.dataSource = dataSource;
        this.connectionTimeoutInNanos = TimeUnit.MILLISECONDS.toNanos(dataSource.getConnectionTimeoutInMs());
        this.connectionFactory = connectionFactory;
        this.poolService = poolService;
        this.criticalSQLStates = new HashSet<String>(Arrays.asList(whitespaces.matcher(dataSource.getCriticalSQLStates()).replaceAll("").split(",")));
    }

    public Connection getProxyConnection(long timeoutMs) throws SQLException {
        int attempt = 1;
        ConnHolder connHolder = null;
        SQLException sqlException = null;
        long startNanoTime = System.nanoTime();
        while (connHolder == null) {
            try {
                connHolder = this.getConnHolder(timeoutMs);
            }
            catch (ViburDBCPException e) {
                sqlException = JdbcUtils.chainSQLException(e.unwrapSQLException(), sqlException);
                if (attempt++ > this.dataSource.getAcquireRetryAttempts()) {
                    throw sqlException;
                }
                if (timeoutMs > 0L && (timeoutMs = TimeUnit.NANOSECONDS.toMillis(this.connectionTimeoutInNanos - (System.nanoTime() - startNanoTime)) - this.dataSource.getAcquireRetryDelayInMs()) <= 0L) {
                    throw sqlException;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(this.dataSource.getAcquireRetryDelayInMs());
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw JdbcUtils.chainSQLException(new SQLException(ie), sqlException);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Taking rawConnection {}", (Object)connHolder.rawConnection());
        }
        Connection proxy = Proxy.newProxyConnection(connHolder, this, this.dataSource);
        if (this.dataSource.isPoolEnableConnectionTracking()) {
            connHolder.setProxyConnection(proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ConnHolder getConnHolder(long timeoutMs) throws SQLException, ViburDBCPException {
        ViburDBCPException viburException;
        SQLException sqlException;
        ConnHolder connHolder;
        block18: {
            Hook.GetConnection[] onGet = ((HookHolder.ConnHooksAccessor)((Object)this.dataSource.getConnHooks())).onGet();
            connHolder = null;
            long[] waitedNanos = NO_WAIT;
            sqlException = null;
            viburException = null;
            if (onGet.length > 0) {
                waitedNanos = new long[1];
                connHolder = timeoutMs > 0L ? (ConnHolder)this.poolService.tryTake(timeoutMs, TimeUnit.MILLISECONDS, waitedNanos) : (ConnHolder)this.poolService.take(waitedNanos);
            } else {
                ConnHolder connHolder2 = connHolder = timeoutMs > 0L ? (ConnHolder)this.poolService.tryTake(timeoutMs, TimeUnit.MILLISECONDS) : (ConnHolder)this.poolService.take();
            }
            if (connHolder == null) {
                sqlException = this.createSQLException(onGet.length > 0 ? (double)waitedNanos[0] * 1.0E-6 : (double)timeoutMs);
            }
            Connection rawConnection = connHolder != null ? connHolder.rawConnection() : null;
            try {
                for (Hook.GetConnection hook : onGet) {
                    hook.on(rawConnection, waitedNanos[0]);
                }
            }
            catch (SQLException e) {
                sqlException = JdbcUtils.chainSQLException(sqlException, e);
            }
            break block18;
            catch (ViburDBCPException e) {
                viburException = e;
                sqlException = e.unwrapSQLException();
                rawConnection = connHolder != null ? connHolder.rawConnection() : null;
                try {
                    for (Hook.GetConnection hook : onGet) {
                        hook.on(rawConnection, waitedNanos[0]);
                    }
                }
                catch (SQLException e2) {
                    sqlException = JdbcUtils.chainSQLException(sqlException, e2);
                    break block18;
                }
                catch (Throwable throwable) {
                    Connection rawConnection2 = connHolder != null ? connHolder.rawConnection() : null;
                    try {
                        for (Hook.GetConnection hook : onGet) {
                            hook.on(rawConnection2, waitedNanos[0]);
                        }
                    }
                    catch (SQLException e3) {
                        sqlException = JdbcUtils.chainSQLException(sqlException, e3);
                    }
                    throw throwable;
                }
            }
        }
        if (viburException != null) {
            throw viburException;
        }
        if (sqlException != null) {
            throw sqlException;
        }
        return connHolder;
    }

    private SQLException createSQLException(double elapsedMs) {
        String poolName = ViburUtils.getPoolName(this.dataSource);
        if (this.poolService.isTerminated()) {
            return new SQLException(String.format("Pool %s, the poolService is terminated.", poolName), "VI001");
        }
        boolean isInterrupted = Thread.currentThread().isInterrupted();
        if (!isInterrupted && this.dataSource.isLogTakenConnectionsOnTimeout() && logger.isWarnEnabled()) {
            logger.warn(String.format("Pool %s, couldn't obtain SQL connection within %.3f ms, full list of taken connections begins:\n%s", poolName, elapsedMs, this.dataSource.getTakenConnectionsStackTraces()));
        }
        int intElapsedMs = (int)Math.round(elapsedMs);
        return !isInterrupted ? new SQLTimeoutException(String.format("Pool %s, couldn't obtain SQL connection within %.3f ms.", poolName, elapsedMs), "VI002", intElapsedMs) : new SQLException(String.format("Pool %s, interrupted while getting SQL connection, waited for %.3f ms.", poolName, elapsedMs), "VI004", intElapsedMs);
    }

    public void restore(ConnHolder connHolder, boolean valid, SQLException[] exceptions) {
        if (logger.isTraceEnabled()) {
            logger.trace("Restoring rawConnection {}", (Object)connHolder.rawConnection());
        }
        boolean reusable = valid && exceptions.length == 0 && connHolder.version() == this.connectionFactory.version();
        this.poolService.restore((Object)connHolder, reusable);
        this.processSQLExceptions(connHolder, exceptions);
    }

    private void processSQLExceptions(ConnHolder connHolder, SQLException[] exceptions) {
        int connVersion = connHolder.version();
        SQLException criticalException = this.getCriticalSQLException(exceptions);
        if (criticalException != null && this.connectionFactory.compareAndSetVersion(connVersion, connVersion + 1)) {
            int destroyed = this.poolService.drainCreated();
            logger.error("Critical SQLState {} occurred, destroyed {} connections from pool {}, current connection version is {}.", new Object[]{criticalException.getSQLState(), destroyed, ViburUtils.getPoolName(this.dataSource), this.connectionFactory.version(), criticalException});
        }
    }

    private SQLException getCriticalSQLException(SQLException[] exceptions) {
        for (SQLException exception : exceptions) {
            if (!this.isCriticalSQLException(exception)) continue;
            return exception;
        }
        return null;
    }

    private boolean isCriticalSQLException(SQLException exception) {
        if (exception == null) {
            return false;
        }
        if (this.criticalSQLStates.contains(exception.getSQLState())) {
            return true;
        }
        return this.isCriticalSQLException(exception.getNextException());
    }
}

