/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.pool;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.TakenConnection;
import org.vibur.dbcp.util.ViburUtils;
import org.vibur.objectpool.util.TakenListener;

public class ViburListener
extends TakenListener<ConnHolder> {
    private static final ConnHolder[] NO_TAKEN_CONNS = new ConnHolder[0];
    private final ViburConfig config;

    public ViburListener(ViburConfig config) {
        super(config.getPoolMaxSize());
        this.config = config;
    }

    public TakenConnection[] getTakenConnections() {
        ConnHolder[] takenConns = this.getTaken(new ConnHolder[this.config.getPoolMaxSize()]);
        return (TakenConnection[])Arrays.copyOf(takenConns, takenConns.length, TakenConnection[].class);
    }

    public String getTakenConnectionsStackTraces() {
        ConnHolder[] takenConns = this.getTaken(new ConnHolder[this.config.getPoolMaxSize()]);
        if (takenConns.length == 0) {
            return "";
        }
        Arrays.sort(takenConns, new Comparator<ConnHolder>(){

            @Override
            public int compare(ConnHolder h1, ConnHolder h2) {
                return Long.compare(h1.getTakenNanoTime(), h2.getTakenNanoTime());
            }
        });
        long currentNanoTime = System.nanoTime();
        StringBuilder builder = new StringBuilder(takenConns.length * 8192);
        Map<Thread, StackTraceElement[]> currentStackTraces = this.getCurrentStackTraces(takenConns);
        for (ConnHolder takenConn : takenConns) {
            Thread holdingThread = takenConn.getThread();
            builder.append("\n============\n").append(takenConn.rawConnection()).append(", held for ").append(TimeUnit.NANOSECONDS.toMillis(currentNanoTime - takenConn.getTakenNanoTime()));
            if (takenConn.getLastAccessNanoTime() == 0L) {
                builder.append(" ms, has not been accessed");
            } else {
                builder.append(" ms, last accessed before ").append(TimeUnit.NANOSECONDS.toMillis(currentNanoTime - takenConn.getLastAccessNanoTime())).append(" ms");
            }
            builder.append(", taken by thread ").append(holdingThread.getName()).append(", current thread state ").append((Object)holdingThread.getState()).append("\n\nThread stack trace at the moment when getting the Connection:\n").append(ViburUtils.getStackTraceAsString(takenConn.getLocation().getStackTrace()));
            StackTraceElement[] currentStackTrace = currentStackTraces.remove(holdingThread);
            if (currentStackTrace == null || currentStackTrace.length <= 0) continue;
            builder.append("\nThread stack trace at the current moment:\n").append(ViburUtils.getStackTraceAsString(currentStackTrace));
        }
        return ViburListener.addAllOtherStackTraces(builder, currentStackTraces).toString();
    }

    protected ConnHolder[] getTaken(ConnHolder[] a) {
        int size;
        ConnHolder[] takenConns = (ConnHolder[])super.getTaken((Object[])a);
        for (size = 0; size < takenConns.length && takenConns[size] != null; ++size) {
        }
        if (size == 0) {
            return NO_TAKEN_CONNS;
        }
        ConnHolder[] result = new ConnHolder[size];
        for (int i = 0; i < size; ++i) {
            result[i] = new ConnHolder(takenConns[i]);
        }
        return result;
    }

    private static StringBuilder addAllOtherStackTraces(StringBuilder builder, Map<Thread, StackTraceElement[]> stackTraces) {
        if (stackTraces.isEmpty()) {
            return builder;
        }
        builder.append("\n\n============ All other stack traces: ============\n\n");
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            Thread thread = entry.getKey();
            builder.append("\n============\n").append("Thread ").append(thread.getName()).append(", state ").append((Object)thread.getState());
            StackTraceElement[] currentStackTrace = entry.getValue();
            if (currentStackTrace.length <= 0) continue;
            builder.append("\n\nThread stack trace at the current moment:\n").append(ViburUtils.getStackTraceAsString(currentStackTrace));
        }
        return builder;
    }

    private Map<Thread, StackTraceElement[]> getCurrentStackTraces(ConnHolder[] takenConns) {
        if (this.config.isLogAllStackTracesOnTimeout()) {
            return Thread.getAllStackTraces();
        }
        HashMap<Thread, StackTraceElement[]> map = new HashMap<Thread, StackTraceElement[]>(takenConns.length);
        for (ConnHolder takenConn : takenConns) {
            Thread holdingThread = takenConn.getThread();
            if (!holdingThread.isAlive()) continue;
            map.put(holdingThread, holdingThread.getStackTrace());
        }
        return map;
    }
}

