/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.ViburDataSource;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.PoolOperations;
import org.vibur.dbcp.proxy.AbstractInvocationHandler;
import org.vibur.dbcp.proxy.Proxy;
import org.vibur.dbcp.stcache.StatementCache;
import org.vibur.dbcp.stcache.StatementHolder;
import org.vibur.dbcp.stcache.StatementMethod;

class ConnectionInvocationHandler
extends AbstractInvocationHandler<Connection>
implements ViburDataSource.ConnectionInvalidator,
StatementCache.StatementCreator {
    private final ConnHolder connHolder;
    private final PoolOperations poolOperations;
    private final ViburConfig config;
    private final boolean poolEnableConnectionTracking;
    private final StatementCache statementCache;

    ConnectionInvocationHandler(ConnHolder connHolder, PoolOperations poolOperations, ViburConfig config) {
        super(connHolder.rawConnection(), config, null);
        this.connHolder = connHolder;
        this.poolOperations = poolOperations;
        this.config = config;
        this.poolEnableConnectionTracking = config.isPoolEnableConnectionTracking();
        this.statementCache = config.getStatementCache();
    }

    @Override
    Object unrestrictedInvoke(Connection proxy, Method method, Object[] args) throws SQLException {
        String methodName = method.getName();
        if (methodName == "close") {
            return this.processClose();
        }
        if (methodName == "isClosed") {
            return this.isClosed();
        }
        if (methodName == "isValid") {
            return this.isClosed() ? Boolean.valueOf(false) : this.targetInvoke(method, args);
        }
        if (methodName == "abort") {
            return this.processAbort(method, args);
        }
        return super.unrestrictedInvoke(proxy, method, args);
    }

    @Override
    Object restrictedInvoke(Connection proxy, Method method, Object[] args) throws SQLException {
        String methodName;
        if (this.poolEnableConnectionTracking) {
            this.connHolder.setLastAccessNanoTime(System.nanoTime());
        }
        if ((methodName = method.getName()) == "createStatement") {
            StatementHolder statement = this.getUncachedStatement(method, args, null);
            return Proxy.newProxyStatement(statement, proxy, this.config, this);
        }
        if (methodName == "prepareStatement") {
            StatementHolder pStatement = this.getCachedStatement(method, args);
            return Proxy.newProxyPreparedStatement(pStatement, proxy, this.config, this);
        }
        if (methodName == "prepareCall") {
            StatementHolder cStatement = this.getCachedStatement(method, args);
            return Proxy.newProxyCallableStatement(cStatement, proxy, this.config, this);
        }
        if (methodName == "getMetaData") {
            DatabaseMetaData rawDatabaseMetaData = (DatabaseMetaData)this.targetInvoke(method, args);
            return Proxy.newProxyDatabaseMetaData(rawDatabaseMetaData, proxy, this.config, this);
        }
        return super.restrictedInvoke(proxy, method, args);
    }

    private StatementHolder getCachedStatement(Method method, Object[] args) throws SQLException {
        if (this.statementCache != null) {
            return this.statementCache.take(new StatementMethod((Connection)this.getTarget(), this, method, args));
        }
        return this.getUncachedStatement(method, args, (String)args[0]);
    }

    private StatementHolder getUncachedStatement(Method method, Object[] args, String sqlQuery) throws SQLException {
        Statement rawStatement = (Statement)this.targetInvoke(method, args);
        return new StatementHolder(rawStatement, null, sqlQuery);
    }

    private Object processClose() {
        if (this.close()) {
            this.poolOperations.restore(this.connHolder, true, this.getExceptions());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processAbort(Method method, Object[] args) throws SQLException {
        if (!this.close()) {
            return null;
        }
        try {
            Object object = this.targetInvoke(method, args);
            return object;
        }
        finally {
            this.poolOperations.restore(this.connHolder, false, this.getExceptions());
        }
    }

    @Override
    public PreparedStatement newStatement(Method method, Object[] args) throws SQLException {
        String methodName = method.getName();
        if (methodName != "prepareStatement" && methodName != "prepareCall") {
            throw new ViburDBCPException("Unexpected method passed to newStatement() " + method);
        }
        return (PreparedStatement)this.targetInvoke(method, args);
    }

    @Override
    public void invalidate() {
        if (this.close()) {
            this.poolOperations.restore(this.connHolder, false, this.getExceptions());
        }
    }
}

