/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.PoolOperations;
import org.vibur.dbcp.proxy.ChildObjectInvocationHandler;
import org.vibur.dbcp.proxy.ConnectionInvocationHandler;
import org.vibur.dbcp.proxy.ExceptionCollector;
import org.vibur.dbcp.proxy.ResultSetInvocationHandler;
import org.vibur.dbcp.proxy.StatementInvocationHandler;
import org.vibur.dbcp.stcache.StatementHolder;

public final class Proxy {
    private static final Constructor<Connection> connectionCtor;
    private static final Constructor<Statement> statementCtor;
    private static final Constructor<PreparedStatement> pStatementCtor;
    private static final Constructor<CallableStatement> cStatementCtor;
    private static final Constructor<DatabaseMetaData> metadataCtor;
    private static final Constructor<ResultSet> resultSetCtor;
    private static final ClassLoader classLoader;

    private Proxy() {
    }

    public static Connection newProxyConnection(ConnHolder connHolder, PoolOperations poolOperations, ViburConfig config) {
        ConnectionInvocationHandler handler = new ConnectionInvocationHandler(connHolder, poolOperations, config);
        return Proxy.newProxy(connectionCtor, handler);
    }

    static Statement newProxyStatement(StatementHolder statement, Connection connProxy, ViburConfig config, ExceptionCollector exceptionCollector) {
        StatementInvocationHandler handler = new StatementInvocationHandler(statement, null, connProxy, config, exceptionCollector);
        return Proxy.newProxy(statementCtor, handler);
    }

    static PreparedStatement newProxyPreparedStatement(StatementHolder pStatement, Connection connProxy, ViburConfig config, ExceptionCollector exceptionCollector) {
        StatementInvocationHandler handler = new StatementInvocationHandler(pStatement, config.getStatementCache(), connProxy, config, exceptionCollector);
        return Proxy.newProxy(pStatementCtor, handler);
    }

    static CallableStatement newProxyCallableStatement(StatementHolder cStatement, Connection connProxy, ViburConfig config, ExceptionCollector exceptionCollector) {
        StatementInvocationHandler handler = new StatementInvocationHandler(cStatement, config.getStatementCache(), connProxy, config, exceptionCollector);
        return Proxy.newProxy(cStatementCtor, handler);
    }

    static DatabaseMetaData newProxyDatabaseMetaData(DatabaseMetaData rawMetaData, Connection connProxy, ViburConfig config, ExceptionCollector exceptionCollector) {
        ChildObjectInvocationHandler<Connection, DatabaseMetaData> handler = new ChildObjectInvocationHandler<Connection, DatabaseMetaData>(rawMetaData, connProxy, "getConnection", config, exceptionCollector);
        return Proxy.newProxy(metadataCtor, handler);
    }

    static ResultSet newProxyResultSet(ResultSet rawResultSet, Statement statementProxy, String sqlQuery, List<Object[]> sqlQueryParams, ViburConfig config, ExceptionCollector exceptionCollector) {
        ResultSetInvocationHandler handler = new ResultSetInvocationHandler(rawResultSet, statementProxy, sqlQuery, sqlQueryParams, config, exceptionCollector);
        return Proxy.newProxy(resultSetCtor, handler);
    }

    private static <T> T newProxy(Constructor<T> proxyCtor, InvocationHandler handler) {
        try {
            return proxyCtor.newInstance(handler);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    private static <T> Constructor<T> getIHConstructor(Class<T> cl) {
        try {
            return java.lang.reflect.Proxy.getProxyClass(classLoader, cl).getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    static {
        classLoader = Thread.currentThread().getContextClassLoader();
        connectionCtor = Proxy.getIHConstructor(Connection.class);
        statementCtor = Proxy.getIHConstructor(Statement.class);
        pStatementCtor = Proxy.getIHConstructor(PreparedStatement.class);
        cStatementCtor = Proxy.getIHConstructor(CallableStatement.class);
        metadataCtor = Proxy.getIHConstructor(DatabaseMetaData.class);
        resultSetCtor = Proxy.getIHConstructor(ResultSet.class);
    }
}

