/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.pool.Hook;
import org.vibur.dbcp.pool.HookHolder;
import org.vibur.dbcp.proxy.ChildObjectInvocationHandler;
import org.vibur.dbcp.proxy.ExceptionCollector;

class ResultSetInvocationHandler
extends ChildObjectInvocationHandler<Statement, ResultSet> {
    private final String sqlQuery;
    private final List<Object[]> sqlQueryParams;
    private final Hook.ResultSetRetrieval[] executionHooks;
    private final AtomicLong resultSetSize = new AtomicLong(0L);

    ResultSetInvocationHandler(ResultSet rawResultSet, Statement statementProxy, String sqlQuery, List<Object[]> sqlQueryParams, ViburConfig config, ExceptionCollector exceptionCollector) {
        super(rawResultSet, statementProxy, "getStatement", config, exceptionCollector);
        this.sqlQuery = sqlQuery;
        this.sqlQueryParams = sqlQueryParams;
        this.executionHooks = ((HookHolder.InvocationHooksAccessor)((Object)config.getInvocationHooks())).onResultSetRetrieval();
    }

    @Override
    Object unrestrictedInvoke(ResultSet proxy, Method method, Object[] args) throws SQLException {
        String methodName = method.getName();
        if (methodName == "close") {
            return this.processClose(method, args);
        }
        if (methodName == "isClosed") {
            return this.isClosed();
        }
        return super.unrestrictedInvoke(proxy, method, args);
    }

    @Override
    Object restrictedInvoke(ResultSet proxy, Method method, Object[] args) throws SQLException {
        String methodName = method.getName();
        if (methodName == "next") {
            return this.processNext(method, args);
        }
        return super.restrictedInvoke(proxy, method, args);
    }

    private Object processNext(Method method, Object[] args) throws SQLException {
        this.resultSetSize.incrementAndGet();
        return this.targetInvoke(method, args);
    }

    private Object processClose(Method method, Object[] args) throws SQLException {
        if (!this.close()) {
            return null;
        }
        long size = this.resultSetSize.get() - 1L;
        for (Hook.ResultSetRetrieval hook : this.executionHooks) {
            hook.on(this.sqlQuery, this.sqlQueryParams, size);
        }
        return this.targetInvoke(method, args);
    }
}

