/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.stcache;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.vibur.dbcp.stcache.StatementCache;

public class StatementMethod {
    private final StatementCache.StatementCreator statementCreator;
    private final Connection rawConnection;
    private final Method method;
    private final Object[] args;

    public StatementMethod(Connection rawConnection, StatementCache.StatementCreator statementCreator, Method method, Object[] args) {
        assert (statementCreator != null);
        assert (method != null);
        assert (args != null && args.length >= 1);
        this.statementCreator = statementCreator;
        this.rawConnection = rawConnection;
        this.method = method;
        this.args = args;
    }

    Connection rawConnection() {
        return this.rawConnection;
    }

    PreparedStatement newStatement() throws SQLException {
        return this.statementCreator.newStatement(this.method, this.args);
    }

    String sqlQuery() {
        return (String)this.args[0];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementMethod that = (StatementMethod)o;
        return this.rawConnection == that.rawConnection && this.method.equals(that.method) && Arrays.equals(this.args, that.args);
    }

    public int hashCode() {
        int result = this.rawConnection.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }

    public String toString() {
        return String.format("rawConnection %s, method %s, args %s", this.rawConnection, this.method, Arrays.toString(this.args));
    }
}

