/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.pool;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.pool.TakenConnection;
import org.vibur.dbcp.util.ViburUtils;

public interface TakenConnectionsFormatter {
    public String formatTakenConnections(TakenConnection[] var1);

    public static class Default
    implements TakenConnectionsFormatter {
        private final ViburConfig config;

        public Default(ViburConfig config) {
            this.config = config;
        }

        @Override
        public String formatTakenConnections(TakenConnection[] takenConns) {
            if (takenConns == null || takenConns.length == 0) {
                return "NO TAKEN CONNECTIONS\n";
            }
            Arrays.sort(takenConns, new Comparator<TakenConnection>(){

                @Override
                public int compare(TakenConnection t1, TakenConnection t2) {
                    return Long.compare(t1.getTakenNanoTime(), t2.getTakenNanoTime());
                }
            });
            long currentNanoTime = System.nanoTime();
            StringBuilder builder = new StringBuilder(takenConns.length * 8192);
            Map<Thread, StackTraceElement[]> currentStackTraces = this.getCurrentStackTraces(takenConns);
            for (int i = 0; i < takenConns.length; ++i) {
                Thread holdingThread = takenConns[i].getThread();
                builder.append("\n============\n(").append(i + 1).append('/').append(takenConns.length).append("), ").append(takenConns[i].getProxyConnection()).append(", held for ").append(TimeUnit.NANOSECONDS.toMillis(currentNanoTime - takenConns[i].getTakenNanoTime()));
                if (takenConns[i].getLastAccessNanoTime() == 0L) {
                    builder.append(" ms, has not been accessed");
                } else {
                    builder.append(" ms, last accessed before ").append(TimeUnit.NANOSECONDS.toMillis(currentNanoTime - takenConns[i].getLastAccessNanoTime())).append(" ms");
                }
                builder.append(", taken by thread ").append(holdingThread.getName()).append(", current thread state ").append((Object)holdingThread.getState()).append("\n\nThread stack trace at the moment when getting the Connection:\n").append(ViburUtils.getStackTraceAsString(this.config.getLogLineRegex(), takenConns[i].getLocation().getStackTrace()));
                StackTraceElement[] currentStackTrace = currentStackTraces.remove(holdingThread);
                if (currentStackTrace == null || currentStackTrace.length <= 0) continue;
                builder.append("\nThread stack trace at the current moment:\n").append(ViburUtils.getStackTraceAsString(this.config.getLogLineRegex(), currentStackTrace));
            }
            return this.addAllOtherStackTraces(builder, currentStackTraces).toString();
        }

        private StringBuilder addAllOtherStackTraces(StringBuilder builder, Map<Thread, StackTraceElement[]> stackTraces) {
            if (stackTraces.isEmpty()) {
                return builder;
            }
            builder.append("\n\n============ All other stack traces: ============\n\n");
            for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
                Thread thread = entry.getKey();
                builder.append("\n============\n").append("Thread ").append(thread.getName()).append(", state ").append((Object)thread.getState());
                StackTraceElement[] currentStackTrace = entry.getValue();
                if (currentStackTrace.length <= 0) continue;
                builder.append("\n\nThread stack trace at the current moment:\n").append(ViburUtils.getStackTraceAsString(this.config.getLogLineRegex(), currentStackTrace));
            }
            return builder;
        }

        private Map<Thread, StackTraceElement[]> getCurrentStackTraces(TakenConnection[] takenConns) {
            if (this.config.isLogAllStackTracesOnTimeout()) {
                return Thread.getAllStackTraces();
            }
            HashMap<Thread, StackTraceElement[]> map = new HashMap<Thread, StackTraceElement[]>(takenConns.length);
            for (TakenConnection takenConn : takenConns) {
                Thread holdingThread = takenConn.getThread();
                if (!holdingThread.isAlive()) continue;
                map.put(holdingThread, holdingThread.getStackTrace());
            }
            return map;
        }
    }
}

