/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.stcache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.stcache.StatementCache;
import org.vibur.dbcp.stcache.StatementHolder;
import org.vibur.dbcp.stcache.StatementMethod;
import org.vibur.dbcp.util.JdbcUtils;
import org.vibur.objectpool.util.ArgumentValidation;

public class ClhmStatementCache
implements StatementCache {
    private static final Logger logger = LoggerFactory.getLogger(ClhmStatementCache.class);
    private final ConcurrentMap<StatementMethod, StatementHolder> statementCache;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ClhmStatementCache(int maxSize) {
        ArgumentValidation.forbidIllegalArgument((maxSize <= 0 ? 1 : 0) != 0);
        this.statementCache = Objects.requireNonNull(this.buildStatementCache(maxSize));
    }

    protected ConcurrentMap<StatementMethod, StatementHolder> buildStatementCache(int maxSize) {
        return new ConcurrentLinkedHashMap.Builder().initialCapacity(maxSize).maximumWeightedCapacity((long)maxSize).listener(ClhmStatementCache.getListener()).build();
    }

    private static EvictionListener<StatementMethod, StatementHolder> getListener() {
        return new EvictionListener<StatementMethod, StatementHolder>(){

            public void onEviction(StatementMethod statementMethod, StatementHolder statementHolder) {
                if (statementHolder.state().getAndSet(StatementHolder.State.EVICTED) == StatementHolder.State.AVAILABLE) {
                    JdbcUtils.quietClose(statementHolder.rawStatement());
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Evicted {}", (Object)statementHolder.rawStatement());
                }
            }
        };
    }

    @Override
    public StatementHolder take(StatementMethod statementMethod) throws SQLException {
        if (this.isClosed()) {
            return new StatementHolder(statementMethod.newStatement(), null, statementMethod.sqlQuery());
        }
        StatementHolder statement = (StatementHolder)this.statementCache.get(statementMethod);
        if (statement != null) {
            if (statement.state().compareAndSet(StatementHolder.State.AVAILABLE, StatementHolder.State.IN_USE)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Using cached statement for {}", (Object)statementMethod);
                }
                return statement;
            }
            return new StatementHolder(statementMethod.newStatement(), null, statementMethod.sqlQuery());
        }
        PreparedStatement rawStatement = statementMethod.newStatement();
        statement = new StatementHolder(rawStatement, new AtomicReference<StatementHolder.State>(StatementHolder.State.IN_USE), statementMethod.sqlQuery());
        if (this.statementCache.putIfAbsent(statementMethod, statement) == null) {
            return statement;
        }
        return new StatementHolder(rawStatement, null, statementMethod.sqlQuery());
    }

    @Override
    public boolean restore(StatementHolder statement, boolean clearWarnings) {
        if (this.isClosed()) {
            this.remove(statement);
            return false;
        }
        if (statement.state() == null) {
            return false;
        }
        PreparedStatement rawStatement = (PreparedStatement)statement.rawStatement();
        try {
            if (clearWarnings) {
                JdbcUtils.clearWarnings(rawStatement);
            }
            return statement.state().compareAndSet(StatementHolder.State.IN_USE, StatementHolder.State.AVAILABLE);
        }
        catch (SQLException e) {
            logger.debug("Couldn't clear warnings on {}", (Object)rawStatement, (Object)e);
            this.remove(statement);
            return false;
        }
    }

    @Override
    public boolean remove(StatementHolder statement) {
        if (statement.state() == null) {
            return false;
        }
        for (Map.Entry entry : this.statementCache.entrySet()) {
            StatementHolder value = (StatementHolder)entry.getValue();
            if (value != statement) continue;
            return this.statementCache.remove(entry.getKey(), value);
        }
        return false;
    }

    @Override
    public int removeAll(Connection rawConnection) {
        int removed = 0;
        for (Map.Entry entry : this.statementCache.entrySet()) {
            StatementMethod key = (StatementMethod)entry.getKey();
            StatementHolder value = (StatementHolder)entry.getValue();
            if (key.rawConnection() != rawConnection || !this.statementCache.remove(key, value)) continue;
            JdbcUtils.quietClose(value.rawStatement());
            ++removed;
        }
        return removed;
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        for (Map.Entry entry : this.statementCache.entrySet()) {
            StatementHolder value = (StatementHolder)entry.getValue();
            this.statementCache.remove(entry.getKey(), value);
            JdbcUtils.quietClose(value.rawStatement());
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }
}

