/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.objectpool.PoolService;

public final class ViburUtils {
    private ViburUtils() {
    }

    public static String getPoolName(ViburConfig config) {
        PoolService<ConnHolder> pool = config.getPool();
        boolean initialState = pool.isTerminated();
        String result = config.getName() + '@' + Integer.toHexString(config.hashCode()) + '(' + pool.taken() + '/' + pool.remainingCreated() + '/' + pool.maxSize() + '/' + (!initialState ? (char)'w' : 't') + '/' + (Thread.currentThread().isInterrupted() ? (char)'i' : 'n') + ')';
        if (initialState == pool.isTerminated()) {
            return result;
        }
        return ViburUtils.getPoolName(config);
    }

    public static String getStackTraceAsString(Pattern logLinePattern, StackTraceElement[] stackTrace) {
        int i;
        if (stackTrace == null || stackTrace.length == 0) {
            return "EMPTY STACK TRACE\n";
        }
        for (i = 0; i < stackTrace.length && stackTrace[i].getClassName().startsWith("org.vibur") && !stackTrace[i].getMethodName().equals("getConnection"); ++i) {
        }
        StringBuilder builder = new StringBuilder(4096);
        ++i;
        while (i < stackTrace.length) {
            String stackTraceStr = stackTrace[i].toString();
            if (logLinePattern == null || logLinePattern.matcher(stackTraceStr).matches()) {
                builder.append("  at ").append(stackTraceStr).append('\n');
            }
            ++i;
        }
        return builder.toString();
    }

    public static String formatSql(String sqlQuery, List<Object[]> sqlQueryParams) {
        StringBuilder result = new StringBuilder(1024).append("-- ").append(sqlQuery);
        if (sqlQueryParams != null && !sqlQueryParams.isEmpty()) {
            Object[] params = sqlQueryParams.toArray();
            Arrays.sort(params, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return Integer.compare((Integer)((Object[])o1)[1], (Integer)((Object[])o2)[1]);
                }
            });
            result.append("\n-- Parameters:\n-- ").append(Arrays.deepToString(params));
        }
        return result.toString();
    }
}

