/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.hsqldb.cmdline.SqlToolError;
import org.junit.After;
import org.junit.BeforeClass;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.vibur.dbcp.ViburDBCPDataSource;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.stcache.ClhmStatementCache;
import org.vibur.dbcp.stcache.StatementCache;
import org.vibur.dbcp.stcache.StatementHolder;
import org.vibur.dbcp.stcache.StatementMethod;
import org.vibur.dbcp.util.HsqldbUtils;
import org.vibur.dbcp.util.SimpleDataSource;

public abstract class AbstractDataSourceTest {
    protected static final String PROPERTIES_FILE = "src/test/resources/vibur-dbcp-test.properties";
    protected static final int POOL_INITIAL_SIZE = 2;
    protected static final int POOL_MAX_SIZE = 10;
    protected static final int CONNECTION_TIMEOUT_MS = 5000;
    private static String jdbcUrl;
    private static String username;
    private static String password;
    private ViburDBCPDataSource dataSource = null;

    protected AbstractDataSourceTest() {
    }

    @BeforeClass
    public static void deployDatabaseSchemaAndData() throws IOException, SqlToolError, SQLException {
        Properties properties = AbstractDataSourceTest.loadProperties();
        jdbcUrl = properties.getProperty("jdbcUrl");
        username = properties.getProperty("username");
        password = properties.getProperty("password");
        HsqldbUtils.deployDatabaseSchemaAndData(jdbcUrl, username, password);
    }

    protected static Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(PROPERTIES_FILE));
        return properties;
    }

    @After
    public void terminateDataSource() {
        if (this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
    }

    protected ViburDBCPDataSource createDataSourceNoStatementsCache() throws ViburDBCPException {
        this.dataSource = new ViburDBCPDataSource();
        this.dataSource.setJdbcUrl(jdbcUrl);
        this.dataSource.setUsername(username);
        this.dataSource.setPassword(password);
        this.dataSource.setPoolInitialSize(2);
        this.dataSource.setPoolMaxSize(10);
        this.dataSource.setConnectionTimeoutInMs(5000L);
        this.dataSource.setConnectionIdleLimitInSeconds(120);
        this.dataSource.setLogQueryExecutionLongerThanMs(0L);
        this.dataSource.setLogConnectionLongerThanMs(0L);
        this.dataSource.setLogLargeResultSet(2L);
        this.dataSource.setValidateTimeoutInSeconds(1);
        this.dataSource.setClearSQLWarnings(true);
        this.dataSource.start();
        return this.dataSource;
    }

    protected ViburDBCPDataSource createDataSourceWithTracking() throws ViburDBCPException {
        this.dataSource = new ViburDBCPDataSource();
        this.dataSource.setJdbcUrl(jdbcUrl);
        this.dataSource.setUsername(username);
        this.dataSource.setPassword(password);
        this.dataSource.setPoolInitialSize(2);
        this.dataSource.setPoolMaxSize(10);
        this.dataSource.setConnectionTimeoutInMs(5000L);
        this.dataSource.setConnectionIdleLimitInSeconds(120);
        this.dataSource.setLogQueryExecutionLongerThanMs(0L);
        this.dataSource.setLogConnectionLongerThanMs(0L);
        this.dataSource.setLogLargeResultSet(2L);
        this.dataSource.setPoolEnableConnectionTracking(true);
        this.dataSource.start();
        return this.dataSource;
    }

    protected ViburDBCPDataSource createDataSourceWithStatementsCache() throws ViburDBCPException {
        this.dataSource = new ViburDBCPDataSource();
        this.dataSource.setJdbcUrl(jdbcUrl);
        this.dataSource.setUsername(username);
        this.dataSource.setPassword(password);
        this.dataSource.setPoolInitialSize(2);
        this.dataSource.setPoolMaxSize(10);
        this.dataSource.setConnectionTimeoutInMs(5000L);
        this.dataSource.setConnectionIdleLimitInSeconds(120);
        this.dataSource.setLogQueryExecutionLongerThanMs(1L);
        this.dataSource.setStatementCacheMaxSize(1);
        this.dataSource.start();
        return this.dataSource;
    }

    protected ViburDBCPDataSource createDataSourceFromExternalDataSource() throws ViburDBCPException {
        this.dataSource = new ViburDBCPDataSource();
        this.dataSource.setExternalDataSource((DataSource)new SimpleDataSource(jdbcUrl));
        this.dataSource.setUsername(username);
        this.dataSource.setPassword(password);
        this.dataSource.setPoolInitialSize(2);
        this.dataSource.setPoolMaxSize(10);
        this.dataSource.setConnectionTimeoutInMs(5000L);
        this.dataSource.setConnectionIdleLimitInSeconds(120);
        this.dataSource.setLogQueryExecutionLongerThanMs(0L);
        this.dataSource.setLogConnectionLongerThanMs(0L);
        this.dataSource.start();
        return this.dataSource;
    }

    protected ViburDBCPDataSource createDataSourceNotStarted() throws ViburDBCPException {
        this.dataSource = new ViburDBCPDataSource();
        this.dataSource.setJdbcUrl(jdbcUrl);
        this.dataSource.setUsername(username);
        this.dataSource.setPassword(password);
        this.dataSource.setPoolInitialSize(2);
        this.dataSource.setPoolMaxSize(10);
        this.dataSource.setConnectionTimeoutInMs(5000L);
        this.dataSource.setConnectionIdleLimitInSeconds(120);
        this.dataSource.setLogQueryExecutionLongerThanMs(-1L);
        return this.dataSource;
    }

    public static ConcurrentMap<StatementMethod, StatementHolder> mockStatementCache(ViburDBCPDataSource ds) {
        final ConcurrentMap[] holder = new ConcurrentMap[1];
        ds.setStatementCache((StatementCache)new ClhmStatementCache(ds.getStatementCacheMaxSize()){

            protected ConcurrentMap<StatementMethod, StatementHolder> buildStatementCache(int maxSize) {
                ConcurrentMap mockedStatementCache;
                holder[0] = mockedStatementCache = (ConcurrentMap)Mockito.mock(ConcurrentMap.class, (Answer)AdditionalAnswers.delegatesTo((Object)super.buildStatementCache(maxSize)));
                return mockedStatementCache;
            }
        });
        return holder[0];
    }
}

