/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.vibur.dbcp.AbstractDataSourceTest;
import org.vibur.dbcp.ViburDBCPDataSource;
import org.vibur.dbcp.pool.Hook;

public class ConnectionHookTest
extends AbstractDataSourceTest {
    @Test
    public void testInitGetConnectionHooks() throws SQLException {
        final ArrayList executionOrder = new ArrayList();
        ViburDBCPDataSource ds = this.createDataSourceNotStarted();
        ds.setPoolInitialSize(0);
        ds.setPoolMaxSize(1);
        ds.getConnHooks().addOnInit(new Hook.InitConnection(){

            public void on(Connection rawConnection, long takenNanos) throws SQLException {
                executionOrder.add("init");
            }
        });
        ds.getConnHooks().addOnGet(new Hook.GetConnection(){

            public void on(Connection rawConnection, long takenNanos) throws SQLException {
                executionOrder.add("get");
            }
        });
        ds.start();
        Connection connection = ds.getConnection();
        connection.close();
        Assert.assertEquals((long)2L, (long)executionOrder.size());
        Assert.assertEquals((Object)"init", executionOrder.get(0));
        Assert.assertEquals((Object)"get", executionOrder.get(1));
        connection = ds.getConnection();
        connection.close();
        Assert.assertEquals((long)3L, (long)executionOrder.size());
        Assert.assertEquals((Object)"get", executionOrder.get(2));
    }
}

