/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;
import org.vibur.dbcp.AbstractDataSourceTest;
import org.vibur.dbcp.ViburDBCPDataSource;

public class ConnectionProxyTest
extends AbstractDataSourceTest {
    @Test
    public void testSameConnection() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        try (Connection connection = ds.getConnection();
             Statement statement = connection.createStatement();
             PreparedStatement pStatement = connection.prepareStatement("select count(*) from actor");
             CallableStatement cStatement = connection.prepareCall("select count(*) from actor");){
            Assert.assertSame((Object)connection, (Object)statement.getConnection());
            Assert.assertSame((Object)connection, (Object)pStatement.getConnection());
            Assert.assertSame((Object)connection, (Object)cStatement.getConnection());
            DatabaseMetaData metaData = connection.getMetaData();
            Assert.assertSame((Object)connection, (Object)metaData.getConnection());
        }
    }
}

