/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.vibur.dbcp.AbstractDataSourceTest;
import org.vibur.dbcp.ViburDBCPDataSource;
import org.vibur.dbcp.pool.Hook;

public class StatementHookTest
extends AbstractDataSourceTest {
    @Test
    public void testStatementExecutionHook() throws SQLException {
        final ArrayList executionOrder = new ArrayList();
        ViburDBCPDataSource ds = this.createDataSourceNotStarted();
        ds.getInvocationHooks().addOnStatementExecution(new Hook.StatementExecution(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object on(Statement proxy, Method method, Object[] args, String sqlQuery, List<Object[]> sqlQueryParams, Hook.StatementProceedingPoint proceed) throws SQLException {
                try {
                    executionOrder.add("aa");
                    Object object = proceed.on(proxy, method, args, sqlQuery, sqlQueryParams, proceed);
                    return object;
                }
                finally {
                    executionOrder.add("bb");
                }
            }
        });
        ds.getInvocationHooks().addOnStatementExecution(new Hook.StatementExecution(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object on(Statement proxy, Method method, Object[] args, String sqlQuery, List<Object[]> sqlQueryParams, Hook.StatementProceedingPoint proceed) throws SQLException {
                try {
                    executionOrder.add("cc");
                    Object object = proceed.on(proxy, method, args, sqlQuery, sqlQueryParams, proceed);
                    return object;
                }
                finally {
                    executionOrder.add("dd");
                }
            }
        });
        ds.start();
        try (Connection connection = ds.getConnection();
             Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("select * from actor where first_name = 'CHRISTIAN'");
            Assert.assertTrue((boolean)resultSet.next());
        }
        Assert.assertEquals((Object)"aa", executionOrder.get(0));
        Assert.assertEquals((Object)"cc", executionOrder.get(1));
        Assert.assertEquals((Object)"dd", executionOrder.get(2));
        Assert.assertEquals((Object)"bb", executionOrder.get(3));
    }
}

