/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vibur.dbcp.AbstractDataSourceTest;
import org.vibur.dbcp.ViburDBCPDataSource;
import org.vibur.dbcp.pool.TakenConnection;
import org.vibur.dbcp.stcache.StatementHolder;
import org.vibur.dbcp.stcache.StatementMethod;

@RunWith(value=MockitoJUnitRunner.class)
public class ViburDBCPDataSourceTest
extends AbstractDataSourceTest {
    @Captor
    private ArgumentCaptor<StatementMethod> key1;
    @Captor
    private ArgumentCaptor<StatementMethod> key2;
    @Captor
    private ArgumentCaptor<StatementHolder> val1;
    @Captor
    private ArgumentCaptor<StatementHolder> val2;
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testSelectStatementNoStatementsCache() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        ViburDBCPDataSourceTest.doTestSelectStatement((DataSource)ds);
    }

    @Test
    public void testSelectStatementFromExternalDataSource() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceFromExternalDataSource();
        ViburDBCPDataSourceTest.doTestSelectStatement((DataSource)ds);
    }

    @Test
    public void testSelectStatementWithStatementsCache() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceWithStatementsCache();
        ConcurrentMap<StatementMethod, StatementHolder> mockedStatementCache = ViburDBCPDataSourceTest.mockStatementCache(ds);
        try (Connection connection = ds.getConnection();){
            ViburDBCPDataSourceTest.executeAndVerifySelectStatement(connection);
            ViburDBCPDataSourceTest.executeAndVerifySelectStatement(connection);
            Mockito.verifyZeroInteractions((Object[])new Object[]{mockedStatementCache});
        }
    }

    @Test
    public void testPreparedSelectStatementNoStatementsCache() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        ViburDBCPDataSourceTest.doTestPreparedSelectStatement((DataSource)ds);
    }

    @Test
    public void testPreparedSelectStatementFromExternalDataSource() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceFromExternalDataSource();
        ViburDBCPDataSourceTest.doTestPreparedSelectStatement((DataSource)ds);
    }

    @Test
    public void testPreparedSelectStatementWithStatementsCache() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceWithStatementsCache();
        ConcurrentMap<StatementMethod, StatementHolder> mockedStatementCache = ViburDBCPDataSourceTest.mockStatementCache(ds);
        try (Connection connection = ds.getConnection();){
            ViburDBCPDataSourceTest.executeAndVerifyPreparedSelectStatement(connection);
            ViburDBCPDataSourceTest.executeAndVerifyPreparedSelectStatement(connection);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockedStatementCache});
            ((ConcurrentMap)inOrder.verify(mockedStatementCache)).get(this.key1.capture());
            ((ConcurrentMap)inOrder.verify(mockedStatementCache)).putIfAbsent(Mockito.same((Object)this.key1.getValue()), this.val1.capture());
            ((ConcurrentMap)inOrder.verify(mockedStatementCache)).get(this.key2.capture());
            Assert.assertEquals((long)1L, (long)mockedStatementCache.size());
            Assert.assertTrue((boolean)mockedStatementCache.containsKey(this.key1.getValue()));
            Assert.assertEquals((Object)this.key1.getValue(), (Object)this.key2.getValue());
            Assert.assertEquals((Object)StatementHolder.State.AVAILABLE, ((StatementHolder)this.val1.getValue()).state().get());
        }
    }

    @Test
    public void testTwoPreparedSelectStatementsWithStatementsCache() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceWithStatementsCache();
        ConcurrentMap<StatementMethod, StatementHolder> mockedStatementCache = ViburDBCPDataSourceTest.mockStatementCache(ds);
        try (Connection connection = ds.getConnection();){
            ViburDBCPDataSourceTest.executeAndVerifyPreparedSelectStatement(connection);
            ViburDBCPDataSourceTest.executeAndVerifyPreparedSelectStatementByLastName(connection);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockedStatementCache});
            ((ConcurrentMap)inOrder.verify(mockedStatementCache)).get(this.key1.capture());
            ((ConcurrentMap)inOrder.verify(mockedStatementCache)).putIfAbsent(Mockito.same((Object)this.key1.getValue()), this.val1.capture());
            ((ConcurrentMap)inOrder.verify(mockedStatementCache)).get(this.key2.capture());
            ((ConcurrentMap)inOrder.verify(mockedStatementCache)).putIfAbsent(Mockito.same((Object)this.key2.getValue()), this.val2.capture());
            Assert.assertEquals((long)1L, (long)mockedStatementCache.size());
            Assert.assertTrue((boolean)mockedStatementCache.containsKey(this.key2.getValue()));
            Assert.assertNotEquals((Object)this.key1.getValue(), (Object)this.key2.getValue());
            Assert.assertEquals((Object)StatementHolder.State.EVICTED, ((StatementHolder)this.val1.getValue()).state().get());
            Assert.assertEquals((Object)StatementHolder.State.AVAILABLE, ((StatementHolder)this.val2.getValue()).state().get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionOnOneConnectionDoesNotImpactOtherConnections() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        Assert.assertEquals((long)2L, (long)ds.getPool().remainingCreated());
        try (Connection connection = ds.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("drop table nonexistent");
            Assert.fail((String)"SQLException expected");
        }
        Connection internal1 = connection.unwrap(Connection.class);
        Assert.assertTrue((boolean)internal1.isClosed());
        Assert.assertEquals((long)1L, (long)ds.getPool().remainingCreated());
        connection = ds.getConnection();
        try {
            ViburDBCPDataSourceTest.executeAndVerifySelectStatement(connection);
        }
        finally {
            connection.close();
        }
        Connection internal2 = connection.unwrap(Connection.class);
        Assert.assertNotSame((Object)internal1, (Object)internal2);
        Assert.assertFalse((boolean)internal2.isClosed());
        Assert.assertEquals((long)1L, (long)ds.getPool().remainingCreated());
    }

    @Test
    public void testStatementCloseShouldCloseTheInternalStatementToo() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        Connection connection = ds.getConnection();
        Statement statement = connection.createStatement();
        PreparedStatement pStatement = connection.prepareStatement("select * from actor where first_name = ?");
        pStatement.close();
        statement.close();
        connection.close();
        Statement internalStatement = statement.unwrap(Statement.class);
        Assert.assertTrue((boolean)statement.isClosed());
        Assert.assertTrue((boolean)internalStatement.isClosed());
        PreparedStatement internalPStatement = pStatement.unwrap(PreparedStatement.class);
        Assert.assertTrue((boolean)pStatement.isClosed());
        Assert.assertTrue((boolean)internalPStatement.isClosed());
    }

    @Test
    public void testConnectionCloseAfterPoolTerminationShouldCloseTheInternalConnectionToo() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceWithTracking();
        Connection connection = ds.getConnection();
        ds.close();
        Connection internalConnection = connection.unwrap(Connection.class);
        Assert.assertFalse((boolean)connection.isClosed());
        Assert.assertFalse((boolean)internalConnection.isClosed());
        connection.close();
        Assert.assertTrue((boolean)connection.isClosed());
        Assert.assertTrue((boolean)internalConnection.isClosed());
    }

    @Test
    public void testGetConnectionAfterPoolTermination() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        ds.setAllowConnectionAfterTermination(true);
        ds.close();
        Connection connection = ds.getConnection();
        Assert.assertFalse((boolean)connection.isClosed());
        Assert.assertFalse((boolean)Proxy.isProxyClass(connection.getClass()));
        connection.close();
    }

    @Test
    public void testGetConnectionAfterPoolTerminationFail() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        ds.setAllowConnectionAfterTermination(false);
        ds.close();
        this.exception.expect(SQLException.class);
        ds.getConnection();
    }

    @Test
    public void testGetNonPooledConnection() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        Connection connection = ds.getNonPooledConnection();
        Assert.assertFalse((boolean)connection.isClosed());
        Assert.assertFalse((boolean)Proxy.isProxyClass(connection.getClass()));
        connection.close();
    }

    @Test
    public void testSeverPooledConnection() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        Connection connection = ds.getConnection();
        Connection internalConnection = connection.unwrap(Connection.class);
        int createdTotal = ds.getPool().createdTotal();
        Assert.assertFalse((boolean)connection.isClosed());
        Assert.assertFalse((boolean)internalConnection.isClosed());
        ds.severConnection(connection);
        Assert.assertTrue((boolean)connection.isClosed());
        Assert.assertTrue((boolean)internalConnection.isClosed());
        Assert.assertEquals((long)(createdTotal - 1), (long)ds.getPool().createdTotal());
    }

    @Test
    public void testSeverNonPooledConnection() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        Connection connection = ds.getNonPooledConnection();
        Assert.assertFalse((boolean)connection.isClosed());
        ds.severConnection(connection);
        Assert.assertTrue((boolean)connection.isClosed());
    }

    @Test
    public void testTakenConnections() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceWithTracking();
        Connection connection = ds.getConnection();
        TakenConnection[] takenConnections = ds.getTakenConnections();
        Assert.assertEquals((long)1L, (long)takenConnections.length);
        Assert.assertSame((Object)connection, (Object)takenConnections[0].getProxyConnection());
        long currentNanoTime = System.nanoTime();
        long takenNanoTime = takenConnections[0].getTakenNanoTime();
        Assert.assertTrue((takenNanoTime > 0L ? 1 : 0) != 0);
        Assert.assertTrue((currentNanoTime > takenNanoTime ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)takenConnections[0].getLastAccessNanoTime());
        TakenConnection[] takenConnections2 = ds.getTakenConnections();
        Assert.assertNotSame((Object)takenConnections, (Object)takenConnections2);
        Assert.assertNotSame((Object)takenConnections[0], (Object)takenConnections2[0]);
        Assert.assertSame((Object)takenConnections[0].getProxyConnection(), (Object)takenConnections2[0].getProxyConnection());
        connection.close();
    }

    @Test
    public void testLogTakenConnectionsOnTimeout() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNotStarted();
        ds.setPoolInitialSize(1);
        ds.setPoolMaxSize(2);
        ds.setConnectionTimeoutInMs(10L);
        ds.setLogTakenConnectionsOnTimeout(true);
        ds.setLogLineRegex(Pattern.compile("^((?!mockito|junit|reflect).)*$"));
        ds.start();
        try (Connection c1 = ds.getConnection();
             Connection c2 = ds.getConnection();){
            this.exception.expect(SQLTimeoutException.class);
            ds.getConnection();
        }
    }

    @Test
    public void testInterruptedWhileGettingConnection() {
        ViburDBCPDataSource ds = this.createDataSourceWithTracking();
        Thread.currentThread().interrupt();
        try {
            ds.getConnection();
            Assert.fail((String)"SQLException expected");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"VI004", (Object)e.getSQLState());
        }
        finally {
            Assert.assertTrue((boolean)Thread.interrupted());
        }
    }

    private static void doTestSelectStatement(DataSource ds) throws SQLException {
        try (Connection connection = ds.getConnection();){
            ViburDBCPDataSourceTest.executeAndVerifySelectStatement(connection);
        }
    }

    private static void doTestPreparedSelectStatement(DataSource ds) throws SQLException {
        try (Connection connection = ds.getConnection();){
            ViburDBCPDataSourceTest.executeAndVerifyPreparedSelectStatement(connection);
        }
    }

    private static void executeAndVerifySelectStatement(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("select * from actor where first_name = 'CHRISTIAN'");
            HashSet<String> expectedLastNames = new HashSet<String>(Arrays.asList("GABLE", "AKROYD", "NEESON"));
            while (resultSet.next()) {
                String lastName = resultSet.getString("last_name");
                Assert.assertTrue((boolean)expectedLastNames.remove(lastName));
            }
            Assert.assertTrue((boolean)expectedLastNames.isEmpty());
        }
    }

    private static void executeAndVerifyPreparedSelectStatement(Connection connection) throws SQLException {
        try (PreparedStatement pStatement = connection.prepareStatement("select * from actor where first_name = ?");){
            pStatement.setString(1, "CHRISTIAN");
            ResultSet resultSet = pStatement.executeQuery();
            HashSet<String> expectedLastNames = new HashSet<String>(Arrays.asList("GABLE", "AKROYD", "NEESON"));
            while (resultSet.next()) {
                String lastName = resultSet.getString("last_name");
                Assert.assertTrue((boolean)expectedLastNames.remove(lastName));
            }
            Assert.assertTrue((boolean)expectedLastNames.isEmpty());
        }
    }

    private static void executeAndVerifyPreparedSelectStatementByLastName(Connection connection) throws SQLException {
        try (PreparedStatement pStatement = connection.prepareStatement("select * from actor where last_name = ?");){
            pStatement.setString(1, "CROWE");
            ResultSet resultSet = pStatement.executeQuery();
            HashSet<String> expectedFirstNames = new HashSet<String>(Collections.singletonList("SIDNEY"));
            while (resultSet.next()) {
                String firstName = resultSet.getString("first_name");
                Assert.assertTrue((boolean)expectedFirstNames.remove(firstName));
            }
            Assert.assertTrue((boolean)expectedFirstNames.isEmpty());
        }
    }
}

