/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;
import org.vibur.dbcp.AbstractDataSourceTest;
import org.vibur.dbcp.ViburDBCPDataSource;

public class WrapperTest
extends AbstractDataSourceTest {
    @Test
    public void testWrapperMethods() throws SQLException {
        ViburDBCPDataSource ds = this.createDataSourceNoStatementsCache();
        try (Connection connection = ds.getConnection();
             Statement statement = connection.createStatement();
             PreparedStatement pStatement = connection.prepareStatement("select count(*) from actor");
             CallableStatement cStatement = connection.prepareCall("select count(*) from actor");){
            DatabaseMetaData metaData = connection.getMetaData();
            Assert.assertTrue((boolean)metaData.isWrapperFor(DatabaseMetaData.class));
            DatabaseMetaData md = metaData.unwrap(DatabaseMetaData.class);
            Assert.assertNotNull((Object)md);
            Assert.assertNotEquals((Object)md, (Object)metaData);
            Assert.assertTrue((boolean)cStatement.isWrapperFor(CallableStatement.class));
            CallableStatement cs = cStatement.unwrap(CallableStatement.class);
            Assert.assertNotNull((Object)cs);
            Assert.assertNotEquals((Object)cs, (Object)cStatement);
            Assert.assertTrue((boolean)pStatement.isWrapperFor(PreparedStatement.class));
            PreparedStatement ps = pStatement.unwrap(PreparedStatement.class);
            Assert.assertNotNull((Object)ps);
            Assert.assertNotEquals((Object)ps, (Object)pStatement);
            Assert.assertTrue((boolean)statement.isWrapperFor(Statement.class));
            Statement s = statement.unwrap(Statement.class);
            Assert.assertNotNull((Object)s);
            Assert.assertNotEquals((Object)s, (Object)statement);
            ResultSet resultSet = statement.executeQuery("select * from actor where first_name = 'CHRISTIAN'");
            Assert.assertTrue((boolean)resultSet.isWrapperFor(ResultSet.class));
            ResultSet r = resultSet.unwrap(ResultSet.class);
            Assert.assertNotNull((Object)r);
            Assert.assertNotEquals((Object)r, (Object)resultSet);
            Assert.assertTrue((boolean)connection.isWrapperFor(Connection.class));
            Connection c = connection.unwrap(Connection.class);
            Assert.assertNotNull((Object)c);
            Assert.assertNotEquals((Object)c, (Object)connection);
        }
    }
}

