/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.perf;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburDBCPDataSource;
import org.vibur.dbcp.ViburDBCPException;

public class ViburDBCPGetConnectionTestPerf {
    private static final Logger logger = LoggerFactory.getLogger(ViburDBCPGetConnectionTestPerf.class);
    private static final int INITIAL_SIZE = 50;
    private static final int MAX_SIZE = 200;
    private static final long TIMEOUT_MS = 2000L;
    private static final boolean FAIR = true;
    private static final int ITERATIONS = 100;
    private static final int THREADS_COUNT = 500;
    private static final long DO_WORK_FOR_MS = 2L;

    public static void main(String[] args) throws InterruptedException, ViburDBCPException {
        ViburDBCPDataSource ds = ViburDBCPGetConnectionTestPerf.createDataSource();
        ds.start();
        AtomicInteger errors = new AtomicInteger(0);
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch readySignal = new CountDownLatch(500);
        CountDownLatch doneSignal = new CountDownLatch(500);
        for (int i = 0; i < 500; ++i) {
            Thread thread = new Thread(new Worker(ds, errors, 2L, readySignal, startSignal, doneSignal));
            thread.start();
        }
        readySignal.await();
        long startNanoTime = System.nanoTime();
        startSignal.countDown();
        doneSignal.await();
        System.out.println(String.format("Total execution time %f ms, unsuccessful takes %d.", (double)(System.nanoTime() - startNanoTime) * 1.0E-6, errors.get()));
        ds.close();
    }

    private static ViburDBCPDataSource createDataSource() {
        ViburDBCPDataSource ds = new ViburDBCPDataSource();
        ds.setJdbcUrl("jdbc:hsqldb:mem:sakila;shutdown=false");
        ds.setUsername("sa");
        ds.setPassword("");
        ds.setPoolInitialSize(50);
        ds.setPoolMaxSize(200);
        ds.setConnectionTimeoutInMs(2000L);
        ds.setPoolFair(true);
        return ds;
    }

    private static void doWork(long millis) {
        if (millis <= 0L) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class Worker
    implements Runnable {
        private final ViburDBCPDataSource ds;
        private final AtomicInteger errors;
        private final long millis;
        private final CountDownLatch readySignal;
        private final CountDownLatch startSignal;
        private final CountDownLatch doneSignal;

        private Worker(ViburDBCPDataSource ds, AtomicInteger errors, long millis, CountDownLatch readySignal, CountDownLatch startSignal, CountDownLatch doneSignal) {
            this.ds = ds;
            this.errors = errors;
            this.millis = millis;
            this.startSignal = startSignal;
            this.readySignal = readySignal;
            this.doneSignal = doneSignal;
        }

        @Override
        public void run() {
            try {
                this.readySignal.countDown();
                this.startSignal.await();
                for (int i = 0; i < 100; ++i) {
                    try {
                        Connection connection = this.ds.getConnection();
                        ViburDBCPGetConnectionTestPerf.doWork(this.millis);
                        connection.close();
                        continue;
                    }
                    catch (SQLException e) {
                        logger.error(e.toString());
                        this.errors.incrementAndGet();
                    }
                }
            }
            catch (InterruptedException ignored) {
                this.errors.incrementAndGet();
            }
            finally {
                this.doneSignal.countDown();
            }
        }
    }
}

