/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.vibur.dbcp.util.JdbcUtils;

public class HsqldbUtils {
    private static final String HSQLDB_SCHEMA_AND_DATA_SQL = "hsqldb_schema_and_data.sql";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployDatabaseSchemaAndData(String jdbcUrl, String username, String password) throws IOException, SqlToolError, SQLException {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(jdbcUrl, username, password);
            InputStreamReader isr = new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(HSQLDB_SCHEMA_AND_DATA_SQL), System.getProperty("file.encoding"));
            SqlFile sqlFile = new SqlFile((Reader)isr, "--sql", System.out, null, false, null);
            sqlFile.setConnection(connection);
            sqlFile.execute();
        }
        catch (Throwable throwable) {
            JdbcUtils.quietClose(connection);
            throw throwable;
        }
        JdbcUtils.quietClose((Connection)connection);
    }
}

