/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.Connector;
import org.vibur.dbcp.pool.Hook;
import org.vibur.dbcp.pool.HookHolder;
import org.vibur.dbcp.pool.ViburObjectFactory;
import org.vibur.dbcp.util.JdbcUtils;

public class ConnectionFactory
implements ViburObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private final ViburConfig config;
    private final HookHolder.ConnHooksAccessor connHooksAccessor;
    private final AtomicInteger version = new AtomicInteger(1);

    public ConnectionFactory(ViburConfig config) throws ViburDBCPException {
        this.config = config;
        this.connHooksAccessor = (HookHolder.ConnHooksAccessor)((Object)config.getConnHooks());
        JdbcUtils.initLoginTimeout(config);
    }

    @Override
    public ConnHolder create() throws ViburDBCPException {
        return this.create(this.config.getConnector());
    }

    @Override
    public ConnHolder create(Connector connector) throws ViburDBCPException {
        Connection rawConnection = null;
        SQLException sqlException = null;
        long startNanoTime = System.nanoTime();
        try {
            rawConnection = Objects.requireNonNull(connector.connect());
        }
        catch (SQLException e) {
            sqlException = e;
            logger.debug("Couldn't create rawConnection", (Throwable)e);
        }
        return this.postCreate(rawConnection, sqlException, startNanoTime);
    }

    private ConnHolder postCreate(Connection rawConnection, SQLException sqlException, long startNanoTime) throws ViburDBCPException {
        long currentNanoTime;
        Hook.InitConnection[] onInit = this.connHooksAccessor.onInit();
        long l = currentNanoTime = onInit.length > 0 || this.config.getConnectionIdleLimitInSeconds() >= 0 ? System.nanoTime() : 0L;
        if (onInit.length > 0) {
            try {
                long takenNanos = currentNanoTime - startNanoTime;
                for (Hook.InitConnection hook : onInit) {
                    hook.on(rawConnection, takenNanos);
                }
            }
            catch (SQLException e) {
                JdbcUtils.quietClose(rawConnection);
                sqlException = JdbcUtils.chainSQLException(sqlException, e);
            }
        }
        if (sqlException != null) {
            throw new ViburDBCPException(sqlException);
        }
        logger.debug("Created rawConnection {}", (Object)rawConnection);
        return this.prepareTracking(new ConnHolder(rawConnection, this.version(), this.config.getConnectionIdleLimitInSeconds() >= 0 ? currentNanoTime : 0L));
    }

    public boolean readyToTake(ConnHolder connHolder) {
        long idleNanos;
        if (connHolder.version() != this.version()) {
            return false;
        }
        int idleLimit = this.config.getConnectionIdleLimitInSeconds();
        if (idleLimit >= 0 && TimeUnit.NANOSECONDS.toSeconds(idleNanos = System.nanoTime() - connHolder.getRestoredNanoTime()) >= (long)idleLimit && !JdbcUtils.validateOrInitialize(connHolder.rawConnection(), this.config.getTestConnectionQuery(), this.config)) {
            logger.debug("Couldn't validate rawConnection {}", (Object)connHolder.rawConnection());
            return false;
        }
        this.prepareTracking(connHolder);
        return true;
    }

    public boolean readyToRestore(ConnHolder connHolder) {
        Hook.CloseConnection[] onClose = this.connHooksAccessor.onClose();
        long currentNanoTime = onClose.length > 0 || this.config.getConnectionIdleLimitInSeconds() >= 0 ? System.nanoTime() : 0L;
        long startNanoTime = connHolder.getTakenNanoTime();
        this.clearTracking(connHolder);
        if (onClose.length > 0) {
            Connection rawConnection = connHolder.rawConnection();
            try {
                long takenNanos = currentNanoTime - startNanoTime;
                for (Hook.CloseConnection hook : onClose) {
                    hook.on(rawConnection, takenNanos);
                }
            }
            catch (SQLException e) {
                logger.debug("Couldn't reset rawConnection {}", (Object)rawConnection, (Object)e);
                return false;
            }
        }
        if (this.config.getConnectionIdleLimitInSeconds() >= 0) {
            connHolder.setRestoredNanoTime(currentNanoTime);
        }
        return true;
    }

    private ConnHolder prepareTracking(ConnHolder connHolder) {
        if (this.config.isPoolEnableConnectionTracking()) {
            connHolder.setTakenNanoTime(System.nanoTime());
            connHolder.setThread(Thread.currentThread());
            connHolder.setLocation(new Throwable());
        } else if (this.connHooksAccessor.onGet().length > 0 || this.connHooksAccessor.onClose().length > 0) {
            connHolder.setTakenNanoTime(System.nanoTime());
        }
        return connHolder;
    }

    private void clearTracking(ConnHolder connHolder) {
        if (this.config.isPoolEnableConnectionTracking()) {
            connHolder.setTakenNanoTime(0L);
            connHolder.setLastAccessNanoTime(0L);
            connHolder.setProxyConnection(null);
            connHolder.setThread(null);
            connHolder.setLocation(null);
        }
    }

    public void destroy(ConnHolder connHolder) {
        Connection rawConnection = connHolder.rawConnection();
        logger.debug("Destroying rawConnection {}", (Object)rawConnection);
        this.closeStatements(rawConnection);
        Hook.DestroyConnection[] onDestroy = this.connHooksAccessor.onDestroy();
        long startTime = onDestroy.length == 0 ? 0L : System.nanoTime();
        JdbcUtils.quietClose(rawConnection);
        long takenNanos = onDestroy.length == 0 ? 0L : System.nanoTime() - startTime;
        for (Hook.DestroyConnection hook : onDestroy) {
            hook.on(rawConnection, takenNanos);
        }
    }

    private void closeStatements(Connection rawConnection) {
        if (this.config.getStatementCache() != null) {
            this.config.getStatementCache().removeAll(rawConnection);
        }
    }

    @Override
    public int version() {
        return this.version.get();
    }

    @Override
    public boolean compareAndSetVersion(int expect, int update) {
        return this.version.compareAndSet(expect, update);
    }
}

