/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.pool;

import java.sql.Connection;

public abstract class TakenConnection {
    private Connection proxyConnection = null;
    private long takenNanoTime = 0L;
    private long lastAccessNanoTime = 0L;
    private Thread thread = null;
    private Throwable location = null;

    TakenConnection() {
    }

    TakenConnection(TakenConnection takenConnection) {
        this.proxyConnection = takenConnection.proxyConnection;
        this.takenNanoTime = takenConnection.takenNanoTime;
        this.lastAccessNanoTime = takenConnection.lastAccessNanoTime;
        this.thread = takenConnection.thread;
        this.location = takenConnection.location;
    }

    public Connection getProxyConnection() {
        return this.proxyConnection;
    }

    void setProxyConnection(Connection proxyConnection) {
        this.proxyConnection = proxyConnection;
    }

    public long getTakenNanoTime() {
        return this.takenNanoTime;
    }

    void setTakenNanoTime(long takenNanoTime) {
        this.takenNanoTime = takenNanoTime;
    }

    public long getLastAccessNanoTime() {
        return this.lastAccessNanoTime;
    }

    void setLastAccessNanoTime(long lastAccessNanoTime) {
        this.lastAccessNanoTime = lastAccessNanoTime;
    }

    public Thread getThread() {
        return this.thread;
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    public Throwable getLocation() {
        return this.location;
    }

    void setLocation(Throwable location) {
        this.location = location;
    }

    public String toString() {
        long currentNanoTime = System.nanoTime();
        return TakenConnection.class.getSimpleName() + '@' + Integer.toHexString(this.hashCode()) + '[' + this.proxyConnection + ", takenNanoTime=" + TakenConnection.nanosToMillis(this.takenNanoTime, currentNanoTime) + " ms, " + (this.lastAccessNanoTime == 0L ? "has not been accessed" : "lastAccessNanoTime=" + TakenConnection.nanosToMillis(this.lastAccessNanoTime, currentNanoTime) + " ms") + ", thread=" + this.thread + (this.thread != null ? ", state=" + (Object)((Object)this.thread.getState()) : "") + ']';
    }

    private static double nanosToMillis(long pastNanoTime, long currentNanoTime) {
        return (double)(currentNanoTime - pastNanoTime) * 1.0E-6;
    }
}

