/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.pool.Hook;
import org.vibur.dbcp.pool.HookHolder;
import org.vibur.dbcp.proxy.ExceptionCollector;
import org.vibur.dbcp.util.ViburUtils;

abstract class AbstractInvocationHandler<T>
extends ExceptionCollector
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInvocationHandler.class);
    private static final Object NO_RESULT = new Object();
    private final T target;
    private final ViburConfig config;
    private final Hook.MethodInvocation[] onMethodInvocation;
    private final ExceptionCollector exceptionCollector;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    AbstractInvocationHandler(T target, ViburConfig config, ExceptionCollector exceptionCollector) {
        assert (target != null);
        assert (config != null);
        this.target = target;
        this.config = config;
        this.onMethodInvocation = ((HookHolder.InvocationHooksAccessor)((Object)config.getInvocationHooks())).onMethodInvocation();
        this.exceptionCollector = exceptionCollector == null ? this : exceptionCollector;
    }

    @Override
    public final Object invoke(Object objProxy, Method method, Object[] args) throws SQLException {
        Object unrestrictedResult;
        if (logger.isTraceEnabled()) {
            logger.trace("Calling {} with args {} on {}", new Object[]{method, Arrays.toString(args), this.target});
        }
        Object proxy = objProxy;
        if (!method.getName().startsWith("get") && (unrestrictedResult = this.unrestrictedInvoke(proxy, method, args)) != NO_RESULT) {
            return unrestrictedResult;
        }
        this.restrictedAccessEntry(proxy, method, args);
        return this.restrictedInvoke(proxy, method, args);
    }

    Object unrestrictedInvoke(T proxy, Method method, Object[] args) throws SQLException {
        String methodName = method.getName();
        if (methodName == "equals") {
            return proxy == args[0];
        }
        if (methodName == "hashCode") {
            return System.identityHashCode(proxy);
        }
        if (methodName == "toString") {
            return "Vibur proxy for: " + this.target;
        }
        if (methodName == "unwrap") {
            Class iface = (Class)args[0];
            return this.unwrap(iface);
        }
        if (methodName == "isWrapperFor") {
            return this.isWrapperFor((Class)args[0]);
        }
        return NO_RESULT;
    }

    private void restrictedAccessEntry(T proxy, Method method, Object[] args) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(this.target.getClass().getName() + " is closed.", "VI005");
        }
        for (Hook.MethodInvocation hook : this.onMethodInvocation) {
            hook.on(proxy, method, args);
        }
    }

    Object restrictedInvoke(T proxy, Method method, Object[] args) throws SQLException {
        return this.targetInvoke(method, args);
    }

    final Object targetInvoke(Method method, Object[] args) throws SQLException {
        try {
            return method.invoke(this.target, args);
        }
        catch (ReflectiveOperationException e) {
            throw this.underlyingException(method, args, e);
        }
    }

    private SQLException underlyingException(Method method, Object[] args, ReflectiveOperationException e) {
        Throwable cause;
        if (e instanceof IllegalAccessException) {
            throw AbstractInvocationHandler.unexpectedException(e);
        }
        Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
        if (logger.isDebugEnabled()) {
            logger.debug("Pool {}, the invocation of {} with args {} on {} threw:", new Object[]{ViburUtils.getPoolName(this.config), method, Arrays.toString(args), this.target, cause});
        }
        if (cause instanceof SQLException) {
            SQLException sqlException = (SQLException)cause;
            this.exceptionCollector.addException(sqlException);
            return sqlException;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw AbstractInvocationHandler.unexpectedException(e);
    }

    private static ViburDBCPException unexpectedException(ReflectiveOperationException e) {
        logger.error("Unexpected exception cause", (Throwable)e);
        return new ViburDBCPException(e);
    }

    final boolean close() {
        return !this.closed.getAndSet(true);
    }

    final boolean isClosed() {
        return this.closed.get();
    }

    final T getTarget() {
        return this.target;
    }

    private T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return this.target;
        }
        throw new SQLException("Not a wrapper or unwrapping is disabled for " + iface, "VI006");
    }

    private boolean isWrapperFor(Class<?> iface) {
        return this.config.isAllowUnwrapping() && iface.isInstance(this.target);
    }
}

