/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.ViburDBCPException;

public final class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);

    private JdbcUtils() {
    }

    public static void initLoginTimeout(ViburConfig config) throws ViburDBCPException {
        int loginTimeout = config.getLoginTimeoutInSeconds();
        if (config.getExternalDataSource() == null) {
            DriverManager.setLoginTimeout(loginTimeout);
        } else {
            try {
                config.getExternalDataSource().setLoginTimeout(loginTimeout);
            }
            catch (SQLException e) {
                throw new ViburDBCPException(e);
            }
        }
    }

    public static void setDefaultValues(Connection rawConnection, ViburConfig config) throws SQLException {
        if (config.getDefaultAutoCommit() != null) {
            rawConnection.setAutoCommit(config.getDefaultAutoCommit());
        }
        if (config.getDefaultReadOnly() != null) {
            rawConnection.setReadOnly(config.getDefaultReadOnly());
        }
        if (config.getDefaultTransactionIsolationIntValue() != null) {
            rawConnection.setTransactionIsolation(config.getDefaultTransactionIsolationIntValue());
        }
        if (config.getDefaultCatalog() != null) {
            rawConnection.setCatalog(config.getDefaultCatalog());
        }
    }

    public static boolean validateOrInitialize(Connection rawConnection, String sqlQuery, ViburConfig config) {
        if (sqlQuery == null) {
            return true;
        }
        try {
            if (sqlQuery.equals("isValid")) {
                return rawConnection.isValid(config.getValidateTimeoutInSeconds());
            }
            JdbcUtils.executeSqlQuery(rawConnection, sqlQuery, config);
            return true;
        }
        catch (SQLException e) {
            logger.debug("Couldn't validate/ initialize rawConnection {}", (Object)rawConnection, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeSqlQuery(Connection rawConnection, String sqlQuery, ViburConfig config) throws SQLException {
        int oldTimeout = JdbcUtils.setNetworkTimeoutIfDifferent(rawConnection, config);
        Statement rawStatement = null;
        try {
            rawStatement = rawConnection.createStatement();
            rawStatement.setQueryTimeout(config.getValidateTimeoutInSeconds());
            rawStatement.execute(sqlQuery);
        }
        finally {
            JdbcUtils.quietClose(rawStatement);
        }
        JdbcUtils.resetNetworkTimeout(rawConnection, config.getNetworkTimeoutExecutor(), oldTimeout);
    }

    private static int setNetworkTimeoutIfDifferent(Connection rawConnection, ViburConfig config) throws SQLException {
        int oldTimeout;
        int newTimeout;
        if (config.isUseNetworkTimeout() && (newTimeout = (int)TimeUnit.SECONDS.toMillis(config.getValidateTimeoutInSeconds())) != (oldTimeout = rawConnection.getNetworkTimeout())) {
            rawConnection.setNetworkTimeout(config.getNetworkTimeoutExecutor(), newTimeout);
            return oldTimeout;
        }
        return -1;
    }

    private static void resetNetworkTimeout(Connection rawConnection, Executor executor, int oldTimeout) throws SQLException {
        if (oldTimeout >= 0) {
            rawConnection.setNetworkTimeout(executor, oldTimeout);
        }
    }

    public static void clearWarnings(Connection connection) throws SQLException {
        if (connection != null) {
            connection.clearWarnings();
        }
    }

    public static void clearWarnings(PreparedStatement preparedStatement) throws SQLException {
        if (preparedStatement != null) {
            preparedStatement.clearWarnings();
        }
    }

    public static void quietClose(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            logger.warn("Couldn't close {}", (Object)connection, (Object)e);
        }
    }

    public static void quietClose(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            logger.warn("Couldn't close {}", (Object)statement, (Object)e);
        }
    }

    public static void quietClose(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            logger.warn("Couldn't close {}", (Object)resultSet, (Object)e);
        }
    }

    public static SQLException chainSQLException(SQLException main, SQLException next) {
        if (main == null) {
            return next;
        }
        main.setNextException(next);
        return main;
    }
}

