/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.DataSourceLifecycle;
import org.vibur.dbcp.ViburDBCPConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.ViburDBCPMonitoring;
import org.vibur.dbcp.cache.StatementCache;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.ConnectionFactory;
import org.vibur.dbcp.pool.PoolOperations;
import org.vibur.dbcp.util.JmxUtils;
import org.vibur.dbcp.util.ViburUtils;
import org.vibur.objectpool.BasePool;
import org.vibur.objectpool.ConcurrentLinkedPool;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ArgumentValidation;
import org.vibur.objectpool.util.Listener;
import org.vibur.objectpool.util.TakenListener;
import org.vibur.objectpool.util.ThreadedPoolReducer;

public class ViburDBCPDataSource
extends ViburDBCPConfig
implements DataSource,
DataSourceLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(ViburDBCPDataSource.class);
    public static final String DEFAULT_PROPERTIES_CONFIG_FILE_NAME = "vibur-dbcp-config.properties";
    public static final String DEFAULT_XML_CONFIG_FILE_NAME = "vibur-dbcp-config.xml";
    private final AtomicReference<DataSourceLifecycle.State> state = new AtomicReference<DataSourceLifecycle.State>(DataSourceLifecycle.State.NEW);
    private ConnectionFactory connectionFactory;
    private PoolOperations poolOperations;
    private ThreadedPoolReducer poolReducer = null;
    private PrintWriter logWriter;

    public ViburDBCPDataSource() {
    }

    public ViburDBCPDataSource(String configFileName) throws ViburDBCPException {
        URL config;
        if (configFileName != null) {
            config = this.getURL(configFileName);
            if (config == null) {
                throw new ViburDBCPException("Unable to load resource " + configFileName);
            }
        } else {
            config = this.getURL(DEFAULT_XML_CONFIG_FILE_NAME);
            if (config == null && (config = this.getURL(DEFAULT_PROPERTIES_CONFIG_FILE_NAME)) == null) {
                throw new ViburDBCPException("Unable to load default resources from vibur-dbcp-config.xml or vibur-dbcp-config.properties");
            }
        }
        this.configureFromURL(config);
    }

    public ViburDBCPDataSource(Properties properties) throws ViburDBCPException {
        this.configureFromProperties(properties);
    }

    private URL getURL(String configFileName) {
        URL config = Thread.currentThread().getContextClassLoader().getResource(configFileName);
        if (config == null && (config = this.getClass().getClassLoader().getResource(configFileName)) == null) {
            config = ClassLoader.getSystemResource(configFileName);
        }
        return config;
    }

    private void configureFromURL(URL config) throws ViburDBCPException {
        InputStream inputStream = null;
        try {
            URLConnection uConn = config.openConnection();
            uConn.setUseCaches(false);
            inputStream = uConn.getInputStream();
            Properties properties = new Properties();
            if (config.getFile().endsWith(".xml")) {
                properties.loadFromXML(inputStream);
            } else {
                properties.load(inputStream);
            }
            this.configureFromProperties(properties);
        }
        catch (IOException e) {
            throw new ViburDBCPException(config.toString(), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignored) {
                    logger.debug("Couldn't close configuration URL {}", (Object)config, (Object)ignored);
                }
            }
        }
    }

    private void configureFromProperties(Properties properties) throws ViburDBCPException {
        HashSet<String> fields = new HashSet<String>();
        for (Field field : ViburDBCPConfig.class.getDeclaredFields()) {
            fields.add(field.getName());
        }
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            try {
                if (!fields.contains(key)) {
                    logger.warn("Unknown configuration property {}", (Object)key);
                    continue;
                }
                Field field = ViburDBCPConfig.class.getDeclaredField(key);
                Class<?> type = field.getType();
                if (type == Integer.TYPE || type == Integer.class) {
                    this.set(field, Integer.parseInt(val));
                    continue;
                }
                if (type == Long.TYPE || type == Long.class) {
                    this.set(field, Long.parseLong(val));
                    continue;
                }
                if (type == Float.TYPE || type == Float.class) {
                    this.set(field, Float.valueOf(Float.parseFloat(val)));
                    continue;
                }
                if (type == Boolean.TYPE || type == Boolean.class) {
                    this.set(field, Boolean.parseBoolean(val));
                    continue;
                }
                if (type == String.class) {
                    this.set(field, val);
                    continue;
                }
                throw new ViburDBCPException("Unexpected type for configuration property " + key);
            }
            catch (NumberFormatException | ReflectiveOperationException e) {
                throw new ViburDBCPException(String.format("Error setting configuration property %s, value = %s", key, val), e);
            }
        }
    }

    private void set(Field field, Object value) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(this, value);
    }

    @Override
    public void start() throws ViburDBCPException {
        if (!this.state.compareAndSet(DataSourceLifecycle.State.NEW, DataSourceLifecycle.State.WORKING)) {
            throw new IllegalStateException();
        }
        this.validateConfig();
        this.connectionFactory = new ConnectionFactory(this);
        ConcurrentLinkedPool poolService = new ConcurrentLinkedPool((PoolObjectFactory)this.connectionFactory, this.getPoolInitialSize(), this.getPoolMaxSize(), this.isPoolFair(), (Listener)(this.isPoolEnableConnectionTracking() ? new TakenListener(this.getPoolInitialSize()) : null), this.isPoolFifo());
        this.poolOperations = new PoolOperations(this.connectionFactory, (PoolService<ConnHolder>)poolService, this);
        this.setPool((BasePool)poolService);
        this.initPoolReducer();
        this.initStatementCache();
        if (this.isEnableJMX()) {
            JmxUtils.registerMBean(new ViburDBCPMonitoring(this), this.getJmxName());
        }
        logger.info("Started {}", (Object)this);
    }

    @Override
    public void terminate() {
        DataSourceLifecycle.State oldState = this.state.getAndSet(DataSourceLifecycle.State.TERMINATED);
        if (oldState == DataSourceLifecycle.State.TERMINATED || oldState == DataSourceLifecycle.State.NEW) {
            return;
        }
        this.terminateStatementCache();
        if (this.poolReducer != null) {
            this.poolReducer.terminate();
        }
        if (this.getPool() != null) {
            this.getPool().terminate();
        }
        if (this.isEnableJMX()) {
            JmxUtils.unregisterMBean(this.getJmxName());
        }
        this.unregisterName();
        logger.info("Terminated {}", (Object)this);
    }

    @Override
    public void close() {
        this.terminate();
    }

    @Override
    public DataSourceLifecycle.State getState() {
        return this.state.get();
    }

    private void ensureIsWorking() throws SQLException {
        DataSourceLifecycle.State state = this.getState();
        if (state != DataSourceLifecycle.State.WORKING) {
            throw new SQLException(String.format("Pool %s, %s", new Object[]{this.getName(), state}), state == DataSourceLifecycle.State.NEW ? "VI000" : "VI001");
        }
    }

    private void validateConfig() {
        ArgumentValidation.forbidIllegalArgument((this.getExternalDataSource() == null && this.getJdbcUrl() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getAcquireRetryDelayInMs() < 0L ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getAcquireRetryAttempts() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getConnectionTimeoutInMs() < 0L ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getLoginTimeoutInSeconds() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getStatementCacheMaxSize() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getReducerTimeIntervalInSeconds() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getReducerTimeIntervalInSeconds() == 0 && this.getPoolReducerClass() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getReducerSamples() <= 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getConnectionIdleLimitInSeconds() >= 0 && this.getTestConnectionQuery() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getValidateTimeoutInSeconds() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.isUseNetworkTimeout() && this.getNetworkTimeoutExecutor() == null ? 1 : 0) != 0);
        Objects.requireNonNull(this.getCriticalSQLStates());
        Objects.requireNonNull(this.getViburLogger());
        if (this.getPassword() == null) {
            logger.warn("JDBC password is not specified.");
        }
        if (this.getUsername() == null) {
            logger.warn("JDBC username is not specified.");
        }
        if (this.getLogConnectionLongerThanMs() > this.getConnectionTimeoutInMs()) {
            logger.warn("Setting logConnectionLongerThanMs to {}", (Object)this.getConnectionTimeoutInMs());
            this.setLogConnectionLongerThanMs(this.getConnectionTimeoutInMs());
        }
        if (this.getStatementCacheMaxSize() > 2000) {
            logger.warn("Setting statementCacheMaxSize to {}", (Object)2000);
            this.setStatementCacheMaxSize(2000);
        }
        if (this.getDefaultTransactionIsolation() != null) {
            String defaultTransactionIsolation;
            switch (defaultTransactionIsolation = this.getDefaultTransactionIsolation().toUpperCase()) {
                case "NONE": {
                    this.setDefaultTransactionIsolationValue(0);
                    break;
                }
                case "READ_COMMITTED": {
                    this.setDefaultTransactionIsolationValue(2);
                    break;
                }
                case "REPEATABLE_READ": {
                    this.setDefaultTransactionIsolationValue(4);
                    break;
                }
                case "READ_UNCOMMITTED": {
                    this.setDefaultTransactionIsolationValue(1);
                    break;
                }
                case "SERIALIZABLE": {
                    this.setDefaultTransactionIsolationValue(8);
                    break;
                }
                default: {
                    logger.warn("Unknown defaultTransactionIsolation {}. Will use the driver's default.", (Object)this.getDefaultTransactionIsolation());
                }
            }
        }
    }

    private void initPoolReducer() throws ViburDBCPException {
        if (this.getReducerTimeIntervalInSeconds() > 0) {
            try {
                Object reducer = Class.forName(this.getPoolReducerClass()).getConstructor(ViburDBCPConfig.class).newInstance(this);
                if (!(reducer instanceof ThreadedPoolReducer)) {
                    throw new ViburDBCPException(this.getPoolReducerClass() + " is not an instance of ThreadedPoolReducer");
                }
                this.poolReducer = (ThreadedPoolReducer)reducer;
                this.poolReducer.start();
            }
            catch (ReflectiveOperationException e) {
                throw new ViburDBCPException(e);
            }
        }
    }

    private void initStatementCache() {
        int statementCacheMaxSize = this.getStatementCacheMaxSize();
        if (statementCacheMaxSize > 0) {
            this.setStatementCache(new StatementCache(statementCacheMaxSize));
        }
    }

    private void terminateStatementCache() {
        StatementCache statementCache = this.getStatementCache();
        if (statementCache != null) {
            statementCache.clear();
            this.setStatementCache(null);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureIsWorking();
        return this.getConnection(this.getConnectionTimeoutInMs());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.ensureIsWorking();
        if (this.defaultCredentials(username, password)) {
            return this.getConnection();
        }
        logger.warn("Calling getConnection() with different than the default credentials; will create and return a non-pooled Connection.");
        try {
            return this.connectionFactory.create(username, password).value();
        }
        catch (ViburDBCPException e) {
            return ViburUtils.unwrapSQLException(e);
        }
    }

    private boolean defaultCredentials(String username, String password) {
        if (this.getUsername() != null ? !this.getUsername().equals(username) : username != null) {
            return false;
        }
        return !(this.getPassword() == null ? password != null : !this.getPassword().equals(password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(long timeout) throws SQLException {
        boolean logSlowConn = this.getLogConnectionLongerThanMs() >= 0L;
        long startTime = logSlowConn ? System.currentTimeMillis() : 0L;
        Connection connProxy = null;
        try {
            Connection connection = connProxy = this.poolOperations.getConnection(timeout);
            return connection;
        }
        finally {
            if (logSlowConn) {
                this.logGetConnection(timeout, startTime, connProxy);
            }
        }
    }

    private void logGetConnection(long timeout, long startTime, Connection connProxy) {
        long timeTaken = System.currentTimeMillis() - startTime;
        if (timeTaken >= this.getLogConnectionLongerThanMs()) {
            this.getViburLogger().logGetConnection(ViburUtils.getPoolName(this), connProxy, timeout, timeTaken, this.isLogStackTraceForLongConnection() ? new Throwable().getStackTrace() : null);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.setLoginTimeoutInSeconds(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getLoginTimeoutInSeconds();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("not a wrapper for " + iface, "VI005");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    public String getJmxName() {
        return "org.vibur.dbcp:type=ViburDBCP-" + this.getName();
    }
}

