/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.cache.ConnMethod;
import org.vibur.dbcp.cache.StatementHolder;
import org.vibur.dbcp.proxy.TargetInvoker;
import org.vibur.dbcp.util.JdbcUtils;
import org.vibur.objectpool.util.ArgumentValidation;

public class StatementCache {
    private static final Logger logger = LoggerFactory.getLogger(StatementCache.class);
    private final ConcurrentMap<ConnMethod, StatementHolder> statementCache;

    public StatementCache(int maxSize) {
        ArgumentValidation.forbidIllegalArgument((maxSize <= 0 ? 1 : 0) != 0);
        this.statementCache = Objects.requireNonNull(this.buildStatementCache(maxSize));
    }

    protected ConcurrentMap<ConnMethod, StatementHolder> buildStatementCache(int maxSize) {
        return new ConcurrentLinkedHashMap.Builder().initialCapacity(maxSize).maximumWeightedCapacity((long)maxSize).listener(this.getListener()).build();
    }

    private EvictionListener<ConnMethod, StatementHolder> getListener() {
        return new EvictionListener<ConnMethod, StatementHolder>(){

            public void onEviction(ConnMethod key, StatementHolder value) {
                if (value.state().getAndSet(StatementHolder.State.EVICTED) == StatementHolder.State.AVAILABLE) {
                    JdbcUtils.quietClose(value.value());
                }
                logger.trace("Evicted {}", (Object)value.value());
            }
        };
    }

    public StatementHolder retrieve(ConnMethod key, TargetInvoker invoker) throws Throwable {
        StatementHolder statement = (StatementHolder)this.statementCache.get(key);
        if (statement != null && statement.state().compareAndSet(StatementHolder.State.AVAILABLE, StatementHolder.State.IN_USE)) {
            logger.trace("Using cached statement for {}", (Object)key);
            return statement;
        }
        Statement rawStatement = (Statement)invoker.targetInvoke(key.getMethod(), key.getArgs());
        if (statement == null && this.statementCache.putIfAbsent(key, statement = new StatementHolder(rawStatement, new AtomicReference<StatementHolder.State>(StatementHolder.State.IN_USE))) == null) {
            return statement;
        }
        return new StatementHolder(rawStatement, null);
    }

    public void restore(StatementHolder statement, boolean clearWarnings) {
        if (statement.state() == null) {
            return;
        }
        Statement rawStatement = statement.value();
        try {
            if (clearWarnings) {
                JdbcUtils.clearWarnings(rawStatement);
            }
            if (!statement.state().compareAndSet(StatementHolder.State.IN_USE, StatementHolder.State.AVAILABLE)) {
                JdbcUtils.quietClose(rawStatement);
            }
        }
        catch (SQLException e) {
            logger.debug("Couldn't clear warnings on {}", (Object)rawStatement, (Object)e);
            this.remove(rawStatement, false);
            JdbcUtils.quietClose(rawStatement);
        }
    }

    public boolean remove(Statement rawStatement, boolean close) {
        for (Map.Entry entry : this.statementCache.entrySet()) {
            StatementHolder value = (StatementHolder)entry.getValue();
            if (value.value() != rawStatement) continue;
            if (close) {
                JdbcUtils.quietClose(rawStatement);
            }
            return this.statementCache.remove(entry.getKey(), value);
        }
        return false;
    }

    public int removeAll(Connection rawConnection) {
        int removed = 0;
        for (Map.Entry entry : this.statementCache.entrySet()) {
            ConnMethod key = (ConnMethod)entry.getKey();
            StatementHolder value = (StatementHolder)entry.getValue();
            if (key.getTarget() != rawConnection || !this.statementCache.remove(key, value)) continue;
            JdbcUtils.quietClose(value.value());
            ++removed;
        }
        return removed;
    }

    public void clear() {
        for (Map.Entry entry : this.statementCache.entrySet()) {
            StatementHolder value = (StatementHolder)entry.getValue();
            this.statementCache.remove(entry.getKey(), value);
            JdbcUtils.quietClose(value.value());
        }
    }
}

