/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.pool;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburDBCPConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.util.ViburUtils;
import org.vibur.objectpool.util.SamplingPoolReducer;

public class PoolReducer
extends SamplingPoolReducer {
    private static final Logger logger = LoggerFactory.getLogger(PoolReducer.class);
    private final ViburDBCPConfig config;

    public PoolReducer(ViburDBCPConfig config) {
        super(config.getPool(), (long)config.getReducerTimeIntervalInSeconds(), TimeUnit.SECONDS, config.getReducerSamples());
        this.config = config;
    }

    protected void afterReduce(int reduction, int reduced, Throwable thrown) {
        if (thrown != null) {
            logger.warn("While trying to reduce pool {} by {} elements", new Object[]{ViburUtils.getPoolName(this.config), reduction, thrown});
            if (!(thrown instanceof ViburDBCPException)) {
                this.terminate();
            }
        } else {
            logger.debug("Pool {}, intended reduction {} actual {}.", new Object[]{ViburUtils.getPoolName(this.config), reduction, reduced});
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for pool " + this.config.getName();
    }
}

