/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburDBCPConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.proxy.ExceptionCollector;
import org.vibur.dbcp.proxy.TargetInvoker;
import org.vibur.dbcp.util.ViburUtils;

abstract class AbstractInvocationHandler<T>
implements TargetInvoker {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInvocationHandler.class);
    private final T target;
    private final ViburDBCPConfig config;
    private final ExceptionCollector exceptionCollector;
    private final AtomicBoolean logicallyClosed = new AtomicBoolean(false);

    AbstractInvocationHandler(T target, ViburDBCPConfig config, ExceptionCollector exceptionCollector) {
        if (target == null || exceptionCollector == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.config = config;
        this.exceptionCollector = exceptionCollector;
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        if (logger.isTraceEnabled()) {
            logger.trace("Calling {} with args {} on {}", new Object[]{method, args, this.target});
        }
        if ((methodName = method.getName()) == "equals") {
            return proxy == args[0];
        }
        if (methodName == "hashCode") {
            return System.identityHashCode(proxy);
        }
        if (methodName == "toString") {
            return "Proxy for: " + this.target;
        }
        if (methodName == "unwrap") {
            return this.unwrap((Class)args[0]);
        }
        if (methodName == "isWrapperFor") {
            return this.isWrapperFor((Class)args[0]);
        }
        try {
            return this.doInvoke(proxy, method, args);
        }
        catch (ViburDBCPException e) {
            logger.error("Pool {}, the invocation of {} with args {} on {} threw:", new Object[]{ViburUtils.getPoolName(this.config), method, Arrays.toString(args), this.target, e});
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                throw cause;
            }
            throw e;
        }
    }

    Object doInvoke(T proxy, Method method, Object[] args) throws Throwable {
        return this.targetInvoke(method, args);
    }

    @Override
    public final Object targetInvoke(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            this.logInvokeFailure(method, args, cause);
            this.exceptionCollector.addException(cause);
            if (cause instanceof SQLException || cause instanceof RuntimeException || cause instanceof Error) {
                throw cause;
            }
            throw new ViburDBCPException(cause);
        }
    }

    void logInvokeFailure(Method method, Object[] args, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug("Pool {}, the invocation of {} with args {} on {} threw:", new Object[]{ViburUtils.getPoolName(this.config), method, Arrays.toString(args), this.target, t});
        }
    }

    boolean isClosed() {
        return this.logicallyClosed.get();
    }

    boolean getAndSetClosed() {
        return this.logicallyClosed.getAndSet(true);
    }

    void ensureNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(this.target.getClass().getName() + " is closed.", "VI004");
        }
    }

    ExceptionCollector getExceptionCollector() {
        return this.exceptionCollector;
    }

    T getTarget() {
        return this.target;
    }

    private T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return this.target;
        }
        throw new SQLException("not a wrapper for " + iface, "VI005");
    }

    private boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this.target);
    }
}

