/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.vibur.dbcp.ViburDBCPConfig;

class ExceptionCollector {
    private final ViburDBCPConfig config;
    private final Queue<Throwable> exceptions = new ConcurrentLinkedQueue<Throwable>();

    ExceptionCollector(ViburDBCPConfig config) {
        this.config = config;
    }

    void addException(Throwable t) {
        if (this.config.getExceptionListener() != null) {
            this.config.getExceptionListener().on(t);
        }
        if (!(t instanceof SQLTransientException) || t instanceof SQLTransientConnectionException) {
            this.exceptions.add(t);
        }
    }

    List<Throwable> getExceptions() {
        return this.exceptions.isEmpty() ? Collections.emptyList() : new LinkedList<Throwable>(this.exceptions);
    }
}

