/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.vibur.dbcp.ViburDBCPConfig;
import org.vibur.dbcp.proxy.ChildObjectInvocationHandler;
import org.vibur.dbcp.proxy.ExceptionCollector;
import org.vibur.dbcp.util.QueryUtils;
import org.vibur.dbcp.util.ViburUtils;

class ResultSetInvocationHandler
extends ChildObjectInvocationHandler<Statement, ResultSet> {
    private final Object[] executeMethodArgs;
    private final List<Object[]> queryParams;
    private final ViburDBCPConfig config;
    private final AtomicLong resultSetSize = new AtomicLong(0L);

    ResultSetInvocationHandler(ResultSet rawResultSet, Statement statementProxy, Object[] executeMethodArgs, List<Object[]> queryParams, ViburDBCPConfig config, ExceptionCollector exceptionCollector) {
        super(rawResultSet, statementProxy, "getStatement", config, exceptionCollector);
        this.executeMethodArgs = executeMethodArgs;
        this.queryParams = queryParams;
        this.config = config;
    }

    @Override
    Object doInvoke(ResultSet proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName == "close") {
            return this.processClose(method, args);
        }
        this.ensureNotClosed();
        if (methodName == "next") {
            return this.processNext(method, args);
        }
        return super.doInvoke(proxy, method, args);
    }

    private Object processNext(Method method, Object[] args) throws Throwable {
        this.resultSetSize.incrementAndGet();
        return this.targetInvoke(method, args);
    }

    private Object processClose(Method method, Object[] args) throws Throwable {
        this.logResultSetSize();
        return this.targetInvoke(method, args);
    }

    private void logResultSetSize() {
        long size = this.resultSetSize.get() - 1L;
        if (this.config.getLogLargeResultSet() >= 0L && this.config.getLogLargeResultSet() <= size) {
            this.config.getViburLogger().logResultSetSize(ViburUtils.getPoolName(this.config), QueryUtils.getSqlQuery((Statement)this.getParentProxy(), this.executeMethodArgs), this.queryParams, size, this.config.isLogStackTraceForLargeResultSet() ? new Throwable().getStackTrace() : null);
        }
    }
}

