/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.GenericButtonConfiguration;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public class ButtonConfiguration
extends ButtonLayoutConfiguration
implements GenericButtonConfiguration {
    @NotNull
    private final AquaUIPainter.State state;
    private final boolean isFocused;
    @NotNull
    private final AquaUIPainter.ButtonState buttonState;

    public ButtonConfiguration(@NotNull AquaUIPainter.ButtonWidget buttonWidget, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.State state, boolean bl, @NotNull AquaUIPainter.ButtonState buttonState, @NotNull AquaUIPainter.UILayoutDirection uILayoutDirection) {
        super(buttonWidget, size, uILayoutDirection);
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL && buttonState != AquaUIPainter.ButtonState.OFF && state == AquaUIPainter.State.ACTIVE) {
            state = AquaUIPainter.State.PRESSED;
        }
        if (state.isInactive() && !ButtonConfiguration.isSensitiveToInactiveState(buttonWidget, buttonState)) {
            state = state.toActive();
        }
        this.state = state;
        this.isFocused = bl;
        this.buttonState = buttonState;
    }

    public ButtonConfiguration(@NotNull ButtonLayoutConfiguration buttonLayoutConfiguration, @NotNull AquaUIPainter.State state, boolean bl, @NotNull AquaUIPainter.ButtonState buttonState) {
        this(buttonLayoutConfiguration.getButtonWidget(), buttonLayoutConfiguration.getSize(), state, bl, buttonState, buttonLayoutConfiguration.getLayoutDirection());
    }

    @Override
    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    @Override
    public boolean isTextured() {
        AquaUIPainter.ButtonWidget buttonWidget = this.getButtonWidget();
        return buttonWidget.isTextured();
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    @NotNull
    public AquaUIPainter.ButtonState getButtonState() {
        return this.buttonState;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ButtonConfiguration buttonConfiguration = (ButtonConfiguration)object;
        return this.isFocused == buttonConfiguration.isFocused && this.state == buttonConfiguration.state && this.buttonState == buttonConfiguration.buttonState;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.state, this.isFocused, this.buttonState});
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.isFocused ? " focused" : "";
        return super.toString() + " " + (Object)((Object)this.state) + " " + (Object)((Object)this.buttonState) + string;
    }

    private static boolean isSensitiveToInactiveState(@NotNull AquaUIPainter.ButtonWidget buttonWidget, @NotNull AquaUIPainter.ButtonState buttonState) {
        int n = JNRPlatformUtils.getPlatformVersion();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            return buttonState == AquaUIPainter.ButtonState.ON;
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            return buttonState == AquaUIPainter.ButtonState.ON && n >= 101500;
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
            return true;
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_INLINE && n >= 101600) {
            return true;
        }
        if (n >= 101500) {
            return false;
        }
        if (buttonWidget.isTextured()) {
            return true;
        }
        if (buttonState == AquaUIPainter.ButtonState.STATELESS) {
            return false;
        }
        return buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RECESSED && buttonState == AquaUIPainter.ButtonState.ON;
    }
}

