/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public class ButtonLayoutConfiguration
extends LayoutConfiguration {
    @NotNull
    private final AquaUIPainter.ButtonWidget bw;
    @NotNull
    private final AquaUIPainter.Size size;
    @NotNull
    private final AquaUIPainter.UILayoutDirection ld;

    public ButtonLayoutConfiguration(@NotNull AquaUIPainter.ButtonWidget buttonWidget, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.UILayoutDirection uILayoutDirection) {
        int n;
        if (size == AquaUIPainter.Size.LARGE && (n = JNRPlatformUtils.getPlatformVersion()) < 101600) {
            size = AquaUIPainter.Size.REGULAR;
        }
        this.bw = buttonWidget;
        this.size = size;
        this.ld = uILayoutDirection;
    }

    @Override
    @NotNull
    public Object getWidget() {
        return this.bw;
    }

    @NotNull
    public AquaUIPainter.ButtonWidget getButtonWidget() {
        return this.bw;
    }

    @NotNull
    public AquaUIPainter.Size getSize() {
        return this.size;
    }

    @NotNull
    public AquaUIPainter.UILayoutDirection getLayoutDirection() {
        return this.ld;
    }

    public boolean isLeftToRight() {
        return this.ld == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ButtonLayoutConfiguration buttonLayoutConfiguration = (ButtonLayoutConfiguration)object;
        return this.bw == buttonLayoutConfiguration.bw && this.size == buttonLayoutConfiguration.size && this.ld == buttonLayoutConfiguration.ld;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bw, this.size, this.ld});
    }

    @NotNull
    public String toString() {
        String string = this.ld == AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT ? " RTL" : "";
        return this.bw + " " + (Object)((Object)this.size) + string;
    }
}

