/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TitleBarLayoutConfiguration;
import org.violetlib.jnr.impl.CombinedInsetter;
import org.violetlib.jnr.impl.FloatingInsetter1;
import org.violetlib.jnr.impl.Insetters;

public class TitleBarLayoutInfo {
    private static final int BUTTON_AREA_RIGHT_PAD = 11;
    private static final int DOCUMENT_HEIGHT = 22;
    private static final int UTILITY_HEIGHT = 16;
    private static final int DOCUMENT_DIAMETER = 12;
    private static final int UTILITY_DIAMETER = 11;
    @NotNull
    private final WindowInfo[] windowInfo = new WindowInfo[2];

    public TitleBarLayoutInfo(@NotNull Rectangle[] rectangleArray, @NotNull Rectangle[] rectangleArray2) {
        this.windowInfo[0] = new WindowInfo(22.0f, rectangleArray, 12.0f);
        this.windowInfo[1] = new WindowInfo(16.0f, rectangleArray2, 11.0f);
    }

    @NotNull
    public Insetter getButtonInsets(@NotNull TitleBarLayoutConfiguration titleBarLayoutConfiguration, @NotNull AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget) {
        ButtonInfo buttonInfo = this.getButtonInfo(titleBarLayoutConfiguration.getWidget(), titleBarButtonWidget);
        return buttonInfo.insets;
    }

    @NotNull
    public Shape getButtonShape(@NotNull Rectangle2D rectangle2D, @NotNull TitleBarLayoutConfiguration titleBarLayoutConfiguration, @NotNull AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget) {
        ButtonInfo buttonInfo = this.getButtonInfo(titleBarLayoutConfiguration.getWidget(), titleBarButtonWidget);
        return buttonInfo.shape;
    }

    @NotNull
    public Insetter getLabelInsets(@NotNull TitleBarLayoutConfiguration titleBarLayoutConfiguration) {
        WindowInfo windowInfo = this.getWindowInfo(titleBarLayoutConfiguration.getWidget());
        return windowInfo.labelInsets;
    }

    @Nullable
    public AquaUIPainter.TitleBarButtonWidget identifyButton(@NotNull Rectangle2D rectangle2D, @NotNull TitleBarLayoutConfiguration titleBarLayoutConfiguration, int n, int n2) {
        WindowInfo windowInfo = this.getWindowInfo(titleBarLayoutConfiguration.getWidget());
        for (int i = 0; i < windowInfo.buttonInfo.length; ++i) {
            ButtonInfo buttonInfo = windowInfo.buttonInfo[i];
            Rectangle rectangle = buttonInfo.bounds;
            if (!rectangle.contains(n, n2)) continue;
            return TitleBarLayoutInfo.fromButtonIndex(i);
        }
        return null;
    }

    @NotNull
    protected WindowInfo getWindowInfo(@NotNull AquaUIPainter.TitleBarWidget titleBarWidget) {
        int n = TitleBarLayoutInfo.toWindowTypeIndex(titleBarWidget);
        return this.windowInfo[n];
    }

    @NotNull
    protected ButtonInfo getButtonInfo(@NotNull AquaUIPainter.TitleBarWidget titleBarWidget, @NotNull AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget) {
        WindowInfo windowInfo = this.getWindowInfo(titleBarWidget);
        int n = TitleBarLayoutInfo.toButtonIndex(titleBarButtonWidget);
        return windowInfo.buttonInfo[n];
    }

    public static int toWindowTypeIndex(@NotNull AquaUIPainter.TitleBarWidget titleBarWidget) {
        switch (titleBarWidget) {
            case DOCUMENT_WINDOW: {
                return 0;
            }
            case UTILITY_WINDOW: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int toButtonIndex(@NotNull AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget) {
        switch (titleBarButtonWidget) {
            case CLOSE_BOX: {
                return 0;
            }
            case MINIMIZE_BOX: {
                return 1;
            }
            case RESIZE_BOX: {
                return 2;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static AquaUIPainter.TitleBarButtonWidget fromButtonIndex(int n) {
        switch (n) {
            case 0: {
                return AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX;
            }
            case 1: {
                return AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX;
            }
            case 2: {
                return AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static Shape createButtonShape(@NotNull Rectangle rectangle, float f) {
        float f2 = f / 2.0f;
        float f3 = (float)((double)rectangle.x + (double)rectangle.width / 2.0 - (double)f2);
        float f4 = (float)((double)rectangle.y + (double)rectangle.height / 2.0 - (double)f2);
        return new Ellipse2D.Float(f3, f4, f, f);
    }

    private static class WindowInfo {
        final float height;
        final float buttonAreaWidth;
        @NotNull
        final ButtonInfo[] buttonInfo;
        @NotNull
        final Insetter labelInsets;

        public WindowInfo(float f, @NotNull Rectangle[] rectangleArray, float f2) {
            int n = rectangleArray.length;
            Rectangle rectangle = rectangleArray[n - 1];
            this.height = f;
            this.buttonAreaWidth = rectangle.x + rectangle.width + 11;
            this.buttonInfo = new ButtonInfo[n];
            for (int i = 0; i < n; ++i) {
                this.buttonInfo[i] = new ButtonInfo(rectangleArray[i], f2);
            }
            this.labelInsets = Insetters.createFixed(1.0f, this.buttonAreaWidth, 1.0f, 1.0f);
        }
    }

    private static class ButtonInfo {
        @NotNull
        final Rectangle bounds;
        @NotNull
        final Shape shape;
        @NotNull
        final Insetter insets;

        public ButtonInfo(@NotNull Rectangle rectangle, float f) {
            this.bounds = rectangle;
            this.shape = TitleBarLayoutInfo.createButtonShape(rectangle, f);
            FloatingInsetter1 floatingInsetter1 = FloatingInsetter1.createLeftTopAligned(rectangle.width, rectangle.x);
            FloatingInsetter1 floatingInsetter12 = FloatingInsetter1.createLeftTopAligned(rectangle.height, rectangle.y);
            this.insets = new CombinedInsetter(floatingInsetter1, floatingInsetter12);
        }
    }
}

