/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;

public abstract class TitleBarRendererBase
extends Renderer {
    @NotNull
    protected final TitleBarConfiguration g;
    @NotNull
    protected final RendererDescription rd;
    @Nullable
    protected final Insetter closeButtonInsets;
    @Nullable
    protected final Insetter minimizeButtonInsets;
    @Nullable
    protected final Insetter resizeButtonInsets;

    protected TitleBarRendererBase(@NotNull TitleBarConfiguration titleBarConfiguration, @NotNull RendererDescription rendererDescription, @Nullable Insetter insetter, @Nullable Insetter insetter2, @Nullable Insetter insetter3) {
        this.g = titleBarConfiguration;
        this.rd = rendererDescription;
        this.closeButtonInsets = insetter;
        this.minimizeButtonInsets = insetter2;
        this.resizeButtonInsets = insetter3;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
        Renderer renderer;
        float f = reusableCompositor.getWidth();
        float f2 = reusableCompositor.getHeight();
        Object object = this.getBasicTitleBarRenderer(f, f2);
        Renderer renderer2 = Renderer.create((BasicRenderer)object, this.rd);
        renderer2.composeTo(reusableCompositor);
        if (this.closeButtonInsets != null) {
            object = this.closeButtonInsets.apply2D(f, f2);
            renderer2 = this.getButtonRenderer(AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX);
            renderer = Renderer.createOffsetRenderer(renderer2, (Rectangle2D)object);
            renderer.composeTo(reusableCompositor);
        }
        if (this.minimizeButtonInsets != null) {
            object = this.minimizeButtonInsets.apply2D(f, f2);
            renderer2 = this.getButtonRenderer(AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX);
            renderer = Renderer.createOffsetRenderer(renderer2, (Rectangle2D)object);
            renderer.composeTo(reusableCompositor);
        }
        if (this.resizeButtonInsets != null) {
            object = this.resizeButtonInsets.apply2D(f, f2);
            renderer2 = this.getButtonRenderer(AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX);
            renderer = Renderer.createOffsetRenderer(renderer2, (Rectangle2D)object);
            renderer.composeTo(reusableCompositor);
        }
    }

    @NotNull
    protected abstract BasicRenderer getBasicTitleBarRenderer(float var1, float var2);

    @NotNull
    protected abstract Renderer getButtonRenderer(@NotNull AquaUIPainter.TitleBarButtonWidget var1);
}

