/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.coreui.CoreUIRendererDescriptions;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.RendererDescription;

public class JRSRendererDescriptions
extends CoreUIRendererDescriptions {
    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        int n = JNRPlatformUtils.getPlatformVersion();
        boolean bl = n >= 101100;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
        if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED || segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR || segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS) {
            segmentedButtonConfiguration = segmentedButtonConfiguration.withWidget(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED);
        } else if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
            segmentedButtonConfiguration = segmentedButtonConfiguration.withWidget(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED);
        }
        RendererDescription rendererDescription = super.getSegmentedButtonRendererDescription(segmentedButtonConfiguration);
        try {
            switch (segmentedButtonWidget) {
                case BUTTON_SEGMENTED_SEPARATED: {
                    float f;
                    float f2;
                    if (size == AquaUIPainter.Size.REGULAR || size == AquaUIPainter.Size.SMALL) {
                        switch (position) {
                            case FIRST: {
                                f2 = 5.0f;
                                f = -2.0f;
                                break;
                            }
                            case MIDDLE: {
                                f2 = 5.49f;
                                f = -2.49f;
                                break;
                            }
                            case LAST: {
                                f2 = 4.49f;
                                f = -2.49f;
                                break;
                            }
                            default: {
                                f2 = 4.0f;
                                f = -2.0f;
                                break;
                            }
                        }
                    } else {
                        switch (position) {
                            case FIRST: {
                                f2 = 3.0f;
                                f = -1.0f;
                                break;
                            }
                            case MIDDLE: {
                                f2 = 3.49f;
                                f = -1.49f;
                                break;
                            }
                            case LAST: {
                                f2 = 2.49f;
                                f = -1.49f;
                                break;
                            }
                            default: {
                                f2 = 2.0f;
                                f = -1.0f;
                            }
                        }
                    }
                    return JNRUtils.changeRendererDescription(rendererDescription, f, -123456.0f, f2, -123456.0f);
                }
                case BUTTON_SEGMENTED_INSET: {
                    float f = JNRUtils.size2D(size, -2.0f, -2.51f, -3.0f);
                    return JNRUtils.changeRendererDescription(rendererDescription, -123456.0f, f, -123456.0f, -123456.0f);
                }
                case BUTTON_SEGMENTED_SCURVE: 
                case BUTTON_SEGMENTED_TEXTURED: {
                    float f = bl ? JNRUtils.size2D(size, -1.49f, -2.0f, -2.0f) : JNRUtils.size2D(size, -1.0f, -2.0f, -2.0f);
                    return this.fix(rendererDescription, segmentedButtonConfiguration, f);
                }
                case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
                case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                    float f = bl ? JNRUtils.size2D(size, -2.49f, -3.0f, -3.0f) : JNRUtils.size2D(size, -1.0f, -2.0f, -2.0f);
                    return this.fix(rendererDescription, segmentedButtonConfiguration, f);
                }
                case BUTTON_SEGMENTED_TOOLBAR: {
                    float f = bl ? JNRUtils.size2D(size, 0.0f, 0.0f, 0.0f) : JNRUtils.size2D(size, -1.0f, -2.0f, -2.0f);
                    return this.fix(rendererDescription, segmentedButtonConfiguration, f);
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            NativeSupport.log("Unable to adjust segmented button renderer description for " + segmentedButtonConfiguration);
        }
        return rendererDescription;
    }

    @NotNull
    private RendererDescription fix(@NotNull RendererDescription rendererDescription, @NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, float f) {
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
        if (size == AquaUIPainter.Size.MINI) {
            rendererDescription = new BasicRendererDescription(0.0f, 0.0f, position == AquaUIPainter.Position.MIDDLE ? 1.0f : 0.0f, 4.0f);
        }
        return JNRUtils.changeRendererDescription(rendererDescription, -123456.0f, f, -123456.0f, -123456.0f);
    }
}

