/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.RasterDescription;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;

class BasicRendererRenderer
extends Renderer {
    @NotNull
    private final BasicRenderer r;
    @NotNull
    private final RendererDescription rd;

    public BasicRendererRenderer(@NotNull BasicRenderer basicRenderer, @NotNull RendererDescription rendererDescription) {
        this.r = basicRenderer;
        this.rd = rendererDescription;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
        if (this.rd.isTrivial()) {
            reusableCompositor.composeRenderer(this.r);
        } else {
            int n = reusableCompositor.getScaleFactor();
            float f = reusableCompositor.getWidth();
            float f2 = reusableCompositor.getHeight();
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
            RasterDescription rasterDescription = this.rd.getRasterBounds(float_, n);
            int n2 = Math.round((float)n * rasterDescription.getX());
            int n3 = Math.round((float)n * rasterDescription.getY());
            int n4 = (int)Math.ceil((float)n * rasterDescription.getWidth());
            int n5 = (int)Math.ceil((float)n * rasterDescription.getHeight());
            reusableCompositor.composeRenderer(this.r, n2, n3, n4, n5);
        }
    }

    @Override
    @NotNull
    public BasicRenderer getBasicRenderer() {
        return this.r;
    }

    @Override
    @NotNull
    public RendererDescription getRendererDescription() {
        return this.rd;
    }
}

