/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import org.jetbrains.annotations.NotNull;

public class ImageUtils {
    @NotNull
    public static Image invertForDarkMode(@NotNull Image image) {
        return ImageUtils.createFilteredImage(image, new InvertImageForDarkModeFilter());
    }

    private static Image createFilteredImage(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return ImageUtils.waitForImage(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
    }

    public static int toGray(int n) {
        int n2 = (int)((0.3 * (double)ImageUtils.red(n) + 0.59 * (double)ImageUtils.green(n) + 0.11 * (double)ImageUtils.blue(n)) / 3.0);
        if ((n2 = (int)((double)(255 - n2) * 0.7)) < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        return ImageUtils.createPixel(ImageUtils.alpha(n), n2, n2, n2);
    }

    public static int createPixel(int n, int n2, int n3, int n4) {
        return ((n & 0xFF) << 24) + ((n2 & 0xFF) << 16) + ((n3 & 0xFF) << 8) + (n4 & 0xFF);
    }

    public static int alpha(int n) {
        return n >> 24 & 0xFF;
    }

    public static int red(int n) {
        return n >> 16 & 0xFF;
    }

    public static int green(int n) {
        return n >> 8 & 0xFF;
    }

    public static int blue(int n) {
        return n >> 0 & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Image waitForImage(@NotNull Image image2) {
        boolean[] blArray = new boolean[]{false};
        ImageObserver imageObserver = (image, n, n2, n3, n4, n5) -> {
            if (n4 != -1 && n5 != -1 && (n & 0x20) != 0 || (n & 0x80) != 0) {
                boolean[] blArray2 = blArray;
                synchronized (blArray) {
                    blArray[0] = true;
                    blArray.notify();
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return false;
                }
            }
            return true;
        };
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            while (!blArray[0] && image2.getWidth(imageObserver) == -1) {
                try {
                    blArray.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return image2;
        }
    }

    private static class InvertImageForDarkModeFilter
    extends RGBImageFilter {
        public InvertImageForDarkModeFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            return ImageUtils.toGray(n3);
        }
    }
}

