/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JNRPlatformUtils {
    @Nullable
    private static String platformVersionString;
    private static int platformVersion;

    public static synchronized int getPlatformVersion() {
        if (platformVersionString == null) {
            boolean bl;
            String string = System.getProperty("os.name");
            String string2 = System.getProperty("os.version");
            boolean bl2 = bl = string.equals("Mac OS X") || string.equals("macOS");
            if (bl) {
                platformVersionString = string2;
                platformVersion = JNRPlatformUtils.obtainSystemVersion(string2);
                return platformVersion;
            }
        }
        return platformVersion;
    }

    private static int obtainSystemVersion(@NotNull String string) {
        int n;
        int n2 = JNRPlatformUtils.parseSystemVersion(string);
        if (n2 / 100 == 1016 && (n = JNRPlatformUtils.readSystemVersion()) > 0) {
            return n;
        }
        return n2;
    }

    private static int readSystemVersion() {
        String[] stringArray = new String[]{"/usr/bin/sw_vers", "-productVersion"};
        String[] stringArray2 = new String[]{"SYSTEM_VERSION_COMPAT=0"};
        String string = JNRPlatformUtils.command("sw_vers", stringArray, stringArray2);
        if (string != null) {
            return JNRPlatformUtils.parseSystemVersion(string);
        }
        return 0;
    }

    @Nullable
    private static String command(@NotNull String string, String @NotNull [] stringArray, String @Nullable [] stringArray2) {
        try {
            int n;
            Process process = Runtime.getRuntime().exec(stringArray, stringArray2);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStreamReader.read()) != -1 && n != 10) {
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            System.err.println("Unable to run " + string + ": " + throwable);
            return null;
        }
    }

    private static int parseSystemVersion(@NotNull String string) {
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens() && ++n2 <= 3) {
            String string2 = stringTokenizer.nextToken();
            try {
                int n3 = Integer.parseInt(string2);
                if (n3 >= 0 && n3 < 100) {
                    n = n * 100 + n3;
                    continue;
                }
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return n2 == 2 ? n * 100 : n;
    }

    @Nullable
    public static Graphics2D toGraphics2D(@NotNull Graphics graphics) {
        try {
            return (Graphics2D)graphics;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    static {
        platformVersion = 0;
    }
}

