/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Container;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AquaCellEditorPolicy {
    public static final String IS_COMBO_BOX_CELL_EDITOR_PROPERTY = "JComboBox.isTableCellEditor";
    public static final String IS_CELL_EDITOR_PROPERTY = "JComponent.isCellEditor";
    public static final String IS_CELL_CONTAINER_PROPERTY = "JComponent.isCellContainer";
    private static AquaCellEditorPolicy INSTANCE = new AquaCellEditorPolicy();

    public static AquaCellEditorPolicy getInstance() {
        return INSTANCE;
    }

    public static boolean isCellEditorProperty(String string) {
        return IS_COMBO_BOX_CELL_EDITOR_PROPERTY.equals(string) || IS_CELL_EDITOR_PROPERTY.equals(string);
    }

    @Nullable
    public CellStatus getCellStatus(@NotNull JComponent jComponent) {
        Object object = jComponent.getClientProperty(IS_CELL_EDITOR_PROPERTY);
        if (Boolean.FALSE.equals(object)) {
            return null;
        }
        return this.getCellStatusFromParent(jComponent.getParent());
    }

    @Nullable
    private CellStatus getCellStatusFromParent(@Nullable Container container) {
        if (container == null) {
            return null;
        }
        if (container instanceof CellRendererPane) {
            return CellStatus.CELL_RENDERER;
        }
        if (container instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)container;
            CellStatus cellStatus = this.getCellStatus(jComboBox);
            if (cellStatus != null) {
                return cellStatus;
            }
            return jComboBox.isEditable() ? CellStatus.CELL_EDITOR : CellStatus.CELL_RENDERER;
        }
        if (container instanceof JComponent) {
            JComponent jComponent = (JComponent)container;
            Object object = jComponent.getClientProperty(IS_CELL_CONTAINER_PROPERTY);
            if (Boolean.TRUE.equals(object)) {
                return CellStatus.CELL_EDITOR;
            }
            if (Boolean.FALSE.equals(object)) {
                return null;
            }
        }
        if (container instanceof CellEditorListener) {
            return CellStatus.CELL_EDITOR;
        }
        return this.getCellStatusFromParent(container.getParent());
    }

    public static enum CellStatus {
        CELL_RENDERER,
        CELL_EDITOR;

    }
}

