/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaNamedButtonBorder;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.geom.ExpandableOutline;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.GenericButtonConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public abstract class AquaLabeledButtonBorder
extends AquaNamedButtonBorder {
    public AquaLabeledButtonBorder(@NotNull AquaUIPainter.ButtonWidget buttonWidget, @NotNull AquaButtonExtendedTypes.WidgetInfo widgetInfo) {
        super(buttonWidget, widgetInfo);
    }

    @Override
    public void paintButton(@NotNull Graphics2D graphics2D, @NotNull AbstractButton abstractButton, @Nullable Icon icon, @NotNull Rectangle rectangle) {
        GenericButtonConfiguration genericButtonConfiguration = this.getConfiguration(abstractButton, rectangle.width, rectangle.height);
        if (genericButtonConfiguration instanceof ButtonConfiguration) {
            ButtonConfiguration buttonConfiguration = (ButtonConfiguration)genericButtonConfiguration;
            Insets insets = new Insets(0, 0, 0, 0);
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            Dimension dimension = this.getIconSize(buttonConfiguration);
            String string = AquaButtonUI.layoutAndGetText(graphics2D, abstractButton, insets, rectangle, rectangle2, rectangle3, dimension);
            this.paintBackground(graphics2D, abstractButton, buttonConfiguration, rectangle2);
            Color color = this.getForegroundColor(abstractButton, buttonConfiguration, false);
            AquaButtonUI.paintText(graphics2D, abstractButton, rectangle3, color, string);
        }
    }

    @Nullable
    private ButtonLayoutConfiguration getButtonLayoutConfiguration(@NotNull AbstractButton abstractButton) {
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof ButtonLayoutConfiguration) {
            return (ButtonLayoutConfiguration)layoutConfiguration;
        }
        return null;
    }

    @Override
    @Nullable
    public Shape getFocusRingOutline(@NotNull JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonLayoutConfiguration buttonLayoutConfiguration = this.getButtonLayoutConfiguration(abstractButton);
        if (buttonLayoutConfiguration != null) {
            Insets insets = new Insets(0, 0, 0, 0);
            Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            Dimension dimension = this.getIconSize(buttonLayoutConfiguration);
            AquaButtonUI.layoutAndGetText(null, abstractButton, insets, rectangle, rectangle2, rectangle3, dimension);
            AppearanceManager.ensureAppearance(abstractButton);
            AquaUtils.configure(this.painter, abstractButton, rectangle2.width, rectangle2.height);
            Shape shape = this.painter.getOutline(buttonLayoutConfiguration);
            if (shape != null) {
                return ExpandableOutline.createTranslatedShape(shape, rectangle2.x, rectangle2.y);
            }
        }
        return null;
    }

    @Override
    @Nullable
    protected Dimension getIconSize(@NotNull LayoutConfiguration layoutConfiguration) {
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(layoutConfiguration);
        int n = (int)Math.ceil(layoutInfo.getFixedVisualWidth());
        int n2 = (int)Math.ceil(layoutInfo.getFixedVisualHeight());
        return new Dimension(n, n2);
    }

    @Override
    @NotNull
    protected AquaUIPainter.ButtonState getButtonState(@NotNull AbstractButton abstractButton) {
        return AquaLabeledButtonBorder.isIndeterminate(abstractButton) ? AquaUIPainter.ButtonState.MIXED : (abstractButton.getModel().isSelected() ? AquaUIPainter.ButtonState.ON : AquaUIPainter.ButtonState.OFF);
    }

    @Override
    @Nullable
    protected Insets getSpecialMarginAdjustments(@NotNull AbstractButton abstractButton) {
        return null;
    }

    static boolean isIndeterminate(@NotNull AbstractButton abstractButton) {
        return "indeterminate".equals(abstractButton.getClientProperty("JButton.selectedState"));
    }
}

