/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaBasicPopupMenuWrapper;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaContextualPopup;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaPopupMenuUI
extends BasicPopupMenuUI
implements AquaComponentUI {
    public static final String POP_UP_SCREEN_BOUNDS = "Aqua.PopupMenu.ScreenBounds";
    public static final String POP_UP_SELECTED_REGION = "Aqua.PopupMenu.SelectedRegion";
    public static final String POP_UP_SELECTED_REGION_LOCATION = "Aqua.PopupMenu.SelectedRegionLocation";
    public static final String POP_UP_TRACKER = "Aqua.PopupMenu.Tracker";
    public static final int ORDINARY_CONTEXTUAL_MENU_STYLE = 0;
    public static final int SIMPLE_CONTEXTUAL_MENU_STYLE = 1;
    public static final int FANCY_CONTEXTUAL_MENU_STYLE = 2;
    private static Object HIDE_POPUP_KEY;
    private AquaContextualPopup cp;
    private ScrollingMouseListener scrollingMouseListener = new ScrollingMouseListener();
    @Nullable
    protected AppearanceContext appearanceContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaPopupMenuUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.popupMenu, "opaque", false);
        this.configureAppearanceContext(null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.popupMenu.addMouseListener(this.scrollingMouseListener);
        this.popupMenu.addMouseMotionListener(this.scrollingMouseListener);
        this.popupMenu.addMouseWheelListener(this.scrollingMouseListener);
        AppearanceManager.installListeners(this.popupMenu);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListeners(this.popupMenu);
        this.popupMenu.removeMouseListener(this.scrollingMouseListener);
        this.popupMenu.removeMouseMotionListener(this.scrollingMouseListener);
        this.popupMenu.removeMouseWheelListener(this.scrollingMouseListener);
        super.uninstallListeners();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.popupMenu);
        }
        AquaUIPainter.State state = AquaUIPainter.State.ACTIVE;
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        BasicContextualColors basicContextualColors = this.getMenuColors(this.popupMenu.getInvoker());
        AquaColors.installColors(this.popupMenu, this.appearanceContext, basicContextualColors);
        this.popupMenu.repaint();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
    }

    @Override
    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.isPopupTrigger();
    }

    @Override
    public Popup getPopup(JPopupMenu jPopupMenu, int n, int n2) {
        int n3;
        Serializable serializable;
        int n4 = 0;
        int n5 = 0;
        Object object = jPopupMenu.getClientProperty(POP_UP_SCREEN_BOUNDS);
        if (object instanceof Rectangle) {
            serializable = (Rectangle)object;
            n = serializable.x;
            n2 = serializable.y;
            n4 = serializable.width;
            n5 = serializable.height;
        }
        if ((n3 = this.getContextualMenuStyle((Component)(serializable = jPopupMenu.getInvoker()))) == 2) {
            Rectangle rectangle = null;
            Point point = null;
            Object object2 = jPopupMenu.getClientProperty(POP_UP_SELECTED_REGION);
            if (object2 instanceof Rectangle) {
                rectangle = (Rectangle)object2;
                Object object3 = jPopupMenu.getClientProperty(POP_UP_SELECTED_REGION_LOCATION);
                if (object3 instanceof Point) {
                    point = (Point)object3;
                }
            }
            boolean bl = AquaLookAndFeel.USE_VIBRANT_MENU && this.isVibrantSelectionSupportNeeded((Component)serializable);
            this.cp = new AquaContextualPopup(jPopupMenu, (Component)serializable, bl, rectangle, point, n, n2, n4, n5);
            return this.cp.getPopup();
        }
        if (n3 == 1) {
            Border border = AquaContextualPopup.getContextualMenuBorder();
            AquaBasicPopupMenuWrapper aquaBasicPopupMenuWrapper = new AquaBasicPopupMenuWrapper(jPopupMenu, border);
            aquaBasicPopupMenuWrapper.putClientProperty("AquaPopup.backgroundStyle", "vibrantMenu");
            aquaBasicPopupMenuWrapper.putClientProperty("AquaPopup.cornerRadius", 6);
            jPopupMenu.setBorder(null);
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            return popupFactory.getPopup((Component)serializable, aquaBasicPopupMenuWrapper, n, n2 += 2);
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        return popupFactory.getPopup((Component)serializable, jPopupMenu, n, n2);
    }

    @NotNull
    protected BasicContextualColors getMenuColors(Component component) {
        return AquaColors.getMenuColors();
    }

    protected boolean isVibrantSelectionSupportNeeded(Component component) {
        return component instanceof JComponent;
    }

    protected int getContextualMenuStyle(Component component) {
        return 2;
    }

    public static Object getHidePopupKey() {
        if (HIDE_POPUP_KEY == null) {
            JComboBox jComboBox = new JComboBox();
            HIDE_POPUP_KEY = jComboBox.getClientProperty("doNotCancelPopup");
        }
        return HIDE_POPUP_KEY;
    }

    private class ScrollingMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private ScrollingMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (AquaPopupMenuUI.this.cp != null) {
                AquaPopupMenuUI.this.cp.dispatchEvent(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (AquaPopupMenuUI.this.cp != null) {
                AquaPopupMenuUI.this.cp.dispatchEvent(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (AquaPopupMenuUI.this.cp != null) {
                AquaPopupMenuUI.this.cp.dispatchEvent(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (AquaPopupMenuUI.this.cp != null) {
                AquaPopupMenuUI.this.cp.dispatchEvent(mouseEvent);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (AquaPopupMenuUI.this.cp != null) {
                AquaPopupMenuUI.this.cp.dispatchEvent(mouseWheelEvent);
            }
        }
    }
}

