/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaOverlayScrollPaneController;
import org.violetlib.aqua.AquaOverlayScrollPaneLayout;
import org.violetlib.aqua.AquaScrollBar;
import org.violetlib.aqua.AquaTextComponentBorder;
import org.violetlib.aqua.AquaTreeUI;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.OverlayScrollPaneHack;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaScrollPaneUI
extends BasicScrollPaneUI
implements AquaUtilControlSize.Sizeable,
AquaComponentUI {
    public static final String SCROLL_PANE_STYLE_KEY = "JScrollPane.style";
    public static final String SCROLL_PANE_THUMB_STYLE_KEY = "JScrollPane.thumbStyle";
    public static final String SCROLL_PANE_SMOOTH_SCROLLING = "JScrollPane.useSmoothScrolling";
    public static final String SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY = "AquaOverlayScrollBars";
    public static final String THUMB_STYLE_DARK = "dark";
    public static final String THUMB_STYLE_LIGHT = "light";
    public static final int WHEEL_CHANGE_DIRECTION_MINIMUM = 3;
    public static final boolean isRTLSupported = OSXSystemProperties.doScrollPanesSupportRTL();
    private static final boolean useViewportHack = true;
    protected JScrollBar originalHorizontalScrollBar;
    protected JScrollBar originalVerticalScrollBar;
    protected AquaUIPainter.Size size;
    protected boolean isOverlayScrollBars;
    protected boolean isSmoothScrolling;
    protected AquaOverlayScrollPaneController overlayController;
    protected int contraryScrollCount;
    protected OverlayScrollPaneHack overlayScrollPaneHack;
    protected LayoutManager legacyLayoutManager;
    protected int defaultSmoothScrollingUnitIncrement = 16;
    @Nullable
    protected AppearanceContext appearanceContext;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener preferenceChangeListener;
    protected ComponentListener componentListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaScrollPaneUI();
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        return new XYMouseWheelHandler();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.legacyLayoutManager = this.scrollpane.getLayout();
        if (this.legacyLayoutManager == null) {
            this.legacyLayoutManager = new ScrollPaneLayout.UIResource();
        }
        this.setScrollBarStyle(this.shouldUseOverlayScrollBars());
        this.scrollpane.putClientProperty(SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY, this.isOverlayScrollBars);
        this.configureAppearanceContext(null);
        this.isSmoothScrolling = this.computeSmoothScrolling();
    }

    @Override
    protected void uninstallDefaults(JScrollPane jScrollPane) {
        if (jScrollPane.getHorizontalScrollBar() instanceof AquaScrollBar && this.originalHorizontalScrollBar != null) {
            jScrollPane.setHorizontalScrollBar(this.originalHorizontalScrollBar);
        }
        if (jScrollPane.getVerticalScrollBar() instanceof AquaScrollBar && this.originalVerticalScrollBar != null) {
            jScrollPane.setVerticalScrollBar(this.originalVerticalScrollBar);
        }
        super.uninstallDefaults(jScrollPane);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.setScrollBarStyle(false);
        JScrollPane jScrollPane = this.scrollpane;
        super.uninstallUI(jComponent);
        jScrollPane.putClientProperty(SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY, null);
    }

    @Override
    protected void installDefaults(JScrollPane jScrollPane) {
        Border border = jScrollPane.getBorder();
        super.installDefaults(jScrollPane);
        if (border instanceof AquaTextComponentBorder) {
            jScrollPane.setBorder(border);
        }
        this.originalHorizontalScrollBar = jScrollPane.getHorizontalScrollBar();
        this.originalVerticalScrollBar = jScrollPane.getVerticalScrollBar();
        if (this.originalVerticalScrollBar instanceof UIResource) {
            jScrollPane.setHorizontalScrollBar(new AquaScrollBar(0, this.defaultSmoothScrollingUnitIncrement));
        }
        if (this.originalVerticalScrollBar instanceof UIResource) {
            jScrollPane.setVerticalScrollBar(new AquaScrollBar(1, this.defaultSmoothScrollingUnitIncrement));
        }
    }

    @Override
    protected void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        this.componentListener = new MyComponentListener();
        jScrollPane.addComponentListener(this.componentListener);
        this.propertyChangeListener = new MyPropertyChangeListener();
        jScrollPane.addPropertyChangeListener(this.propertyChangeListener);
        this.preferenceChangeListener = new PreferenceChangeListener();
        OSXSystemProperties.addChangeListener(this.preferenceChangeListener);
        AquaUtilControlSize.addSizePropertyListener(jScrollPane);
        AppearanceManager.installListeners(jScrollPane);
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        if (this.overlayController != null) {
            this.overlayController.dispose();
            this.overlayController = null;
        }
        if (this.overlayScrollPaneHack != null) {
            this.overlayScrollPaneHack.dispose();
            this.overlayScrollPaneHack = null;
        }
        AppearanceManager.uninstallListeners(jComponent);
        AquaUtilControlSize.removeSizePropertyListener(jComponent);
        OSXSystemProperties.removeChangeListener(this.preferenceChangeListener);
        this.preferenceChangeListener = null;
        jComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        jComponent.removeComponentListener(this.componentListener);
        this.componentListener = null;
        super.uninstallListeners(jComponent);
    }

    @Override
    public void applySizeFor(JComponent jComponent, AquaUIPainter.Size size, boolean bl) {
        this.size = size;
        if (jComponent instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)jComponent;
            this.updateScrollBar(jScrollPane.getHorizontalScrollBar());
            this.updateScrollBar(jScrollPane.getVerticalScrollBar());
        }
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.scrollpane);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        this.updateThumbStyle();
        this.scrollpane.repaint();
    }

    @NotNull
    protected AquaUIPainter.State getState() {
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        if (jComponent.isOpaque()) {
            Color color = AquaColors.getBackground(jComponent, "controlBackground");
            AquaUtils.fillRect(graphics, jComponent, color, 2);
        }
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        boolean bl;
        if (this.syncLayoutManager()) {
            this.scrollpane.validate();
        }
        if ((bl = this.isSideBar()) && !this.isOverlayScrollBars) {
            this.setSidebarStyle(this.scrollpane.getHorizontalScrollBar(), true);
            this.setSidebarStyle(this.scrollpane.getVerticalScrollBar(), true);
        } else {
            this.setSidebarStyle(this.scrollpane.getHorizontalScrollBar(), false);
            this.setSidebarStyle(this.scrollpane.getVerticalScrollBar(), false);
        }
        Border border = jComponent.getBorder();
        if (border instanceof AquaTextComponentBorder) {
            object = (AquaTextComponentBorder)border;
            ((AquaTextComponentBorder)object).paintBackground(jComponent, graphics, null);
        }
        super.paint(graphics, jComponent);
        if (!this.isOverlayScrollBars && !bl) {
            object = this.scrollpane.getVerticalScrollBar();
            JScrollBar jScrollBar = this.scrollpane.getHorizontalScrollBar();
            if (object != null && jScrollBar != null && ((Component)object).isVisible() && jScrollBar.isVisible()) {
                int n = ((JComponent)object).getX();
                int n2 = ((JComponent)object).getX() + ((JComponent)object).getWidth();
                int n3 = jScrollBar.getY();
                int n4 = jScrollBar.getY() + jScrollBar.getHeight();
                assert (this.appearanceContext != null);
                AquaAppearance aquaAppearance = this.appearanceContext.getAppearance();
                Color color = aquaAppearance.getColor("legacyScrollBarTrack");
                Color color2 = aquaAppearance.getColor("legacyScrollBarOuterBorder");
                int n5 = n2 - n;
                int n6 = n4 - n3;
                graphics.setColor(color);
                graphics.fillRect(n, n3, n5 - 1, n6 - 1);
                graphics.setColor(color2);
                graphics.fillRect(n, n4 - 1, n5, 1);
                if (AquaUtils.isLeftToRight(this.scrollpane) || !isRTLSupported) {
                    graphics.fillRect(n2 - 1, n3, 1, n6 - 1);
                    graphics.fillRect(n, n3, 1, 1);
                } else {
                    graphics.fillRect(n, n3, 1, n6 - 1);
                    graphics.fillRect(n2 - 1, n3, 1, 1);
                }
            }
        }
    }

    protected boolean isSideBar() {
        AquaTreeUI aquaTreeUI;
        Component component;
        JViewport jViewport = this.scrollpane.getViewport();
        return jViewport != null && (component = SwingUtilities.getUnwrappedView(jViewport)) instanceof JTree && (aquaTreeUI = AquaUtils.getUI((JTree)component, AquaTreeUI.class)) != null && aquaTreeUI.isSideBar();
    }

    protected void setSidebarStyle(JScrollBar jScrollBar, boolean bl) {
        if (jScrollBar != null) {
            Object object = jScrollBar.getClientProperty("JScrollBar.style");
            if (object == null) {
                if (bl) {
                    jScrollBar.putClientProperty("JScrollBar.style", "sidebar");
                }
            } else if (object.equals("sidebar") && !bl) {
                jScrollBar.putClientProperty("JScrollBar.style", null);
            }
        }
    }

    public boolean isOverlayScrollBars() {
        return this.isOverlayScrollBars;
    }

    public boolean isSmoothScrolling() {
        return this.isSmoothScrolling;
    }

    protected boolean computeSmoothScrolling() {
        Object object = this.scrollpane.getClientProperty(SCROLL_PANE_SMOOTH_SCROLLING);
        return !Boolean.FALSE.equals(object);
    }

    protected void updateStyle() {
        boolean bl = this.shouldUseOverlayScrollBars();
        if (bl != this.isOverlayScrollBars) {
            this.setScrollBarStyle(bl);
            this.scrollpane.putClientProperty(SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY, bl);
        }
    }

    protected void updateThumbStyle() {
        if (this.isOverlayScrollBars) {
            this.updateScrollBar(this.scrollpane.getHorizontalScrollBar());
            this.updateScrollBar(this.scrollpane.getVerticalScrollBar());
        }
    }

    protected boolean shouldUseOverlayScrollBars() {
        LayoutManager layoutManager = this.scrollpane.getLayout();
        if (layoutManager != null && !(layoutManager instanceof UIResource)) {
            return false;
        }
        Object object = this.scrollpane.getClientProperty(SCROLL_PANE_STYLE_KEY);
        if ("overlay".equals(object)) {
            return true;
        }
        if ("legacy".equals(object)) {
            return false;
        }
        return OSXSystemProperties.useOverlayScrollBars();
    }

    protected void setScrollBarStyle(boolean bl) {
        this.isOverlayScrollBars = bl;
        this.syncLayoutManager();
        this.syncOverlayScrollPaneHack();
        if (this.isOverlayScrollBars) {
            if (this.overlayController == null) {
                this.overlayController = new AquaOverlayJScrollPaneController();
            }
        } else if (this.overlayController != null) {
            this.overlayController.dispose();
            this.overlayController = null;
        }
        this.updateScrollBar(this.scrollpane.getHorizontalScrollBar());
        this.updateScrollBar(this.scrollpane.getVerticalScrollBar());
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void syncOverlayScrollPaneHack() {
        if (this.isOverlayScrollBars && this.scrollpane.isOptimizedDrawingEnabled()) {
            if (this.overlayScrollPaneHack == null) {
                this.overlayScrollPaneHack = new OverlayScrollPaneHack(this.scrollpane);
            }
        } else if (this.overlayScrollPaneHack != null) {
            this.overlayScrollPaneHack.dispose();
            this.overlayScrollPaneHack = null;
        }
    }

    public void syncOverlayScrollPaneViewportHolderSize() {
        if (this.overlayScrollPaneHack != null) {
            this.overlayScrollPaneHack.syncScrollPaneSize();
        }
    }

    protected void updateScrollBar(JScrollBar jScrollBar) {
        if (jScrollBar != null) {
            jScrollBar.revalidate();
            jScrollBar.repaint();
            jScrollBar.putClientProperty("JComponent.sizeVariant", AquaUtilControlSize.getStringFromSize(this.size));
            if (this.isOverlayScrollBars) {
                Object object = this.scrollpane.getClientProperty(SCROLL_PANE_THUMB_STYLE_KEY);
                if (THUMB_STYLE_LIGHT.equals(object)) {
                    jScrollBar.putClientProperty("JScrollBar.thumbStyle", "overlayLight");
                } else if (THUMB_STYLE_DARK.equals(object)) {
                    jScrollBar.putClientProperty("JScrollBar.thumbStyle", "overlayDark");
                } else {
                    AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(this.scrollpane);
                    String string = aquaAppearance.isDark() ? "overlayLight" : "overlayDark";
                    jScrollBar.putClientProperty("JScrollBar.thumbStyle", string);
                }
            } else {
                jScrollBar.putClientProperty("JScrollBar.thumbStyle", null);
            }
        }
    }

    protected boolean syncLayoutManager() {
        LayoutManager layoutManager = this.scrollpane.getLayout();
        if (layoutManager instanceof AquaOverlayScrollPaneLayout) {
            if (!this.isOverlayScrollBars) {
                this.scrollpane.setLayout(this.legacyLayoutManager);
                return true;
            }
        } else {
            this.legacyLayoutManager = layoutManager;
            if (this.isOverlayScrollBars) {
                if (layoutManager instanceof UIResource) {
                    this.scrollpane.setLayout(new AquaOverlayScrollPaneLayout());
                    this.hideScrollBar(this.scrollpane.getHorizontalScrollBar());
                    this.hideScrollBar(this.scrollpane.getVerticalScrollBar());
                    return true;
                }
                this.updateStyle();
            }
        }
        return false;
    }

    protected void hideScrollBar(JScrollBar jScrollBar) {
        if (jScrollBar != null) {
            jScrollBar.setVisible(false);
        }
    }

    private void scrollByUnitsFast(@NotNull JScrollBar jScrollBar, int n, int n2, double d, boolean bl) {
        int n3;
        JViewport jViewport = this.scrollpane.getViewport();
        assert (jViewport != null);
        Component component = jViewport.getView();
        Scrollable scrollable = (Scrollable)((Object)component);
        Rectangle rectangle = jViewport.getViewRect();
        int n4 = rectangle.x;
        boolean bl2 = ((Component)((Object)scrollable)).getComponentOrientation().isLeftToRight();
        int n5 = jScrollBar.getMinimum();
        int n6 = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent();
        if (bl) {
            n3 = scrollable.getScrollableBlockIncrement(rectangle, n, n2);
            if (n2 < 0) {
                n5 = Math.max(n5, jScrollBar.getValue() - n3);
            } else {
                n6 = Math.min(n6, jScrollBar.getValue() + n3);
            }
        }
        while (d > 0.0) {
            double d2 = Math.min(d, 1.0);
            int n7 = (int)(d2 * (double)scrollable.getScrollableUnitIncrement(rectangle, n, n2));
            if (n == 1) {
                if (n2 < 0) {
                    rectangle.y -= n7;
                    if (rectangle.y <= n5) {
                        rectangle.y = n5;
                        break;
                    }
                } else {
                    rectangle.y += n7;
                    if (rectangle.y >= n6) {
                        rectangle.y = n6;
                        break;
                    }
                }
            } else if (bl2 && n2 < 0 || !bl2 && n2 > 0) {
                rectangle.x -= n7;
                if (bl2 && rectangle.x < n5) {
                    rectangle.x = n5;
                    break;
                }
            } else if (bl2 && n2 > 0 || !bl2 && n2 < 0) {
                rectangle.x += n7;
                if (bl2 && rectangle.x > n6) {
                    rectangle.x = n6;
                    break;
                }
            } else assert (false) : "Nonsensical component orientation / scroll direction";
            d -= d2;
        }
        if (n == 1) {
            jScrollBar.setValue(rectangle.y);
        } else if (bl2) {
            jScrollBar.setValue(rectangle.x);
        } else {
            n3 = jScrollBar.getValue() - (rectangle.x - n4);
            if (n3 < n5) {
                n3 = n5;
            } else if (n3 > n6) {
                n3 = n6;
            }
            jScrollBar.setValue(n3);
        }
    }

    private void scrollByUnits(JScrollBar jScrollBar, int n, double d, boolean bl) {
        int n2 = -1;
        if (bl) {
            n2 = n < 0 ? jScrollBar.getValue() - jScrollBar.getBlockIncrement(n) : jScrollBar.getValue() + jScrollBar.getBlockIncrement(n);
        }
        boolean bl2 = true;
        while (d > 0.0) {
            double d2 = this.isSmoothScrolling ? d : Math.min(d, 1.0);
            int n3 = (int)(d2 * (double)this.getWheelScrollUnitIncrement(jScrollBar, n));
            if (n < 0) {
                n3 = -n3;
            }
            int n4 = jScrollBar.getValue();
            int n5 = n4 + n3;
            if (n3 > 0 && n5 < n4) {
                n5 = jScrollBar.getMaximum();
            } else if (n3 < 0 && n5 > n4) {
                n5 = jScrollBar.getMinimum();
            }
            if (n4 == n5) break;
            if (bl && !bl2) {
                assert (n2 != -1);
                if (n < 0 && n5 < n2 || n > 0 && n5 > n2) break;
            }
            jScrollBar.setValue(n5);
            d -= d2;
            bl2 = false;
        }
    }

    static void scrollByBlock(JScrollBar jScrollBar, int n) {
        int n2 = jScrollBar.getValue();
        int n3 = jScrollBar.getBlockIncrement(n);
        int n4 = n3 * (n > 0 ? 1 : -1);
        int n5 = n2 + n4;
        if (n4 > 0 && n5 < n2) {
            n5 = jScrollBar.getMaximum();
        } else if (n4 < 0 && n5 > n2) {
            n5 = jScrollBar.getMinimum();
        }
        jScrollBar.setValue(n5);
    }

    protected int getWheelUnitScrollIncrement(@NotNull Scrollable scrollable, @NotNull Rectangle rectangle, int n, int n2) {
        if (this.isSmoothScrolling) {
            return this.getSmoothScrollingIncrement((Component)((Object)scrollable), n2);
        }
        return scrollable.getScrollableUnitIncrement(rectangle, n, n2);
    }

    protected int getWheelScrollUnitIncrement(@NotNull JScrollBar jScrollBar, int n) {
        if (this.isSmoothScrolling) {
            return this.defaultSmoothScrollingUnitIncrement;
        }
        return jScrollBar.getUnitIncrement(n);
    }

    protected int getSmoothScrollingIncrement(@NotNull Component component, int n) {
        if (n == 1) {
            if (component instanceof JList) {
                JList jList = (JList)component;
                int n2 = jList.getFixedCellHeight();
                return n2 > 0 ? n2 : this.defaultSmoothScrollingUnitIncrement;
            }
            if (component instanceof JTree) {
                JTree jTree = (JTree)component;
                int n3 = jTree.getRowHeight();
                return n3 > 0 ? n3 : this.defaultSmoothScrollingUnitIncrement;
            }
            if (component instanceof JTable) {
                JTable jTable = (JTable)component;
                int n4 = jTable.getRowHeight();
                return n4 > 0 ? n4 : this.defaultSmoothScrollingUnitIncrement;
            }
        }
        return this.defaultSmoothScrollingUnitIncrement;
    }

    public static double getUnitsToScroll(@NotNull MouseWheelEvent mouseWheelEvent, boolean bl) {
        return bl ? (double)mouseWheelEvent.getUnitsToScroll() * mouseWheelEvent.getPreciseWheelRotation() : (double)mouseWheelEvent.getUnitsToScroll();
    }

    protected class XYMouseWheelHandler
    extends BasicScrollPaneUI.MouseWheelHandler {
        protected XYMouseWheelHandler() {
            super(AquaScrollPaneUI.this);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            JScrollBar jScrollBar;
            boolean bl = mouseWheelEvent.isShiftDown();
            if (!this.isAxisScrollable(bl)) {
                AquaScrollPaneUI.this.contraryScrollCount = 0;
                return;
            }
            if (AquaScrollPaneUI.this.overlayController != null) {
                int n = AquaScrollPaneUI.this.overlayController.getActiveAxis();
                if (n == 0 && !bl || n == 1 && bl) {
                    AquaScrollPaneUI.this.contraryScrollCount = (int)((double)AquaScrollPaneUI.this.contraryScrollCount + AquaScrollPaneUI.getUnitsToScroll(mouseWheelEvent, AquaScrollPaneUI.this.isSmoothScrolling));
                    if (Math.abs(AquaScrollPaneUI.this.contraryScrollCount) < 3) {
                        return;
                    }
                } else {
                    AquaScrollPaneUI.this.contraryScrollCount = 0;
                }
            }
            boolean bl2 = (jScrollBar = AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar()) != null && jScrollBar.isVisible();
            JScrollBar jScrollBar2 = AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
            boolean bl3 = jScrollBar2 != null && jScrollBar2.isVisible();
            boolean bl4 = false;
            if (jScrollBar != null) {
                jScrollBar.setVisible(!bl);
                if (!bl && AquaScrollPaneUI.this.overlayController != null) {
                    AquaScrollPaneUI.this.overlayController.activateScrollBar(mouseWheelEvent, true);
                    bl4 = true;
                }
            }
            if (jScrollBar2 != null) {
                jScrollBar2.setVisible(bl);
                if (bl && AquaScrollPaneUI.this.overlayController != null) {
                    AquaScrollPaneUI.this.overlayController.activateScrollBar(mouseWheelEvent, false);
                    bl4 = true;
                }
            }
            this.basicMouseWheelMoved(mouseWheelEvent);
            if (!bl4) {
                if (jScrollBar != null) {
                    jScrollBar.setVisible(bl2);
                }
                if (jScrollBar2 != null) {
                    jScrollBar2.setVisible(bl3);
                }
            }
            mouseWheelEvent.consume();
        }

        private void basicMouseWheelMoved(@NotNull MouseWheelEvent mouseWheelEvent) {
            if (AquaScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getWheelRotation() != 0) {
                JScrollBar jScrollBar = AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
                int n2 = 1;
                if (jScrollBar == null || !jScrollBar.isVisible() || mouseWheelEvent.isShiftDown()) {
                    jScrollBar = AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (jScrollBar == null || !jScrollBar.isVisible()) {
                        return;
                    }
                    n2 = 0;
                }
                mouseWheelEvent.consume();
                if (mouseWheelEvent.getScrollType() == 0) {
                    JViewport jViewport = AquaScrollPaneUI.this.scrollpane.getViewport();
                    if (jViewport == null) {
                        return;
                    }
                    Component component = jViewport.getView();
                    double d = Math.abs(AquaScrollPaneUI.getUnitsToScroll(mouseWheelEvent, AquaScrollPaneUI.this.isSmoothScrolling));
                    boolean bl = Math.abs(mouseWheelEvent.getWheelRotation()) <= 1;
                    Object object = jScrollBar.getClientProperty("JScrollBar.fastWheelScrolling");
                    if (Boolean.TRUE.equals(object) && component instanceof Scrollable && !AquaScrollPaneUI.this.isSmoothScrolling) {
                        AquaScrollPaneUI.this.scrollByUnitsFast(jScrollBar, n2, n, d, bl);
                    } else {
                        AquaScrollPaneUI.this.scrollByUnits(jScrollBar, n, d, bl);
                    }
                } else if (mouseWheelEvent.getScrollType() == 1) {
                    AquaScrollPaneUI.scrollByBlock(jScrollBar, n);
                }
            }
        }

        protected boolean isAxisScrollable(boolean bl) {
            JScrollBar jScrollBar;
            JScrollBar jScrollBar2 = jScrollBar = bl ? AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar() : AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar();
            if (jScrollBar == null) {
                return false;
            }
            int n = Math.max(0, jScrollBar.getMaximum() - jScrollBar.getMinimum());
            int n2 = jScrollBar.getModel().getExtent();
            return n2 > 0 && n2 < n;
        }
    }

    protected class MyComponentListener
    extends ComponentAdapter {
        protected MyComponentListener() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            AquaScrollPaneUI.this.syncLayoutManager();
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string != null) {
                if (string.equals(AquaScrollPaneUI.SCROLL_PANE_STYLE_KEY)) {
                    AquaScrollPaneUI.this.updateStyle();
                } else if (string.equals(AquaScrollPaneUI.SCROLL_PANE_THUMB_STYLE_KEY)) {
                    AquaScrollPaneUI.this.updateThumbStyle();
                } else if (string.equals("verticalScrollBar")) {
                    this.updateVerticalScrollBar();
                } else if (string.equals("horizontalScrollBar")) {
                    this.updateHorizontalScrollBar();
                } else if (string.equals(AquaScrollPaneUI.SCROLL_PANE_SMOOTH_SCROLLING)) {
                    AquaScrollPaneUI.this.isSmoothScrolling = AquaScrollPaneUI.this.computeSmoothScrolling();
                }
            }
        }

        protected void updateVerticalScrollBar() {
            if (AquaScrollPaneUI.this.overlayController != null) {
                AquaScrollPaneUI.this.overlayController.setVerticalScrollBar(AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar());
            }
            AquaScrollPaneUI.this.updateScrollBar(AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar());
        }

        protected void updateHorizontalScrollBar() {
            if (AquaScrollPaneUI.this.overlayController != null) {
                AquaScrollPaneUI.this.overlayController.setHorizontalScrollBar(AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar());
            }
            AquaScrollPaneUI.this.updateScrollBar(AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar());
        }
    }

    protected class PreferenceChangeListener
    implements ChangeListener {
        protected PreferenceChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AquaScrollPaneUI.this.updateStyle();
        }
    }

    protected class AquaOverlayJScrollPaneController
    extends AquaOverlayScrollPaneController {
        public AquaOverlayJScrollPaneController() {
            this.setVerticalScrollBar(AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar());
            this.setHorizontalScrollBar(AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar());
        }

        @Override
        protected void reconfigure(JScrollBar jScrollBar, String string) {
            if (AquaScrollPaneUI.this.overlayScrollPaneHack != null) {
                AquaScrollPaneUI.this.overlayScrollPaneHack.reconfigure(jScrollBar, string);
            } else {
                AquaScrollPaneUI.this.scrollpane.remove(jScrollBar);
                AquaScrollPaneUI.this.scrollpane.add(jScrollBar, string, 0);
            }
        }
    }
}

