/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaTextComponentBorder;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;

public class AquaTextFieldSearch {
    private static final String FIND_POPUP_KEY = "JTextField.Search.FindPopup";
    private static final String FIND_ACTION_KEY = "JTextField.Search.FindAction";
    private static final String CANCEL_ACTION_KEY = "JTextField.Search.CancelAction";
    private static final String PROMPT_KEY = "JTextField.Search.Prompt";

    protected static boolean hasPopupMenu(@NotNull JTextComponent jTextComponent) {
        return jTextComponent.getClientProperty(FIND_POPUP_KEY) instanceof JPopupMenu;
    }

    protected static void installSearchField(@NotNull JTextComponent jTextComponent) {
        AquaTextFieldSearch.uninstallSearchField(jTextComponent);
        SearchFieldBorder searchFieldBorder = new SearchFieldBorder(jTextComponent);
        jTextComponent.setBorder(searchFieldBorder);
        jTextComponent.setLayout(searchFieldBorder.getCustomLayout());
        jTextComponent.add((Component)AquaTextFieldSearch.getFindButton(jTextComponent), "West");
        jTextComponent.add((Component)AquaTextFieldSearch.getCancelButton(jTextComponent), "East");
        jTextComponent.add(AquaTextFieldSearch.getPromptLabel(jTextComponent), "Center");
    }

    protected static void uninstallSearchField(JTextComponent jTextComponent) {
        if (jTextComponent.getBorder() instanceof SearchFieldBorder) {
            jTextComponent.setBorder(UIManager.getBorder("TextField.border"));
            jTextComponent.removeAll();
        }
    }

    protected static AquaUIPainter.State getState(JButton jButton) {
        if (!AquaFocusHandler.isActive(jButton)) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (jButton.getModel().isPressed()) {
            return AquaUIPainter.State.PRESSED;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    protected static JButton createButton(final JTextComponent jTextComponent, Object object) {
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        jButton.setFocusable(false);
        jButton.setCursor(new Cursor(0));
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                jTextComponent.requestFocusInWindow();
            }
        });
        return jButton;
    }

    protected static JButton getFindButton(final JTextComponent jTextComponent) {
        final JButton jButton = AquaTextFieldSearch.createButton(jTextComponent, null);
        jButton.setName("find");
        final Object object = jTextComponent.getClientProperty(FIND_POPUP_KEY);
        if (object instanceof JPopupMenu) {
            jButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    ((JPopupMenu)object).show(jButton, 8, jButton.getHeight() - 2);
                    jTextComponent.requestFocusInWindow();
                    jTextComponent.repaint();
                }
            });
        }
        jButton.addActionListener(new FindAction(jTextComponent));
        return jButton;
    }

    private static Component getPromptLabel(final JTextComponent jTextComponent) {
        final JLabel jLabel = new JLabel();
        jLabel.putClientProperty("Aqua.Label.Role", "searchFieldPrompt");
        jLabel.setFont(null);
        jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
            }
        });
        jTextComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
            }
        });
        AquaTextFieldSearch.updatePromptLabel(jLabel, jTextComponent);
        return jLabel;
    }

    static void updatePromptLabel(final JLabel jLabel, final JTextComponent jTextComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            AquaTextFieldSearch.updatePromptLabelOnEDT(jLabel, jTextComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AquaTextFieldSearch.updatePromptLabelOnEDT(jLabel, jTextComponent);
                }
            });
        }
    }

    static void updatePromptLabelOnEDT(JLabel jLabel, JTextComponent jTextComponent) {
        Object object;
        String string = " ";
        if ("".equals(jTextComponent.getText()) && (object = jTextComponent.getClientProperty(PROMPT_KEY)) != null) {
            string = object.toString();
        }
        jLabel.setText(string);
    }

    protected static JButton getCancelButton(final JTextComponent jTextComponent) {
        final JButton jButton = AquaTextFieldSearch.createButton(jTextComponent, null);
        jButton.setName("cancel");
        jButton.addActionListener(new CancelAction(jTextComponent));
        jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updateCancelIcon(jButton, jTextComponent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updateCancelIcon(jButton, jTextComponent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AquaTextFieldSearch.updateCancelIcon(jButton, jTextComponent);
            }
        });
        AquaTextFieldSearch.updateCancelIcon(jButton, jTextComponent);
        return jButton;
    }

    static void updateCancelIcon(final JButton jButton, final JTextComponent jTextComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            AquaTextFieldSearch.updateCancelIconOnEDT(jButton, jTextComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AquaTextFieldSearch.updateCancelIconOnEDT(jButton, jTextComponent);
                }
            });
        }
    }

    static void updateCancelIconOnEDT(JButton jButton, JTextComponent jTextComponent) {
        jButton.setVisible(!"".equals(jTextComponent.getText()));
    }

    static class SearchFieldBorder
    extends AquaTextComponentBorder {
        protected boolean reallyPaintBorder;
        protected boolean doingLayout;

        public SearchFieldBorder(@NotNull JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        @Nullable
        protected AquaUIPainter.Size getSpecialDefaultSize() {
            if (OSXSystemProperties.OSVersion >= 1016) {
                boolean bl = AquaUtils.isOnToolbar(this.tc);
                return bl ? AquaUIPainter.Size.LARGE : null;
            }
            return null;
        }

        public void paint(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
            this.reallyPaintBorder = true;
            this.paintBorder(jComponent, graphics, n, n2, n3, n4);
            this.reallyPaintBorder = false;
        }

        @Override
        @NotNull
        protected AquaUIPainter.TextFieldWidget getWidget() {
            boolean bl;
            boolean bl2 = AquaFocusHandler.hasFocus(this.tc);
            String string = this.tc.getText();
            boolean bl3 = AquaTextFieldSearch.hasPopupMenu(this.tc) && (bl2 || OSXSystemProperties.OSVersion >= 1014);
            boolean bl4 = bl = !string.isEmpty();
            if (!bl && OSXSystemProperties.OSVersion < 1011) {
                bl = bl2;
            }
            boolean bl5 = AquaUtils.isOnToolbar(this.tc);
            return !bl ? (bl3 ? (bl5 ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_MENU_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_MENU) : (bl5 ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH)) : (bl3 ? (bl5 ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL) : (bl5 ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_CANCEL_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_CANCEL));
        }

        @Override
        @NotNull
        public Insets getBorderInsets(@NotNull Component component) {
            if (this.doingLayout) {
                return new Insets(0, 0, 0, 0);
            }
            return super.getBorderInsets(component);
        }

        @Override
        public int getTextMargin() {
            return 0;
        }

        protected LayoutManager getCustomLayout() {
            return new SearchFieldLayoutManager();
        }

        class SearchFieldLayoutManager
        implements LayoutManager {
            private JTextComponent tc;
            private Component findButton;
            private Component cancelButton;
            private Component promptLabel;

            SearchFieldLayoutManager() {
            }

            @Override
            public void addLayoutComponent(String string, Component component) {
                String string2 = component.getName();
                if ("find".equals(string2)) {
                    this.findButton = component;
                    this.tc = (JTextComponent)component.getParent();
                } else if ("cancel".equals(string2)) {
                    this.cancelButton = component;
                    this.tc = (JTextComponent)component.getParent();
                } else if (component instanceof JLabel) {
                    this.tc = (JTextComponent)component.getParent();
                    this.promptLabel = component;
                }
            }

            @Override
            public void removeLayoutComponent(Component component) {
            }

            @Override
            public Dimension preferredLayoutSize(Container container) {
                return null;
            }

            @Override
            public Dimension minimumLayoutSize(Container container) {
                return null;
            }

            @Override
            public void layoutContainer(Container container) {
                if (this.tc != null) {
                    Rectangle rectangle;
                    Insetter insetter;
                    Rectangle rectangle2 = new Rectangle(0, 0, this.tc.getWidth(), this.tc.getHeight());
                    AquaUIPainter.TextFieldWidget textFieldWidget = SearchFieldBorder.this.getWidget();
                    AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(this.tc);
                    AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(this.tc);
                    TextFieldLayoutConfiguration textFieldLayoutConfiguration = new TextFieldLayoutConfiguration(textFieldWidget, size, uILayoutDirection);
                    if (this.findButton != null) {
                        insetter = SearchFieldBorder.this.painter.getLayoutInfo().getSearchButtonInsets(textFieldLayoutConfiguration);
                        if (insetter != null) {
                            rectangle = insetter.applyToBounds(rectangle2);
                            this.findButton.setBounds(rectangle);
                        } else {
                            this.findButton.setBounds(0, 0, 0, 0);
                        }
                    }
                    if (this.cancelButton != null) {
                        insetter = SearchFieldBorder.this.painter.getLayoutInfo().getCancelButtonInsets(textFieldLayoutConfiguration);
                        if (insetter != null) {
                            rectangle = insetter.applyToBounds(rectangle2);
                            this.cancelButton.setBounds(rectangle);
                        } else {
                            this.cancelButton.setBounds(0, 0, 0, 0);
                        }
                    }
                    if (this.promptLabel != null) {
                        insetter = SearchFieldBorder.this.painter.getLayoutInfo().getTextFieldTextInsets(textFieldLayoutConfiguration);
                        rectangle = insetter.applyToBounds(rectangle2);
                        this.promptLabel.setBounds(rectangle);
                    }
                }
            }
        }
    }

    private static class FindAction
    implements ActionListener {
        private JTextComponent tc;

        public FindAction(JTextComponent jTextComponent) {
            this.tc = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextField jTextField;
            Action action;
            Object object = this.tc.getClientProperty(AquaTextFieldSearch.FIND_ACTION_KEY);
            if (object instanceof ActionListener) {
                ActionListener actionListener = (ActionListener)object;
                actionListener.actionPerformed(actionEvent);
            } else if (this.tc instanceof JTextField && (action = (jTextField = (JTextField)this.tc).getAction()) != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    private static class CancelAction
    implements ActionListener {
        private JTextComponent tc;

        public CancelAction(JTextComponent jTextComponent) {
            this.tc = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.tc.getClientProperty(AquaTextFieldSearch.CANCEL_ACTION_KEY);
            if (object instanceof ActionListener) {
                ActionListener actionListener = (ActionListener)object;
                actionListener.actionPerformed(actionEvent);
            }
            this.tc.setText("");
        }
    }
}

