/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Objects;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaTreeCellEditor;
import org.violetlib.aqua.AquaTreeMouseBehavior;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaViewStyleContainerUI;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.ExtendedVariableHeightLayoutCache;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.SelectionRepaintable;
import org.violetlib.aqua.TreeSelectionBoundsTracker;
import org.violetlib.aqua.Utils;
import org.violetlib.aqua.VisualEffectView;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AnimatedButtonConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class AquaTreeUI
extends BasicTreeUI
implements SelectionRepaintable,
AquaComponentUI,
AquaViewStyleContainerUI {
    public static final String IS_CELL_FILLED_KEY = "JTree.isCellFilled";
    public static final String QUAQUA_IS_CELL_FILLED_KEY = "Quaqua.Tree.isCellFilled";
    public static final String TREE_STYLE_KEY = "JTree.style";
    public static final String QUAQUA_TREE_STYLE_KEY = "Quaqua.Tree.style";
    public static final String TREE_VIEW_STYLE_KEY = "JTree.viewStyle";
    public static final String SELECTION_FOREGROUND_KEY = "JTree.selectionForeground";
    private static final int DEFAULT_INDENTATION = 16;
    private static final int SIDEBAR_INDENTATION = 13;
    private final FocusListener editingComponentFocusListener = new EditingComponentFocusListener();
    private final ComponentListener componentListener = new AquaTreeComponentListener();
    private final TreeModelListener treeModelListener = new AquaTreeModelListener();
    private final HierarchyListener hierarchyListener = new AquaTreeHierarchyListener();
    private Component editorFocusOwner;
    @Nullable
    private TreeCellEditor originalTreeCellEditor;
    protected TreePath fTrackingPath;
    protected boolean fIsPressed = false;
    protected boolean fIsInBounds = false;
    protected float fAnimationTransition = -1.0f;
    private boolean ignoreLAChange;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected boolean isCellFilled;
    protected boolean isSideBar;
    protected boolean isStriped;
    protected boolean isInset;
    @Nullable
    protected Boolean _isShallowSideBar;
    protected int indentationPerLevel = 16;
    protected int expandControlWidth = 16;
    protected int trailingExpandControlInset = 13;
    protected int leadingExpandControlSeparation = 6;
    protected boolean shouldPaintSelection;
    protected boolean isActive;
    private Font oldCellRendererFont;
    private Icon oldCellRendererIcon;
    private Icon oldCellRendererDisabledIcon;
    private SidebarVibrantEffects sidebarVibrantEffects;
    @Nullable
    private TreePath pathWithVisibleExpandControl;
    private static DropTargetListener defaultDropTargetListener = null;
    @NotNull
    protected ContainerContextualColors colors = AquaColors.CONTAINER_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTreeUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this.tree, "Tree.border");
        this.tree.setRootVisible(false);
        this.tree.putClientProperty("JComponent.isCellContainer", true);
        this.tree.setInvokesStopCellEditing(true);
        this.originalTreeCellEditor = null;
        this.cellEditorChanged();
        this.isStriped = this.getStripedValue();
        this.isInset = this.getInsetValue();
        this.isSideBar = this.getSideBarValue();
        this.isCellFilled = this.getCellFilledValue();
        this.tree.repaint();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.colors = this.determineColors();
        this.updateExpandControlSize();
        this.updateInset();
        this.updateSideBarConfiguration();
        this.configureAppearanceContext(null);
    }

    protected void cellEditorChanged() {
        TreeCellEditor treeCellEditor;
        if (this.originalTreeCellEditor == null && ((treeCellEditor = this.tree.getCellEditor()) == null || treeCellEditor.getClass() == DefaultCellEditor.class)) {
            this.installSpecialCellEditorIfAppropriate();
        }
    }

    protected void cellRendererChanged() {
        this.installSpecialCellEditorIfAppropriate();
    }

    protected void installSpecialCellEditorIfAppropriate() {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            if (this.originalTreeCellEditor == null) {
                this.originalTreeCellEditor = this.tree.getCellEditor();
            }
            this.tree.setCellEditor(new AquaTreeCellEditor(this.tree, defaultTreeCellRenderer));
        }
    }

    @Override
    protected void uninstallDefaults() {
        TreeCellEditor treeCellEditor = this.tree.getCellEditor();
        if (treeCellEditor instanceof AquaTreeCellEditor) {
            this.tree.setCellEditor(this.originalTreeCellEditor);
        }
        this.originalTreeCellEditor = null;
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AppearanceManager.installListeners(this.tree);
        this.tree.addComponentListener(this.componentListener);
        this.tree.addHierarchyListener(this.hierarchyListener);
        TreeModel treeModel = this.tree.getModel();
        if (treeModel != null) {
            treeModel.addTreeModelListener(this.treeModelListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        TreeModel treeModel = this.tree.getModel();
        if (treeModel != null) {
            treeModel.removeTreeModelListener(this.treeModelListener);
        }
        this.tree.removeHierarchyListener(this.hierarchyListener);
        this.tree.removeComponentListener(this.componentListener);
        AppearanceManager.uninstallListeners(this.tree);
        super.uninstallListeners();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.tree);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        this.colors.configureForContainer();
        AquaColors.installColors(this.tree, this.appearanceContext, this.colors);
        if (Utils.getJavaVersion() < 1700000) {
            this.tree.setOpaque(!this.isStriped);
        } else {
            LookAndFeel.installProperty(this.tree, "opaque", !this.isStriped);
        }
        this.tree.repaint();
        this.repaintScrollPane();
    }

    @NotNull
    protected ContainerContextualColors determineColors() {
        if (this.isSideBar()) {
            return AquaColors.SIDEBAR_CONTAINER_COLORS;
        }
        if (this.isStriped) {
            return AquaColors.STRIPED_CONTAINER_COLORS;
        }
        return AquaColors.CONTAINER_COLORS;
    }

    protected void repaintScrollPane() {
        JViewport jViewport;
        Container container;
        Container container2;
        if (this.isSideBar() && (container2 = this.tree.getParent()) instanceof JViewport && (container = (jViewport = (JViewport)container2).getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            jScrollPane.repaint();
        }
    }

    protected AquaUIPainter.State getState() {
        if (!AquaFocusHandler.isActive(this.tree)) {
            return AquaUIPainter.State.INACTIVE;
        }
        return this.tree.isEnabled() ? (this.shouldDisplayAsFocused() ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.DISABLED;
    }

    protected boolean shouldDisplayAsFocused() {
        return AquaFocusHandler.isActive(this.tree) && (AquaFocusHandler.hasFocus(this.tree) || this.tree.isEditing());
    }

    protected void updateRowHeight() {
        int n = this.isSideBar() ? 0 : 19;
        LookAndFeel.installProperty(this.tree, "rowHeight", n);
    }

    protected void updateSideBarConfiguration() {
        if (this.isSideBar() && this.tree.isDisplayable()) {
            this.ensureSidebarVibrantEffects();
        } else {
            this.disposeSidebarVibrantEffects();
        }
        this.indentationPerLevel = this.isSideBar() ? 13 : 16;
        int n = 5 * this.indentationPerLevel / 12;
        this.setLeftChildIndent(n);
        this.setRightChildIndent(this.indentationPerLevel - n);
        if (AquaUtils.isInsetViewSupported()) {
            this.updateRowHeight();
            this.tree.revalidate();
            this.tree.repaint();
            this.updateCellSizes();
        }
    }

    protected void ensureSidebarVibrantEffects() {
        JComponent jComponent = this.getComponentForVisualEffectView();
        if (this.sidebarVibrantEffects != null && this.sidebarVibrantEffects.getComponent() != jComponent) {
            this.disposeSidebarVibrantEffects();
        }
        if (this.sidebarVibrantEffects == null) {
            this.sidebarVibrantEffects = new SidebarVibrantEffects(jComponent);
        }
    }

    protected void disposeSidebarVibrantEffects() {
        if (this.sidebarVibrantEffects != null) {
            this.sidebarVibrantEffects.dispose();
            this.sidebarVibrantEffects = null;
        }
    }

    @NotNull
    protected JComponent getComponentForVisualEffectView() {
        Container container = this.tree.getParent();
        if (container instanceof JViewport) {
            return (JViewport)container;
        }
        return this.tree;
    }

    private void updateCellFilled() {
        boolean bl = this.getCellFilledValue();
        if (bl != this.isCellFilled) {
            this.isCellFilled = bl;
            if (this.tree != null) {
                this.tree.repaint();
                if (this.treeState != null) {
                    this.treeState.invalidateSizes();
                }
            }
        }
    }

    private boolean getCellFilledValue() {
        return this.tree != null && Boolean.TRUE.equals(AquaUtils.getBooleanProperty(this.tree, IS_CELL_FILLED_KEY, QUAQUA_IS_CELL_FILLED_KEY));
    }

    private void updateStyleProperties() {
        boolean bl = false;
        boolean bl2 = this.getStripedValue();
        if (bl2 != this.isStriped) {
            this.isStriped = bl2;
            bl = true;
        }
        boolean bl3 = false;
        boolean bl4 = this.getSideBarValue();
        if (bl4 != this.isSideBar) {
            this.isSideBar = bl4;
            bl3 = true;
        }
        if (bl || bl3) {
            this.colors = this.determineColors();
            this.configureAppearanceContext(null);
            this.tree.repaint();
        }
        if (bl3) {
            this.updateSideBarConfiguration();
        }
    }

    private boolean getStripedValue() {
        String string = this.getStyleProperty();
        return "striped".equals(string) && this.isBackgroundClear();
    }

    private boolean getSideBarValue() {
        String string = this.getStyleProperty();
        return string != null && (string.equals("sideBar") || string.equals("sourceList"));
    }

    @Override
    public void scrollPaneAncestorChanged(@Nullable JScrollPane jScrollPane) {
    }

    private void updateInset() {
        boolean bl = this.getInsetValue();
        if (bl != this.isInset) {
            this.isInset = bl;
            this.tree.revalidate();
            this.tree.repaint();
            this.updateCellSizes();
        }
    }

    private boolean getInsetValue() {
        if (AquaUtils.isInsetViewSupported()) {
            String string = this.getViewStyleProperty();
            return "inset".equals(string);
        }
        return false;
    }

    public boolean isStriped() {
        return this.isStriped;
    }

    public boolean isSideBar() {
        return this.isSideBar;
    }

    public boolean isShallowSideBar() {
        if (this.isSideBar()) {
            if (this._isShallowSideBar == null) {
                this._isShallowSideBar = this.computeIsShallowSideBar();
            }
            return this._isShallowSideBar;
        }
        return false;
    }

    protected boolean computeIsShallowSideBar() {
        if (this.tree != null) {
            TreeModel treeModel = this.tree.getModel();
            Object object = treeModel.getRoot();
            int n = treeModel.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = treeModel.getChild(object, i);
                int n2 = treeModel.getChildCount(object2);
                for (int j = 0; j < n2; ++j) {
                    Object object3 = treeModel.getChild(object2, j);
                    if (treeModel.isLeaf(object3)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isInset() {
        return this.isInset || this.isSideBar() && OSXSystemProperties.useInsetViewStyle();
    }

    private boolean isBackgroundClear() {
        Color color = this.tree.getBackground();
        return color == null || color.getAlpha() == 0 || color instanceof ColorUIResource;
    }

    protected boolean isCellFilledProperty(String string) {
        return AquaUtils.isProperty(string, IS_CELL_FILLED_KEY, QUAQUA_IS_CELL_FILLED_KEY);
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, TREE_STYLE_KEY, QUAQUA_TREE_STYLE_KEY);
    }

    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.tree, TREE_STYLE_KEY, QUAQUA_TREE_STYLE_KEY);
    }

    protected boolean isViewStyleProperty(String string) {
        return AquaUtils.isProperty(string, TREE_VIEW_STYLE_KEY);
    }

    protected String getViewStyleProperty() {
        return AquaUtils.getProperty(this.tree, TREE_VIEW_STYLE_KEY);
    }

    @Override
    protected MouseListener createMouseListener() {
        return new AquaTreeMouseBehavior(this.tree);
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MacPropertyChangeHandler();
    }

    @Override
    public boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        boolean bl = super.startEditing(treePath, mouseEvent);
        if (bl) {
            this.editorFocusOwner = AquaFocusHandler.getFocusableComponent(this.editingComponent);
            if (this.editorFocusOwner != null) {
                this.editorFocusOwner.addFocusListener(this.editingComponentFocusListener);
            }
        }
        return bl;
    }

    @Override
    public void completeEditing() {
        super.completeEditing();
    }

    @Override
    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (this.editorFocusOwner != null) {
            this.editorFocusOwner.removeFocusListener(this.editingComponentFocusListener);
        }
        super.completeEditing(bl, bl2, bl3);
        this.configureAppearanceContext(null);
    }

    public void mouseMoved(@Nullable MouseEvent mouseEvent) {
        if (this.isSideBar()) {
            TreePath treePath;
            if (mouseEvent != null && (treePath = this.getPathForYLocation(mouseEvent.getY())) != null && this.isCategory(treePath)) {
                this.updateCategoryExpandControlVisibility(treePath);
                return;
            }
            this.updateCategoryExpandControlVisibility(null);
        }
    }

    protected void updateCategoryExpandControlVisibility(@Nullable TreePath treePath) {
        if (!Objects.equals(treePath, this.pathWithVisibleExpandControl)) {
            this.pathWithVisibleExpandControl = treePath;
            this.tree.repaint();
        }
    }

    protected boolean useTrailingExpandControl(@NotNull TreePath treePath) {
        return this.isCategory(treePath);
    }

    protected boolean useTrailingExpandControl(int n) {
        return this.isCategory(n);
    }

    @Override
    public void startEditingAtPath(JTree jTree, TreePath treePath) {
        if (AquaTreeMouseBehavior.isDebug) {
            Utils.logDebug("JTree editing cell " + treePath);
        }
        super.startEditingAtPath(jTree, treePath);
    }

    public void setAnchorSelectionPath(TreePath treePath) {
        this.ignoreLAChange = true;
        try {
            this.tree.setAnchorSelectionPath(treePath);
        }
        finally {
            this.ignoreLAChange = false;
        }
    }

    public TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeadSelectionPath(TreePath treePath, boolean bl) {
        Rectangle rectangle = bl ? this.getPathBounds(this.tree, this.getLeadSelectionPath()) : null;
        this.ignoreLAChange = true;
        try {
            this.tree.setLeadSelectionPath(treePath);
        }
        finally {
            this.ignoreLAChange = false;
        }
        if (bl) {
            if (rectangle != null) {
                this.tree.repaint(rectangle);
            }
            if ((rectangle = this.getPathBounds(this.tree, treePath)) != null) {
                this.tree.repaint(rectangle);
            }
        }
    }

    public TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    public void setLeadSelectionPath(TreePath treePath) {
        this.setLeadSelectionPath(treePath, false);
    }

    @Override
    protected void setShowsRootHandles(boolean bl) {
        super.setShowsRootHandles(true);
    }

    @Override
    protected boolean getShowsRootHandles() {
        return true;
    }

    @Override
    public TreePath getClosestPathForLocation(@Nullable JTree jTree, int n, int n2) {
        if (jTree == null || this.treeState == null) {
            return null;
        }
        Insets insets = jTree.getInsets();
        return this.treeState.getPathClosestTo(n - insets.left, n2 - insets.top);
    }

    @Nullable
    protected TreePath getPathForYLocation(int n) {
        if (this.treeState != null) {
            Rectangle rectangle;
            Insets insets = this.tree.getInsets();
            TreePath treePath = this.treeState.getPathClosestTo(insets.left, n - insets.top);
            if (treePath != null && (rectangle = this.getPathBounds(treePath, insets, null)) != null && n >= rectangle.y && n <= rectangle.y + rectangle.height) {
                return treePath;
            }
        }
        return null;
    }

    public boolean isCategory(int n) {
        return this.isSideBar() && n == 1;
    }

    public boolean isCategory(@NotNull TreePath treePath) {
        return this.isSideBar() && treePath.getPathCount() == 2;
    }

    @Override
    public void repaintSelection() {
        if (this.tree == null) {
            return;
        }
        Object object = this.tree.getClientProperty("JTree.selectionRepainter");
        if (object instanceof SelectionRepaintable) {
            SelectionRepaintable selectionRepaintable = (SelectionRepaintable)object;
            selectionRepaintable.repaintSelection();
            return;
        }
        Rectangle rectangle = null;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                if (i == 0) {
                    rectangle = this.getPathBounds(this.tree, treePathArray[i]);
                    continue;
                }
                rectangle.add(this.getPathBounds(this.tree, treePathArray[i]));
            }
            if (rectangle != null) {
                this.tree.repaint(0, rectangle.y, this.tree.getWidth(), rectangle.height);
            }
        }
    }

    @NotNull
    private Rectangle computeRowBounds(int n, @NotNull Dimension dimension, @Nullable Rectangle rectangle) {
        int n2;
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = this.getRowHeight();
        if (n5 > 0) {
            n4 = n5;
        } else {
            n2 = this.getStyleRowHeight(n);
            if (n2 > n4) {
                n4 = n2;
            }
        }
        n2 = this.getIndentation(n);
        if (rectangle != null) {
            rectangle.x = n2;
            rectangle.width = n3;
            rectangle.height = n4;
            return rectangle;
        }
        return new Rectangle(n2, 0, n3, n4);
    }

    @Override
    protected int getRowX(int n, int n2) {
        throw new AssertionError((Object)"Unexpected call to AquaTreeUI.getRowX");
    }

    protected int getIndentation(int n) {
        int n2 = n;
        int n3 = 0;
        if (this.isSideBar()) {
            --n2;
            if (OSXSystemProperties.OSVersion < 1016) {
                if (!this.isCategory(n)) {
                    n3 = 3;
                }
            } else if (this.isShallowSideBar()) {
                --n2;
            }
        }
        if (this.useTrailingExpandControl(n)) {
            --n2;
        }
        n2 = Math.max(0, n2);
        int n4 = this.indentationPerLevel * (n2 + this.depthOffset) + n3;
        if (AquaTreeMouseBehavior.isDebug) {
            Utils.logDebug("Indentation: " + n4 + " for depth " + n + " -> " + n2);
        }
        return n4;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(@NotNull Graphics graphics, @NotNull JComponent jComponent) {
        if (this.treeState == null || this.appearanceContext == null) {
            return;
        }
        if (this.sidebarVibrantEffects != null) {
            this.sidebarVibrantEffects.update();
        }
        this.isActive = AquaFocusHandler.isActive(jComponent);
        this.shouldPaintSelection = !Boolean.FALSE.equals(this.tree.getClientProperty("JTree.paintSelectionBackground"));
        Color color = this.getCurrentBackground();
        this.paintBackground(graphics, color);
        super.paint(graphics, jComponent);
    }

    protected void paintBackground(@NotNull Graphics graphics, @Nullable Color color) {
        if (this.tree.isOpaque()) {
            int n = this.tree.getWidth();
            int n2 = this.tree.getHeight();
            AquaUtils.fillRect(graphics, color, 0, 0, n, n2);
        }
        Rectangle rectangle = graphics.getClipBounds();
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        if (treePath != null && enumeration != null) {
            this.paintRowBackgrounds(graphics, treePath, enumeration);
        } else if (this.isStriped) {
            this.paintEmptyTreeStripes(graphics);
        }
    }

    @Nullable
    public Color getCurrentBackground() {
        return this.isSideBar() ? null : this.tree.getBackground();
    }

    protected void paintRowBackgrounds(Graphics graphics, TreePath treePath, Enumeration enumeration) {
        TreePath treePath2;
        if (!this.isStriped && !this.shouldPaintSelection) {
            return;
        }
        this.colors.configureForContainer();
        int n = this.tree.getWidth();
        int n2 = this.tree.getHeight();
        Insets insets = this.tree.getInsets();
        int n3 = n - insets.left - insets.left;
        int n4 = this.tree.getRowHeight();
        if (n4 <= 0) {
            n4 = this.tree.getFont().getSize() + 4;
        }
        int n5 = this.treeState.getRowForPath(treePath);
        Rectangle rectangle = graphics.getClipBounds();
        int n6 = rectangle.y + rectangle.height;
        while (enumeration.hasMoreElements() && (treePath2 = (TreePath)enumeration.nextElement()) != null) {
            Rectangle rectangle2 = this.getPathBounds(this.tree, treePath2);
            if (rectangle2 == null) {
                return;
            }
            boolean bl = this.tree.isRowSelected(n5) && this.shouldPaintSelection;
            Color color = this.getSpecialBackgroundForRow(n5, bl);
            if (color != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(color);
                int n7 = insets.left;
                int n8 = rectangle2.y;
                int n9 = n3;
                int n10 = rectangle2.height;
                if (this.isInset() && bl) {
                    boolean bl2 = n5 > 0 && this.tree.isRowSelected(n5 - 1);
                    boolean bl3 = n5 < this.tree.getRowCount() - 1 && this.tree.isRowSelected(n5 + 1);
                    AquaUtils.paintInsetCellSelection(graphics2D, bl2, bl3, 0, n8, n, n10);
                } else if (this.isInset() && this.isStriped()) {
                    AquaUtils.paintInsetStripedRow(graphics2D, 0, n8, n, n10);
                } else {
                    graphics2D.fillRect(n7, n8, n9, n10);
                }
            }
            if (rectangle2.y + rectangle2.height >= n6) break;
            ++n5;
        }
        this.colors.configureForContainer();
    }

    @Nullable
    protected Color getSpecialBackgroundForRow(int n, boolean bl) {
        assert (this.appearanceContext != null);
        AppearanceContext appearanceContext = this.appearanceContext;
        if (bl) {
            if (this.sidebarVibrantEffects != null) {
                return null;
            }
            appearanceContext = appearanceContext.withSelected(true);
        } else if (!this.isStriped) {
            return null;
        }
        this.colors.configureForRow(n, bl);
        return this.colors.getBackground(appearanceContext);
    }

    protected void paintEmptyTreeStripes(Graphics graphics) {
        assert (this.appearanceContext != null);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.tree.getWidth();
        int n2 = this.tree.getHeight();
        Insets insets = this.tree.getInsets();
        int n3 = n - insets.left - insets.left;
        int n4 = this.tree.getRowHeight();
        if (n4 <= 0) {
            n4 = this.tree.getFont().getSize() + 4;
        }
        int n5 = 0;
        for (int i = 0; i < n2; i += n4) {
            boolean bl = this.tree.isRowSelected(n5);
            this.colors.configureForRow(n5, bl);
            Color color = this.colors.getBackground(this.appearanceContext);
            graphics.setColor(color);
            if (this.isInset()) {
                AquaUtils.paintInsetStripedRow(graphics2D, 0, i, n, n4);
            } else {
                graphics.fillRect(insets.left, i, n3, n4);
            }
            ++n5;
        }
    }

    @Override
    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        assert (this.appearanceContext != null);
        if (this.editingComponent != null && this.editingRow == n) {
            return;
        }
        int n2 = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        boolean bl4 = this.tree.isRowSelected(n);
        this.colors.configureForRow(n, bl4);
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), bl4, bl, bl3, n, n2 == n);
        boolean bl5 = treePath.getPathCount() == 2;
        this.configureCellRenderer(false, component, bl5, bl4);
        this.rendererPane.paintComponent(graphics, component, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
        this.unconfigureCellRenderer(component);
    }

    protected void configureCellRenderer(boolean bl, Component component, boolean bl2, boolean bl3) {
        Object object;
        JLabel jLabel;
        if (component instanceof DefaultTreeCellRenderer) {
            jLabel = (DefaultTreeCellRenderer)component;
            object = jLabel.getBorder();
            if (object instanceof UIResource && object != AquaLookAndFeel.NOTHING_BORDER) {
                jLabel.setBorder(AquaLookAndFeel.NOTHING_BORDER);
            }
            if (!bl) {
                assert (this.appearanceContext != null);
                ((DefaultTreeCellRenderer)jLabel).setBackgroundNonSelectionColor(AquaColors.CLEAR);
                ((DefaultTreeCellRenderer)jLabel).setBackgroundSelectionColor(AquaColors.CLEAR);
                ((DefaultTreeCellRenderer)jLabel).setBorderSelectionColor(AquaColors.CLEAR);
            }
        }
        if (component instanceof JLabel) {
            Serializable serializable;
            jLabel = (JLabel)component;
            this.oldCellRendererFont = jLabel.getFont();
            this.oldCellRendererIcon = jLabel.getIcon();
            this.oldCellRendererDisabledIcon = jLabel.getDisabledIcon();
            object = this.appearanceContext != null ? this.colors.getForeground(this.appearanceContext) : null;
            Font font = null;
            Icon icon = this.oldCellRendererIcon;
            if (this.isSideBar()) {
                if (bl2) {
                    jLabel.setIcon(null);
                    jLabel.setDisabledIcon(null);
                    icon = null;
                }
                object = this.getSideBarForeground(bl2, bl3);
                serializable = this.getSideBarFont(bl2, bl3);
                if (serializable != null) {
                    font = this.fixFont((Font)serializable);
                }
            }
            if (!bl) {
                if (icon != null) {
                    icon = this.convertIcon(bl2, bl3, icon);
                }
                if (icon != this.oldCellRendererIcon) {
                    jLabel.setIcon(icon);
                }
                if (object != null && ((serializable = jLabel.getForeground()) == null || serializable instanceof UIResource)) {
                    jLabel.setForeground((Color)object);
                }
            }
            if (font != null) {
                jLabel.setFont(font);
            }
        }
    }

    protected void unconfigureCellRenderer(Component component) {
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setFont(this.oldCellRendererFont);
            jLabel.setIcon(this.oldCellRendererIcon);
            jLabel.setDisabledIcon(this.oldCellRendererDisabledIcon);
        }
    }

    public void paintEditorIcon(@NotNull Graphics graphics, @NotNull TreePath treePath, @NotNull Icon icon, int n, int n2) {
        boolean bl;
        boolean bl2 = this.isCategory(treePath);
        icon = this.convertIcon(bl2, bl = this.tree.isPathSelected(treePath), icon);
        if (icon != null) {
            icon.paintIcon(this.tree, graphics, n, n2);
        }
    }

    @Nullable
    protected Icon convertIcon(boolean bl, boolean bl2, @NotNull Icon icon) {
        Image image;
        Object object;
        if (bl && this.isSideBar()) {
            return null;
        }
        if (AquaImageFactory.isTemplateIcon(icon) && (object = this.getOperatorForTemplateIcon(bl2)) != null && (image = AquaImageFactory.getProcessedImage(icon, object)) != null) {
            return new ImageIcon(image);
        }
        return icon;
    }

    @Nullable
    protected Object getOperatorForTemplateIcon(boolean bl) {
        AquaAppearance aquaAppearance;
        AquaAppearance aquaAppearance2 = aquaAppearance = this.appearanceContext != null ? this.appearanceContext.getAppearance() : null;
        if (this.isSideBar()) {
            if (OSXSystemProperties.OSVersion >= 1016 && aquaAppearance != null) {
                if (AquaFocusHandler.isActive(this.tree)) {
                    if (aquaAppearance.isDark()) {
                        return aquaAppearance.getColor("controlAccent");
                    }
                    return aquaAppearance.getColor("controlAccent_pressed");
                }
                return aquaAppearance.getColor("controlAccent_disabled");
            }
            Color color = null;
            if (aquaAppearance != null) {
                color = aquaAppearance.getColor("sidebarIcon");
            }
            if (color != null) {
                return color;
            }
            return AquaFocusHandler.isActive(this.tree) ? null : AquaImageFactory.LIGHTEN_FOR_DISABLED;
        }
        if (bl && this.appearanceContext != null && AquaFocusHandler.isActive(this.tree)) {
            AppearanceContext appearanceContext = this.appearanceContext.withSelected(true);
            return this.colors.getForeground(appearanceContext);
        }
        return aquaAppearance != null ? aquaAppearance.getColor("treeIcon") : null;
    }

    protected Font getSideBarFont(boolean bl, boolean bl2) {
        if (bl) {
            return UIManager.getFont("Tree.sideBarCategory.font");
        }
        if (bl2) {
            return UIManager.getFont("Tree.sideBar.selectionFont");
        }
        return UIManager.getFont("Tree.sideBar.font");
    }

    protected Color getSideBarForeground(boolean bl, boolean bl2) {
        if (bl) {
            return AquaColors.getSystemColor(this.tree, "secondaryLabel");
        }
        AppearanceContext appearanceContext = this.appearanceContext;
        assert (appearanceContext != null);
        if (bl2) {
            appearanceContext = appearanceContext.withSelected(true);
        }
        return this.colors.getForeground(appearanceContext);
    }

    protected Font fixFont(Font font) {
        return font instanceof FontUIResource ? new MyFont(font) : font;
    }

    protected void paintHorizontalSeparators(Graphics graphics, JComponent jComponent) {
        graphics.setColor(UIManager.getColor("Tree.line"));
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y));
        int n2 = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y + rectangle.height - 1));
        if (n <= -1 || n2 <= -1) {
            return;
        }
        for (int i = n; i <= n2; ++i) {
            Rectangle rectangle2;
            TreePath treePath = this.getPathForRow(this.tree, i);
            if (treePath == null || treePath.getPathCount() != 2 || (rectangle2 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i))) == null) continue;
            graphics.drawLine(rectangle.x, rectangle2.y, rectangle.x + rectangle.width, rectangle2.y);
        }
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
    }

    private void treeModelChanged(@Nullable Object object, @Nullable Object object2) {
        TreeModel treeModel;
        if (object instanceof TreeModel) {
            treeModel = (TreeModel)object;
            treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (object2 instanceof TreeModel) {
            treeModel = (TreeModel)object2;
            treeModel.addTreeModelListener(this.treeModelListener);
        }
        this._isShallowSideBar = null;
    }

    @Override
    protected boolean isLocationInExpandControl(@Nullable TreePath treePath, int n, int n2) {
        Point point;
        if (treePath != null && !this.treeModel.isLeaf(treePath.getLastPathComponent()) && (point = this.getExpandControlCenter(treePath)) != null) {
            return Math.abs(n - point.x) < 8;
        }
        return false;
    }

    @Override
    protected void paintExpandControl(@NotNull Graphics graphics, @NotNull Rectangle rectangle, @NotNull Insets insets, Rectangle rectangle2, @NotNull TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object = treePath.getLastPathComponent();
        if (bl3 || bl2 && this.treeModel.getChildCount(object) <= 0) {
            return;
        }
        if (this.isCategory(treePath) && !treePath.equals(this.pathWithVisibleExpandControl)) {
            return;
        }
        Point point = this.getExpandControlCenter(treePath);
        if (point != null) {
            this.drawExpandControl(graphics, treePath, bl, point);
        }
    }

    protected void drawExpandControl(@NotNull Graphics graphics, @NotNull TreePath treePath, boolean bl, @NotNull Point point) {
        Icon icon;
        Icon icon2 = icon = bl ? this.getExpandedIcon() : this.getCollapsedIcon();
        if (icon != null && !(icon instanceof UIResource)) {
            this.drawCentered(this.tree, graphics, icon, point.x, point.y);
        } else {
            AquaUIPainter.State state = this.getState(treePath);
            if (!this.fIsInBounds && state == AquaUIPainter.State.PRESSED) {
                state = AquaUIPainter.State.ACTIVE;
            }
            boolean bl2 = AquaUtils.isLeftToRight(this.tree);
            Configuration configuration = this.getDisclosureTriangleConfiguration(state, bl, bl2);
            LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo((LayoutConfiguration)((Object)configuration));
            int n = (int)Math.ceil(layoutInfo.getFixedVisualWidth());
            int n2 = (int)Math.ceil(layoutInfo.getFixedVisualHeight());
            if (n == 0) {
                n = 20;
            }
            if (n2 == 0) {
                n2 = n;
            }
            int n3 = point.x - n / 2;
            int n4 = point.y - n2 / 2;
            AquaUtils.configure(this.painter, this.tree, n, n2);
            this.painter.getPainter(configuration).paint(graphics, n3, n4);
        }
    }

    @Nullable
    protected Point getExpandControlCenter(@NotNull TreePath treePath) {
        boolean bl = AquaUtils.isLeftToRight(this.tree);
        Insets insets = this.tree.getInsets();
        Rectangle rectangle = this.getPathBounds(treePath, insets, null);
        if (rectangle == null) {
            return null;
        }
        int n = rectangle.y + rectangle.height / 2;
        int n2 = this.getIndentation(treePath.getPathCount() - 1);
        int n3 = this.expandControlWidth / 2;
        int n4 = bl ? (this.useTrailingExpandControl(treePath) ? this.tree.getWidth() - n3 / 2 - this.trailingExpandControlInset : insets.left + n2 - (n3 / 2 + this.leadingExpandControlSeparation)) : (this.useTrailingExpandControl(treePath) ? n3 + this.trailingExpandControlInset : this.tree.getWidth() - (n2 + insets.right) + (this.leadingExpandControlSeparation + n3 / 2));
        return new Point(n4, n);
    }

    @Nullable
    protected Rectangle getExpandControlBounds(@NotNull TreePath treePath) {
        Rectangle rectangle;
        Point point = this.getExpandControlCenter(treePath);
        if (point != null && (rectangle = this.getPathBounds(treePath, this.tree.getInsets(), null)) != null) {
            return new Rectangle(point.x - this.expandControlWidth / 2, rectangle.y, this.expandControlWidth, rectangle.height);
        }
        return null;
    }

    @Override
    public void setExpandedIcon(@Nullable Icon icon) {
        super.setExpandedIcon(icon);
        this.updateExpandControlSize();
    }

    @Override
    public void setCollapsedIcon(Icon icon) {
        super.setCollapsedIcon(icon);
        this.updateExpandControlSize();
    }

    protected void updateExpandControlSize() {
        int n = 0;
        Icon icon = this.getExpandedIcon();
        if (icon != null) {
            n = Math.max(n, icon.getIconWidth());
        }
        if ((icon = this.getCollapsedIcon()) != null) {
            n = Math.max(n, icon.getIconWidth());
        }
        if (n == 0) {
            Configuration configuration = this.getDisclosureTriangleConfiguration(AquaUIPainter.State.ACTIVE, true, true);
            LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo((LayoutConfiguration)((Object)configuration));
            n = (int)Math.ceil(layoutInfo.getFixedVisualWidth());
            if (n == 0) {
                n = 20;
            }
        }
        this.expandControlWidth = n;
    }

    protected Configuration getDisclosureTriangleConfiguration(AquaUIPainter.State state, boolean bl, boolean bl2) {
        AquaUIPainter.UILayoutDirection uILayoutDirection;
        AquaUIPainter.ButtonWidget buttonWidget = AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE;
        AquaUIPainter.Size size = AquaUIPainter.Size.REGULAR;
        boolean bl3 = false;
        AquaUIPainter.ButtonState buttonState = bl ? AquaUIPainter.ButtonState.ON : AquaUIPainter.ButtonState.OFF;
        AquaUIPainter.UILayoutDirection uILayoutDirection2 = uILayoutDirection = bl2 ? AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT : AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT;
        if (this.fAnimationTransition >= 0.0f) {
            AquaUIPainter.ButtonState buttonState2 = buttonState == AquaUIPainter.ButtonState.ON ? AquaUIPainter.ButtonState.OFF : AquaUIPainter.ButtonState.ON;
            return new AnimatedButtonConfiguration(buttonWidget, size, state, bl3, buttonState, uILayoutDirection, buttonState2, this.fAnimationTransition);
        }
        return new ButtonConfiguration(buttonWidget, size, state, bl3, buttonState, uILayoutDirection);
    }

    @Override
    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        ImageIcon imageIcon;
        Image image;
        n = this.findCenteredX(n, icon.getIconWidth());
        n2 -= icon.getIconHeight() / 2;
        if (icon instanceof ImageIcon && AquaImageFactory.isTemplateImage(image = (imageIcon = (ImageIcon)icon).getImage())) {
            Color color = this.getIconColor();
            Image image2 = AquaImageFactory.getProcessedImage(image, (Object)color);
            boolean bl = graphics.drawImage(image2, n, n2, component);
            if (!bl) {
                new ImageIcon(image2);
                if (!graphics.drawImage(image2, n, n2, component)) {
                    Utils.logError("Button icon not drawn!");
                }
            }
            return;
        }
        icon.paintIcon(component, graphics, n, n2);
    }

    @NotNull
    public Insets getInsets() {
        boolean bl = this.isInset();
        boolean bl2 = this.isSideBar();
        int n = 0;
        int n2 = 0;
        int n3 = bl ? (bl2 ? 18 : 10) : (bl2 ? 9 : 1);
        int n4 = bl ? 20 : 1;
        boolean bl3 = AquaUtils.isLeftToRight(this.tree);
        if (bl3) {
            return new Insets(n, n3, n2, n4);
        }
        return new Insets(n, n4, n2, n3);
    }

    @NotNull
    protected Color getIconColor() {
        return AquaColors.getSystemColor(this.tree, "expandControl");
    }

    private int findCenteredX(int n, int n2) {
        return this.tree.getComponentOrientation().isLeftToRight() ? n - (int)Math.ceil((double)n2 / 2.0) : n - (int)Math.floor((double)n2 / 2.0);
    }

    @Override
    public Icon getCollapsedIcon() {
        Icon icon = super.getCollapsedIcon();
        if (AquaUtils.isLeftToRight(this.tree)) {
            return icon;
        }
        if (!(icon instanceof UIResource)) {
            return icon;
        }
        return UIManager.getIcon("Tree.rightToLeftCollapsedIcon");
    }

    protected AquaUIPainter.State getState(TreePath treePath) {
        if (!this.tree.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        if (this.fIsPressed && this.fTrackingPath.equals(treePath)) {
            return AquaUIPainter.State.PRESSED;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    protected void checkForClickInExpandControl(TreePath treePath, int n, int n2) {
        throw new AssertionError((Object)"Method checkForClickInExpandControl should not be called");
    }

    public boolean isExpandOperation(@NotNull TreePath treePath, int n, int n2) {
        return this.isLocationInExpandControl(treePath, n, n2) || this.isCategory(treePath);
    }

    @Override
    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        throw new AssertionError((Object)"Method handleExpandControlClick should not be called");
    }

    @Override
    protected void toggleExpandState(TreePath treePath) {
        TreePath[] treePathArray;
        if (this.tree.isExpanded(treePath) && this.isCategory(treePath) && (treePathArray = this.tree.getSelectionPaths()) != null) {
            for (TreePath treePath2 : treePathArray) {
                if (!treePath.isDescendant(treePath2)) continue;
                this.tree.removeSelectionPath(treePath2);
            }
        }
        super.toggleExpandState(treePath);
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isMetaDown();
    }

    @Override
    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new TreeNodeDimensions();
    }

    @Override
    protected AbstractLayoutCache createLayoutCache() {
        if (this.isLargeModel() && this.getRowHeight() > 0) {
            return new FixedHeightLayoutCache();
        }
        return new MyVariableHeightLayoutCache();
    }

    protected void updateCellSizes() {
        int n = Math.max(this.tree.getRowHeight(), -1);
        LookAndFeel.installProperty(this.tree, "rowHeight", n + 1);
        LookAndFeel.installProperty(this.tree, "rowHeight", n);
        this.updateSize();
    }

    private int getStyleRowSpacingAbove(int n) {
        TreePath treePath;
        if (this.isSideBar() && (treePath = this.getPathForRow(this.tree, n)) != null && treePath.getPathCount() == 2) {
            if (OSXSystemProperties.OSVersion >= 1016) {
                return 14;
            }
            return 9;
        }
        return 0;
    }

    private int getStyleRowHeight(int n) {
        if (this.isSideBar()) {
            boolean bl = this.isCategory(n);
            if (this.isInset()) {
                return bl ? 18 : 28;
            }
            return bl ? 22 : 24;
        }
        return 0;
    }

    protected void updateDropTargetListener() {
        DropTarget dropTarget = this.tree.getDropTarget();
        if (dropTarget instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TreeDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected int getRowForPath(TreePath treePath) {
        return this.treeState.getRowForPath(treePath);
    }

    @Nullable
    private Rectangle getPathBounds(TreePath treePath, Insets insets, Rectangle rectangle) {
        if ((rectangle = this.treeState.getBounds(treePath, rectangle)) != null) {
            rectangle.x = AquaUtils.isLeftToRight(this.tree) ? (rectangle.x += insets.left) : this.tree.getWidth() - (rectangle.x + rectangle.width) - insets.right;
            rectangle.y += insets.top;
        }
        return rectangle;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.tree.getActionMap().put("aquaExpandNode", new KeyboardExpandCollapseAction(true, false));
        this.tree.getActionMap().put("aquaCollapseNode", new KeyboardExpandCollapseAction(false, false));
        this.tree.getActionMap().put("aquaFullyExpandNode", new KeyboardExpandCollapseAction(true, true));
        this.tree.getActionMap().put("aquaFullyCollapseNode", new KeyboardExpandCollapseAction(false, true));
    }

    private void expandNode(int n, boolean bl) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath == null) {
            return;
        }
        this.tree.expandPath(treePath);
        if (!bl) {
            return;
        }
        this.expandAllNodes(treePath, n + 1);
    }

    private void expandAllNodes(TreePath treePath, int n) {
        int n2 = n;
        TreePath treePath2;
        while (treePath.isDescendant(treePath2 = this.getPathForRow(this.tree, n2))) {
            this.tree.expandPath(treePath2);
            ++n2;
        }
        return;
    }

    private void collapseNode(int n, boolean bl) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath == null) {
            return;
        }
        if (bl) {
            this.collapseAllNodes(treePath, n + 1);
        }
        this.tree.collapsePath(treePath);
    }

    private void collapseAllNodes(TreePath treePath, int n) {
        TreePath treePath2;
        int n2 = -1;
        int n3 = n;
        while (n2 == -1) {
            treePath2 = this.getPathForRow(this.tree, n3);
            if (!treePath.isDescendant(treePath2)) {
                n2 = n3 - 1;
            }
            ++n3;
        }
        for (n3 = n2; n3 >= n; --n3) {
            treePath2 = this.getPathForRow(this.tree, n3);
            this.tree.collapsePath(treePath2);
        }
    }

    protected static JTree getComponent(DropTargetEvent dropTargetEvent) {
        DropTargetContext dropTargetContext = dropTargetEvent.getDropTargetContext();
        return (JTree)dropTargetContext.getComponent();
    }

    protected class EditingComponentFocusListener
    implements FocusListener {
        protected EditingComponentFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                AquaTreeUI.this.stopEditing(AquaTreeUI.this.tree);
            }
        }
    }

    class AquaTreeComponentListener
    extends ComponentAdapter {
        AquaTreeComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (AquaTreeUI.this.isCellFilled && AquaTreeUI.this.treeState != null) {
                AquaTreeUI.this.treeState.invalidateSizes();
            }
        }
    }

    class AquaTreeModelListener
    implements TreeModelListener {
        AquaTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.treeModelChanged();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.treeModelChanged();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.treeModelChanged();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.treeModelChanged();
        }

        private void treeModelChanged() {
            AquaTreeUI.this._isShallowSideBar = null;
        }
    }

    class AquaTreeHierarchyListener
    implements HierarchyListener {
        AquaTreeHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 2L) != 0L) {
                AquaTreeUI.this.updateSideBarConfiguration();
            }
        }
    }

    protected class SidebarVibrantEffects
    extends VisualEffectView {
        protected TreeSelectionBoundsTracker bt;

        public SidebarVibrantEffects(final JComponent jComponent) {
            super(jComponent, 2, true);
            this.bt = new TreeSelectionBoundsTracker(AquaTreeUI.this.tree, this::updateSelectionBackgrounds){

                @Override
                protected int convertRowYCoordinateToSelectionDescription(int n) {
                    if (jComponent != this.tree) {
                        Point point = SwingUtilities.convertPoint(this.tree, 0, n, jComponent);
                        return point.y;
                    }
                    return n;
                }
            };
        }

        public void update() {
            if (this.bt != null) {
                this.bt.update();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.bt != null) {
                this.bt.dispose();
                this.bt = null;
            }
        }

        @Override
        protected void windowChanged(Window window) {
            super.windowChanged(window);
            if (this.bt != null) {
                this.bt.reset();
            }
        }
    }

    protected class FocusHandler
    extends BasicTreeUI.FocusHandler {
        protected FocusHandler() {
            super(AquaTreeUI.this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            this.focusChanged();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            this.focusChanged();
        }

        private void focusChanged() {
            AquaTreeUI.this.configureAppearanceContext(null);
        }
    }

    public class MacPropertyChangeHandler
    extends BasicTreeUI.PropertyChangeHandler {
        public MacPropertyChangeHandler() {
            super(AquaTreeUI.this);
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || propertyChangeEvent.getSource() != AquaTreeUI.this.tree) {
                return;
            }
            if (string.equals("leadSelectionPath") && AquaTreeUI.this.ignoreLAChange) {
                return;
            }
            if (string.equals("anchorSelectionPath") && AquaTreeUI.this.ignoreLAChange) {
                return;
            }
            if (string.equals("enabled")) {
                AquaTreeUI.this.configureAppearanceContext(null);
            } else {
                if ("Aqua.displayAsFocused".equals(string)) {
                    AquaTreeUI.this.configureAppearanceContext(null);
                    return;
                }
                if (AquaTreeUI.this.isStyleProperty(string)) {
                    AquaTreeUI.this.updateStyleProperties();
                    return;
                }
                if (AquaTreeUI.this.isViewStyleProperty(string)) {
                    AquaTreeUI.this.updateInset();
                    return;
                }
                if (AquaTreeUI.this.isCellFilledProperty(string)) {
                    AquaTreeUI.this.updateCellFilled();
                    return;
                }
                if (string.equals("transferHandler")) {
                    AquaTreeUI.this.updateDropTargetListener();
                    return;
                }
                if (string.equals("cellEditor")) {
                    AquaTreeUI.this.cellEditorChanged();
                } else if (string.equals("cellRenderer")) {
                    AquaTreeUI.this.cellRendererChanged();
                } else if (string.equals("model")) {
                    AquaTreeUI.this.treeModelChanged(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                } else if (string.equals("ancestor")) {
                    AquaTreeUI.this.updateSideBarConfiguration();
                }
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    protected class MyFont
    extends Font {
        public MyFont(Font font) {
            super(font);
        }
    }

    protected class TreeNodeDimensions
    extends BasicTreeUI.NodeDimensionsHandler {
        protected TreeNodeDimensions() {
            super(AquaTreeUI.this);
        }

        @Override
        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            if (AquaTreeMouseBehavior.isDebug) {
                Utils.logDebug("Requesting node dimensions for " + object + " with depth " + n2);
            }
            Rectangle rectangle2 = this.getBasicNodeDimensions(object, n, n2, bl, rectangle);
            if (AquaTreeUI.this.isCellFilled && rectangle2 != null && (AquaTreeUI.this.editingComponent == null || AquaTreeUI.this.editingRow != n) && AquaTreeUI.this.tree.getWidth() > 0) {
                Insets insets = AquaTreeUI.this.tree.getInsets();
                int n3 = AquaTreeUI.this.tree.getWidth() - (insets.left + insets.right) - rectangle2.x;
                if (AquaTreeUI.this.isCategory(n2)) {
                    n3 -= 5;
                }
                rectangle2.width = n3;
            }
            return rectangle2;
        }

        public Rectangle getBasicNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            if (AquaTreeUI.this.editingComponent != null && AquaTreeUI.this.editingRow == n) {
                Dimension dimension = AquaTreeUI.this.editingComponent.getPreferredSize();
                return AquaTreeUI.this.computeRowBounds(n2, dimension, rectangle);
            }
            if (AquaTreeUI.this.currentCellRenderer != null) {
                boolean bl2 = true;
                Component component = AquaTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(AquaTreeUI.this.tree, object, bl2, bl, AquaTreeUI.this.treeModel.isLeaf(object), n, false);
                boolean bl3 = AquaTreeUI.this.isCategory(n2);
                AquaTreeUI.this.configureCellRenderer(true, component, bl3, bl2);
                if (AquaTreeUI.this.tree != null) {
                    AquaTreeUI.this.rendererPane.add(component);
                    component.validate();
                }
                Dimension dimension = component.getPreferredSize();
                AquaTreeUI.this.unconfigureCellRenderer(component);
                return AquaTreeUI.this.computeRowBounds(n2, dimension, rectangle);
            }
            return null;
        }
    }

    protected class MyVariableHeightLayoutCache
    extends ExtendedVariableHeightLayoutCache {
        protected MyVariableHeightLayoutCache() {
        }

        @Override
        protected int getRowSpacingAbove(int n) {
            return AquaTreeUI.this.getStyleRowSpacingAbove(n);
        }
    }

    public static class TreeDropTargetListener
    extends DropTargetAdapter {
        private boolean isStateSaved;
        private int[] selectedIndices;

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            JTree jTree = AquaTreeUI.getComponent(dropTargetDragEvent);
            TransferHandler transferHandler = jTree.getTransferHandler();
            if (transferHandler.canImport(jTree, dropTargetDragEvent.getCurrentDataFlavors())) {
                this.saveComponentState(jTree);
                this.isStateSaved = true;
            } else {
                this.isStateSaved = false;
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            JTree jTree = AquaTreeUI.getComponent(dropTargetDragEvent);
            TransferHandler transferHandler = jTree.getTransferHandler();
            if (transferHandler.canImport(jTree, dropTargetDragEvent.getCurrentDataFlavors())) {
                this.updateInsertionLocation(jTree, dropTargetDragEvent.getLocation());
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (this.isStateSaved) {
                JTree jTree = AquaTreeUI.getComponent(dropTargetEvent);
                this.restoreComponentState(jTree);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
        }

        protected void saveComponentState(JTree jTree) {
            this.selectedIndices = jTree.getSelectionRows();
        }

        protected void restoreComponentState(JTree jTree) {
            jTree.setSelectionRows(this.selectedIndices);
        }

        protected void updateInsertionLocation(JTree jTree, Point point) {
            BasicTreeUI basicTreeUI = (BasicTreeUI)jTree.getUI();
            TreePath treePath = basicTreeUI.getClosestPathForLocation(jTree, point.x, point.y);
            if (treePath != null) {
                jTree.setSelectionPath(treePath);
            }
        }
    }

    class KeyboardExpandCollapseAction
    extends AbstractAction {
        private final boolean expand;
        private final boolean recursive;

        public KeyboardExpandCollapseAction(boolean bl, boolean bl2) {
            this.expand = bl;
            this.recursive = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AquaTreeUI.this.tree == null || 0 > AquaTreeUI.this.getRowCount(AquaTreeUI.this.tree)) {
                return;
            }
            TreePath[] treePathArray = AquaTreeUI.this.tree.getSelectionPaths();
            if (treePathArray == null) {
                return;
            }
            for (int i = treePathArray.length - 1; i >= 0; --i) {
                TreePath treePath = treePathArray[i];
                if (this.expand) {
                    AquaTreeUI.this.expandNode(AquaTreeUI.this.tree.getRowForPath(treePath), this.recursive);
                    continue;
                }
                if (treePathArray.length == 1 && AquaTreeUI.this.tree.isCollapsed(treePath)) {
                    TreePath treePath2 = treePath.getParentPath();
                    if (treePath2 == null || treePath2.getParentPath() == null && !AquaTreeUI.this.tree.isRootVisible()) continue;
                    AquaTreeUI.this.tree.scrollPathToVisible(treePath2);
                    if (AquaTreeUI.this.isCategory(treePath2)) continue;
                    AquaTreeUI.this.tree.setSelectionPath(treePath2);
                    continue;
                }
                AquaTreeUI.this.collapseNode(AquaTreeUI.this.tree.getRowForPath(treePath), this.recursive);
            }
        }

        @Override
        public boolean isEnabled() {
            return AquaTreeUI.this.tree != null && AquaTreeUI.this.tree.isEnabled();
        }
    }
}

