/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.ContextualColor;

public class StripedContainerContextualColors
implements ContainerContextualColors {
    @NotNull
    protected ContextualColor containerBackground;
    @NotNull
    protected ContextualColor evenRowBackground;
    @NotNull
    protected ContextualColor oddRowBackground;
    @NotNull
    protected ContextualColor grid;
    protected boolean isRowSelected;
    @NotNull
    protected ContextualColor background;
    @NotNull
    protected ContextualColor foreground;

    public StripedContainerContextualColors(@NotNull ContextualColor contextualColor, @NotNull ContextualColor contextualColor2, @NotNull ContextualColor contextualColor3, @NotNull ContextualColor contextualColor4, @NotNull ContextualColor contextualColor5) {
        this.containerBackground = contextualColor;
        this.evenRowBackground = contextualColor2;
        this.oddRowBackground = contextualColor3;
        this.grid = contextualColor5;
        this.background = contextualColor;
        this.foreground = contextualColor4;
    }

    @Override
    public void configureForContainer() {
        this.isRowSelected = false;
        this.background = this.containerBackground;
    }

    @Override
    public void configureForRow(int n, boolean bl) {
        this.isRowSelected = bl;
        this.background = n % 2 == 0 ? this.evenRowBackground : this.oddRowBackground;
    }

    @Override
    public void configureForRow(boolean bl) {
        this.isRowSelected = bl;
        this.background = this.containerBackground;
    }

    @Override
    public boolean isStriped() {
        return true;
    }

    @Override
    @NotNull
    public Color getBackground(@NotNull AppearanceContext appearanceContext) {
        appearanceContext = appearanceContext.withSelected(this.isRowSelected || appearanceContext.isSelected());
        return this.background.get(appearanceContext);
    }

    @Override
    @NotNull
    public Color getForeground(@NotNull AppearanceContext appearanceContext) {
        appearanceContext = appearanceContext.withSelected(this.isRowSelected || appearanceContext.isSelected());
        return this.foreground.get(appearanceContext);
    }

    @Override
    @NotNull
    public Color getGrid(@NotNull AppearanceContext appearanceContext) {
        appearanceContext = appearanceContext.withSelected(this.isRowSelected || appearanceContext.isSelected());
        return this.grid.get(appearanceContext);
    }
}

