/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;
import org.violetlib.geom.GeneralRoundRectangle;

class GeneralRoundRectIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    double tlaw;
    double tlah;
    double traw;
    double trah;
    double braw;
    double brah;
    double blaw;
    double blah;
    AffineTransform affine;
    int index;
    int cornerIndex;
    double[] arcWidths;
    double[] arcHeights;
    private static final double angle = 0.7853981633974483;
    private static final double a = 1.0 - Math.cos(0.7853981633974483);
    private static final double b = Math.tan(0.7853981633974483);
    private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
    private static final double cv = 1.3333333333333333 * a * b / c;
    private static final double acv = (1.0 - cv) / 2.0;
    private static double[][] ctrlpts = new double[][]{{0.0, 0.0, 0.0, 0.5}, {0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 1.0, -acv, 0.0, acv, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0}, {1.0, -0.5, 1.0, 0.0}, {1.0, -acv, 1.0, 0.0, 1.0, 0.0, 1.0, -acv, 1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 0.0, acv, 1.0, -acv, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}, {0.0, acv, 0.0, 0.0, 0.0, 0.0, 0.0, acv, 0.0, 0.0, 0.0, 0.5}, new double[0]};
    private static int[] types = new int[]{0, 1, 3, 1, 3, 1, 3, 1, 3, 4};

    GeneralRoundRectIterator(GeneralRoundRectangle rr, AffineTransform at) {
        this.x = rr.getX();
        this.y = rr.getY();
        this.w = rr.getWidth();
        this.h = rr.getHeight();
        this.tlaw = Math.min(this.w, Math.abs(rr.getTopLeftArcWidth()));
        this.tlah = Math.min(this.h, Math.abs(rr.getTopLeftArcHeight()));
        this.traw = Math.min(this.w, Math.abs(rr.getTopRightArcWidth()));
        this.trah = Math.min(this.h, Math.abs(rr.getTopRightArcHeight()));
        this.braw = Math.min(this.w, Math.abs(rr.getBottomRightArcWidth()));
        this.brah = Math.min(this.h, Math.abs(rr.getBottomRightArcHeight()));
        this.blaw = Math.min(this.w, Math.abs(rr.getBottomLeftArcWidth()));
        this.blah = Math.min(this.h, Math.abs(rr.getBottomLeftArcHeight()));
        this.affine = at;
        if (this.tlaw < 0.0 || this.tlah < 0.0 || this.traw < 0.0 || this.trah < 0.0 || this.braw < 0.0 || this.brah < 0.0 || this.blaw < 0.0 || this.blah < 0.0) {
            this.index = ctrlpts.length;
        }
        this.arcWidths = new double[]{this.tlaw, this.blaw, this.braw, this.traw};
        this.arcHeights = new double[]{this.tlah, this.blah, this.brah, this.trah};
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index >= ctrlpts.length;
    }

    @Override
    public void next() {
        ++this.index;
        if (this.index % 2 == 1) {
            ++this.cornerIndex;
            if (this.cornerIndex >= 4) {
                this.cornerIndex = 0;
            }
        }
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("GeneralRoundRect iterator out of bounds");
        }
        double[] ctrls = ctrlpts[this.index];
        int nc = 0;
        for (int i = 0; i < ctrls.length; i += 4) {
            coords[nc++] = (float)(this.x + ctrls[i + 0] * this.w + ctrls[i + 1] * this.arcWidths[this.cornerIndex]);
            coords[nc++] = (float)(this.y + ctrls[i + 2] * this.h + ctrls[i + 3] * this.arcHeights[this.cornerIndex]);
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, nc / 2);
        }
        return types[this.index];
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("GeneralRoundRect iterator out of bounds");
        }
        double[] ctrls = ctrlpts[this.index];
        int nc = 0;
        for (int i = 0; i < ctrls.length; i += 4) {
            coords[nc++] = this.x + ctrls[i + 0] * this.w + ctrls[i + 1] * this.arcWidths[this.cornerIndex];
            coords[nc++] = this.y + ctrls[i + 2] * this.h + ctrls[i + 3] * this.arcHeights[this.cornerIndex];
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, nc / 2);
        }
        return types[this.index];
    }
}

