/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.ProgressIndicatorLayoutConfiguration;
import org.violetlib.jnr.impl.JNRUtils;

public class ProgressIndicatorConfiguration
extends ProgressIndicatorLayoutConfiguration
implements Configuration {
    @NotNull
    private final AquaUIPainter.State state;
    private final double value;
    @NotNull
    private final AquaUIPainter.UILayoutDirection ld;

    public ProgressIndicatorConfiguration(@NotNull AquaUIPainter.ProgressWidget pw, @NotNull AquaUIPainter.Size sz, @NotNull AquaUIPainter.State state, @NotNull AquaUIPainter.Orientation o, double value, @NotNull AquaUIPainter.UILayoutDirection ld) {
        super(pw, sz, o);
        this.state = state;
        this.value = value;
        this.ld = ld;
    }

    public ProgressIndicatorConfiguration(@NotNull ProgressIndicatorLayoutConfiguration g, @NotNull AquaUIPainter.State state, double value, @NotNull AquaUIPainter.UILayoutDirection ld) {
        super(g);
        this.state = state;
        this.value = value;
        this.ld = ld;
    }

    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    public double getValue() {
        return this.value;
    }

    @NotNull
    public AquaUIPainter.UILayoutDirection getLayoutDirection() {
        return this.ld;
    }

    public boolean isLeftToRight() {
        return this.ld == AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgressIndicatorConfiguration that = (ProgressIndicatorConfiguration)o;
        return this.state == that.state && this.value == that.value && this.ld == that.ld;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.state, this.value, this.ld});
    }

    @Override
    @NotNull
    public String toString() {
        String lds = this.ld == AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT ? " RTL" : "";
        return super.toString() + " " + (Object)((Object)this.state) + " " + JNRUtils.format2(this.value) + lds;
    }
}

