/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.TitleBarLayoutConfiguration;

public class TitleBarConfiguration
extends TitleBarLayoutConfiguration
implements Configuration {
    @NotNull
    private final AquaUIPainter.State titleBarState;
    @NotNull
    private final AquaUIPainter.State closeButtonState;
    @NotNull
    private final AquaUIPainter.State minimizeButtonState;
    @NotNull
    private final AquaUIPainter.State resizeButtonState;
    @NotNull
    private final ResizeAction resizeAction;
    private final boolean isDirty;

    public TitleBarConfiguration(@NotNull AquaUIPainter.TitleBarWidget tw, @NotNull AquaUIPainter.State titleBarState, @NotNull AquaUIPainter.State closeButtonState, @NotNull AquaUIPainter.State minimizeButtonState, @NotNull AquaUIPainter.State resizeButtonState, @NotNull ResizeAction resizeAction, boolean isDirty) {
        super(tw);
        boolean isActive = titleBarState != AquaUIPainter.State.INACTIVE && titleBarState != AquaUIPainter.State.DISABLED && titleBarState != AquaUIPainter.State.DISABLED_INACTIVE;
        AquaUIPainter.State state = titleBarState = isActive ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE;
        if (isActive && closeButtonState == AquaUIPainter.State.INACTIVE) {
            closeButtonState = AquaUIPainter.State.ACTIVE;
        }
        if (tw != AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW) {
            if (resizeAction == ResizeAction.FULL_SCREEN_ENTER) {
                resizeAction = ResizeAction.ZOOM_ENTER;
            } else if (resizeAction == ResizeAction.FULL_SCREEN_EXIT) {
                resizeAction = ResizeAction.ZOOM_EXIT;
            }
        }
        this.titleBarState = titleBarState;
        this.closeButtonState = closeButtonState;
        this.minimizeButtonState = minimizeButtonState;
        this.resizeButtonState = resizeButtonState;
        this.resizeAction = resizeAction;
        this.isDirty = isDirty;
    }

    @NotNull
    public AquaUIPainter.State getTitleBarState() {
        return this.titleBarState;
    }

    @NotNull
    public AquaUIPainter.State getCloseButtonState() {
        return this.closeButtonState;
    }

    @NotNull
    public AquaUIPainter.State getMinimizeButtonState() {
        return this.minimizeButtonState;
    }

    @NotNull
    public AquaUIPainter.State getResizeButtonState() {
        return this.resizeButtonState;
    }

    @NotNull
    public ResizeAction getResizeAction() {
        return this.resizeAction;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TitleBarConfiguration that = (TitleBarConfiguration)o;
        return this.titleBarState == that.titleBarState && this.closeButtonState == that.closeButtonState && this.minimizeButtonState == that.minimizeButtonState && this.resizeButtonState == that.resizeButtonState && this.resizeAction == that.resizeAction && this.isDirty == that.isDirty;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.titleBarState, this.closeButtonState, this.minimizeButtonState, this.resizeButtonState, this.resizeAction, this.isDirty});
    }

    @Override
    @NotNull
    public String toString() {
        String ds = this.isDirty ? " dirty" : "";
        return super.toString() + " " + (Object)((Object)this.titleBarState) + ds + " close:" + (Object)((Object)this.closeButtonState) + " minimize:" + (Object)((Object)this.minimizeButtonState) + " resize:" + (Object)((Object)this.resizeButtonState) + " " + (Object)((Object)this.resizeAction);
    }

    public static enum ResizeAction {
        FULL_SCREEN_ENTER,
        FULL_SCREEN_EXIT,
        ZOOM_ENTER,
        ZOOM_EXIT;

    }
}

